/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.micrometer;

import io.helidon.config.Config;
import io.helidon.integrations.micrometer.MeterRegistryFactory;
import io.helidon.servicecommon.rest.HelidonRestServiceSupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class MicrometerSupport
extends HelidonRestServiceSupport {
    static final String DEFAULT_CONTEXT = "/micrometer";
    private static final String SERVICE_NAME = "Micrometer";
    private final MeterRegistryFactory meterRegistryFactory;

    private MicrometerSupport(Builder builder) {
        super(Logger.getLogger(MicrometerSupport.class.getName()), (HelidonRestServiceSupport.Builder)builder, SERVICE_NAME);
        this.meterRegistryFactory = builder.meterRegistryFactorySupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MicrometerSupport create() {
        return MicrometerSupport.builder().build();
    }

    public static MicrometerSupport create(Config config) {
        return ((Builder)MicrometerSupport.builder().config(config)).build();
    }

    public MeterRegistry registry() {
        return this.meterRegistryFactory.meterRegistry();
    }

    public void update(Routing.Rules rules) {
        this.configureEndpoint(rules, rules);
    }

    protected void postConfigureEndpoint(Routing.Rules defaultRules, Routing.Rules serviceEndpointRoutingRules) {
        defaultRules.any(new Handler[]{new MetricsContextHandler(this.registry())}).get(this.context(), new Handler[]{this::getOrOptions}).options(this.context(), new Handler[]{this::getOrOptions});
    }

    private void getOrOptions(ServerRequest serverRequest, ServerResponse serverResponse) {
        this.meterRegistryFactory.matchingHandler(serverRequest, serverResponse).accept(serverRequest, serverResponse);
    }

    private static final class MetricsContextHandler
    implements Handler {
        private final MeterRegistry meterRegistry;

        private MetricsContextHandler(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        public void accept(ServerRequest req, ServerResponse res) {
            req.context().register((Object)this.meterRegistry);
            req.next();
        }
    }

    public static class Builder
    extends HelidonRestServiceSupport.Builder<MicrometerSupport, Builder>
    implements io.helidon.common.Builder<MicrometerSupport> {
        private Supplier<MeterRegistryFactory> meterRegistryFactorySupplier = null;

        private Builder() {
            super(Builder.class, MicrometerSupport.DEFAULT_CONTEXT);
        }

        public MicrometerSupport build() {
            if (null == this.meterRegistryFactorySupplier) {
                this.meterRegistryFactorySupplier = () -> MeterRegistryFactory.getInstance(MeterRegistryFactory.builder().config(this.config()));
            }
            return new MicrometerSupport(this);
        }

        public Builder meterRegistryFactorySupplier(MeterRegistryFactory meterRegistryFactory) {
            this.meterRegistryFactorySupplier = () -> meterRegistryFactory;
            return this;
        }
    }
}

