/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.integrations.langchain4j.codegen.LangchainTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

enum ModelType {
    CHAT_MODEL("chat-model"),
    STREAMING_CHAT_MODEL("streaming-chat-model"),
    LANGUAGE_MODEL("language-model"),
    EMBEDDING_MODEL("embedding-model"),
    EMBEDDING_STORE("embedding-store"),
    MODERATION_MODEL("moderation-model"),
    IMAGE_MODEL("image-model"),
    SCORING_MODEL("scoring-model");

    private final String key;
    private static final Map<TypeName, ModelType> MAP;

    private ModelType(String configKey) {
        this.key = configKey;
    }

    String configKey() {
        return this.key;
    }

    static ModelType forType(TypeName type) {
        return MAP.get(type);
    }

    static ModelType forTypeInfo(TypeInfo typeInfo) {
        ArrayList<TypeInfo> lineage = new ArrayList<TypeInfo>();
        ModelType.allParents(typeInfo, lineage);
        for (TypeInfo t : lineage) {
            ModelType type = ModelType.forType(t.typeName());
            if (type == null) continue;
            return type;
        }
        throw new CodegenException("Type " + String.valueOf(typeInfo) + " is not recognized as supported model type.");
    }

    static void allParents(TypeInfo ti, List<TypeInfo> lineage) {
        lineage.add(ti);
        Optional t = ti.superTypeInfo();
        while (t.isPresent()) {
            ModelType.allParents((TypeInfo)t.get(), lineage);
            t = ((TypeInfo)t.get()).superTypeInfo();
        }
        for (TypeInfo i : ti.interfaceTypeInfo()) {
            ModelType.allParents(i, lineage);
        }
    }

    static {
        MAP = Map.of(LangchainTypes.LC_LANGUAGE_MODEL, LANGUAGE_MODEL, LangchainTypes.LC_CHAT_MODEL, CHAT_MODEL, LangchainTypes.LC_STREAMING_CHAT_MODEL, STREAMING_CHAT_MODEL, LangchainTypes.LC_EMBEDDING_MODEL, EMBEDDING_MODEL, LangchainTypes.LC_SCORING_MODEL, SCORING_MODEL, LangchainTypes.LC_MODERATION_MODEL, MODERATION_MODEL, LangchainTypes.LC_IMAGE_MODEL, IMAGE_MODEL, LangchainTypes.LC_EMBEDDING_STORE, EMBEDDING_STORE);
    }
}

