/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.RoundContext;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.integrations.langchain4j.codegen.LangchainTypes;
import io.helidon.integrations.langchain4j.codegen.LlmModelBlueprintBuilder;
import io.helidon.integrations.langchain4j.codegen.ModelCodegenHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ModelConfigCodegen
implements CodegenExtension {
    static final TypeName GENERATOR = TypeName.create(ModelConfigCodegen.class);
    static final Set<TypeName> GENERATED_CLASSES = new HashSet<TypeName>();

    ModelConfigCodegen() {
    }

    public void process(RoundContext roundContext) {
        Collection types = roundContext.types();
        for (TypeInfo type : types) {
            type.findAnnotation(LangchainTypes.MODEL_CONFIGS_TYPE).flatMap(a -> a.annotationValues()).or(() -> type.findAnnotation(LangchainTypes.MODEL_CONFIG_TYPE).map(List::of)).stream().flatMap(Collection::stream).forEach(modelAnnotation -> this.process(roundContext, type, (Annotation)modelAnnotation));
        }
    }

    private void process(RoundContext ctx, TypeInfo type, Annotation modelAnnotation) {
        TypeInfo modelType = (TypeInfo)modelAnnotation.typeValue().flatMap(arg_0 -> ((RoundContext)ctx).typeInfo(arg_0)).orElseThrow();
        TypeInfo modelBuilderType = this.resolveModelBuilderType(ctx, modelAnnotation);
        List skips = (List)modelAnnotation.stringValues("skip").orElseThrow();
        Set<String> nestedTypes = modelAnnotation.stringValues("nestedTypes").stream().flatMap(Collection::stream).collect(Collectors.toSet());
        String providerKey = modelAnnotation.stringValue("providerKey").filter(s -> !s.isEmpty()).or(() -> type.findAnnotation(LangchainTypes.MODEL_CONFIG_KEY_TYPE).flatMap(rec$ -> ((Annotation)rec$).stringValue())).filter(s -> !s.isEmpty()).or(() -> Optional.of(ModelCodegenHelper.providerConfigKeyFromClassName(type))).filter(s -> !s.isEmpty()).orElseThrow();
        LlmModelBlueprintBuilder blueprintBuilder = new LlmModelBlueprintBuilder(ctx, type, modelType, modelBuilderType, providerKey, modelAnnotation);
        blueprintBuilder.introspectBuilder(skips, nestedTypes);
        blueprintBuilder.buildAndAdd();
    }

    TypeInfo resolveModelBuilderType(RoundContext roundContext, Annotation modelConfigAnnotation) {
        return (TypeInfo)modelConfigAnnotation.typeValue("builder").filter(Predicate.not(arg_0 -> ((TypeName)TypeNames.BOXED_VOID).equals(arg_0))).or(() -> modelConfigAnnotation.typeValue().flatMap(arg_0 -> ((RoundContext)roundContext).typeInfo(arg_0)).stream().flatMap(ti -> ti.elementInfo().stream()).filter(m -> m.elementName().equals("builder")).filter(m -> m.parameterArguments().isEmpty()).map(m -> m.typeName()).findFirst()).flatMap(arg_0 -> ((RoundContext)roundContext).typeInfo(arg_0)).orElseThrow();
    }
}

