/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.integrations.langchain4j.codegen.IntrospectionBlueprintBuilder;
import io.helidon.integrations.langchain4j.codegen.LangchainTypes;
import io.helidon.integrations.langchain4j.codegen.ModelType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

class LlmModelBlueprintBuilder
extends IntrospectionBlueprintBuilder {
    private final String configRoot;
    private final String namePrefix;

    LlmModelBlueprintBuilder(RoundContext ctx, TypeInfo lc4jProviderTypeInfo, TypeInfo modelType, TypeInfo modelBuilderType, String providerKey, Annotation modelAnnotation) {
        super(ctx, modelType, lc4jProviderTypeInfo, modelBuilderType);
        this.namePrefix = modelAnnotation.typeValue().map(rec$ -> ((TypeName)rec$).className()).orElseThrow(() -> new CodegenException("Missing model class"));
        String modelTypeKey = ModelType.forTypeInfo(modelType).configKey();
        this.configRoot = "langchain4j." + providerKey + "." + modelTypeKey;
        TypeName blueprintTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(lc4jProviderTypeInfo.typeName().packageName())).className(this.namePrefix + "ConfigBlueprint")).build();
        this.initClassModel(blueprintTypeName, lc4jProviderTypeInfo.typeName(), Optional.of(lc4jProviderTypeInfo.typeName()));
        this.addEnableProperty();
    }

    @Override
    protected String configRoot() {
        return this.configRoot;
    }

    @Override
    protected Map<String, TypedElementInfo> resolveOverriddenProperties() {
        return this.parentTypeInfo().elementInfo().stream().filter(e -> e.kind().equals((Object)ElementKind.METHOD)).filter(e -> e.hasAnnotation(LangchainTypes.OPT_CONFIGURED)).collect(Collectors.toMap(info -> info.signature().name(), Function.identity()));
    }

    void addEnableProperty() {
        Method.Builder methodBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("enabled")).addAnnotation(Annotation.create((TypeName)LangchainTypes.OPT_CONFIGURED))).returnType(TypeNames.PRIMITIVE_BOOLEAN).javadoc(Javadoc.builder().add("If set to {@code false} (default), " + this.namePrefix + " will not be available even if configured.").returnDescription("whether " + this.namePrefix + " is enabled, defaults to {@code false}").build());
        this.classModelBuilder().addMethod(methodBuilder.build());
    }
}

