/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Returns;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ConfigureMethodBuilder {
    private final Method.Builder confMethodBuilder = Method.builder();
    private final List<TypedElementInfo> overriddenProperties = new ArrayList<TypedElementInfo>();

    ConfigureMethodBuilder(TypeInfo parentTypeInfo, TypeInfo builderTypeInfo, TypeName modelTypeName) {
        ((Method.Builder)((Method.Builder)this.confMethodBuilder.name("configuredBuilder")).returnType(Returns.builder().description("Actual Lc4j model builder configured with this blueprint.").type(builderTypeInfo.typeName()).build()).isDefault(true).addDescriptionLine("<b>Skipped:</b>")).addDescriptionLine("<ul>");
        Optional<TypedElementInfo> customBuilderMappingMethod = parentTypeInfo.elementInfo().stream().filter(m -> m.kind().equals((Object)ElementKind.METHOD)).filter(m -> m.parameterArguments().isEmpty()).filter(m -> m.typeName().equals((Object)builderTypeInfo.typeName())).filter(m -> m.elementName().equals("configuredBuilder")).findFirst();
        if (customBuilderMappingMethod.isPresent()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)this.confMethodBuilder.addContent("var modelBuilder = ")).addContent(parentTypeInfo.typeName())).addContent(".super.configuredBuilder(")).addContentLine(");");
        } else {
            ((Method.Builder)((Method.Builder)this.confMethodBuilder.addContent("var modelBuilder = ")).addContent(modelTypeName)).addContentLine(".builder();");
        }
    }

    void commentOverriddenProperty(TypedElementInfo modelBldMethod) {
        this.overriddenProperties.add(modelBldMethod);
    }

    void commentSkippedProperty(TypedElementInfo modelBldMethod, String reason) {
        this.confMethodBuilder.addDescriptionLine("<li>" + modelBldMethod.signature().name() + " - " + reason + "</li>");
    }

    void configureProperty(String propName, TypeName propType, boolean isNestedType, boolean toArray, boolean isOptional) {
        boolean isCollection = propType.isList() || propType.isSet() || propType.isMap() || propType.array();
        String line = isOptional || isCollection ? "this." + propName + "()" : "Optional.of(this." + propName + "())";
        if (propType.isMap()) {
            line = line + ".entrySet()";
        }
        if (isCollection) {
            line = line + ".stream()";
        }
        if (isNestedType) {
            line = line + ".map(c -> c.configuredBuilder().build())";
        }
        if (propType.isList()) {
            line = line + ".collect(java.util.stream.Collectors.toList())";
        }
        if (propType.isSet()) {
            line = line + ".collect(java.util.stream.Collectors.toSet())";
        }
        if (propType.array()) {
            line = line + ".toArray(" + propType.genericTypeName().fqName() + "[]::new)";
        }
        if (propType.isMap()) {
            line = line + ".collect(java.util.stream.Collectors.toMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))";
        }
        if (isCollection) {
            line = "Optional.of(" + line + ")";
        }
        if (propType.isMap() || propType.isList() || propType.isSet()) {
            line = line + ".filter(c -> !c.isEmpty())";
        }
        line = line + ".ifPresent(p -> modelBuilder." + propName + "(p))";
        this.confMethodBuilder.addContentLine(line + ";");
    }

    Method build() {
        this.confMethodBuilder.addContentLine("return modelBuilder;");
        this.confMethodBuilder.addDescriptionLine("</ul>");
        if (!this.overriddenProperties.isEmpty()) {
            this.confMethodBuilder.addDescriptionLine("<p>");
            this.confMethodBuilder.addDescriptionLine("<b>Overridden:</b>");
            this.confMethodBuilder.addDescriptionLine("<ul>");
            this.overriddenProperties.forEach(p -> {
                String className = ((TypeName)p.enclosingType().orElseThrow()).className();
                String signature = p.signature().text();
                this.confMethodBuilder.addDescriptionLine("<li>{@link " + className + "#" + signature + "}</li>");
            });
            this.confMethodBuilder.addDescriptionLine("</ul>");
        }
        return this.confMethodBuilder.build();
    }
}

