/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.ClassType;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.Returns;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.AnnotationProperty;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.integrations.langchain4j.codegen.LangchainTypes;
import io.helidon.integrations.langchain4j.codegen.ModelCodegenHelper;
import io.helidon.integrations.langchain4j.codegen.ModelConfigCodegen;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.Collection;
import java.util.List;

class ModelFactoryCodegen
implements CodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(ModelConfigCodegen.class);
    private static final double DEFAULT_FACTORY_WEIGHT = 98.0;

    ModelFactoryCodegen() {
    }

    public void process(RoundContext roundContext) {
        Collection types = roundContext.types();
        for (TypeInfo type : types) {
            String providerClassPrefix = ModelCodegenHelper.providerFromClassName(type);
            String providerKey = ModelCodegenHelper.camelToKebabCase(providerClassPrefix);
            TypeName constantClassTypeName = this.createConstantsClass(roundContext, providerClassPrefix + "Constants", type, providerKey);
            type.findAnnotation(LangchainTypes.MODEL_CONFIGS_TYPE).flatMap(a -> a.annotationValues()).or(() -> type.findAnnotation(LangchainTypes.MODEL_CONFIG_TYPE).map(List::of)).stream().flatMap(Collection::stream).forEach(modelAnnotation -> this.process(roundContext, type, providerKey, (Annotation)modelAnnotation, constantClassTypeName));
        }
    }

    private TypeName createConstantsClass(RoundContext context, String className, TypeInfo type, String providerKey) {
        TypeName classTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(type.typeName().packageName())).className(className)).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().classType(ClassType.CLASS)).type(classTypeName).accessModifier(AccessModifier.PACKAGE_PRIVATE).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)type.typeName(), (TypeName)classTypeName)).addDescriptionLine("Constants for '" + providerKey + "' Lc4j provider.")).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)type.typeName(), (TypeName)classTypeName, (String)"1", (String)""));
        classModel.addField(((Field.Builder)Field.builder().name("QUALIFIER")).isStatic(true).isFinal(true).accessModifier(AccessModifier.PACKAGE_PRIVATE).type(LangchainTypes.SVC_QUALIFIER).addContent(LangchainTypes.SVC_QUALIFIER).addContent(".createNamed(\"").addContent(providerKey).addContent("\")").build());
        context.addGeneratedType(classTypeName, classModel, type.typeName(), new Object[0]);
        return classTypeName;
    }

    private void process(RoundContext roundContext, TypeInfo configType, String providerKey, Annotation modelAnnotation, TypeName constantClassTypeName) {
        TypeName modelType = (TypeName)modelAnnotation.typeValue().orElseThrow();
        Annotation modelFactoryWeightAnnotation = modelAnnotation.doubleValue("weight").filter(w -> w != 100.0).map(w -> ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(LangchainTypes.COMMON_WEIGHT)).putValue("value", w)).build()).or(() -> configType.elementInfo().stream().filter(e -> e.kind().equals((Object)ElementKind.FIELD)).filter(e -> e.typeName().equals((Object)TypeNames.PRIMITIVE_DOUBLE)).filter(e -> e.hasAnnotation(LangchainTypes.MODEL_DEFAULT_WEIGHT)).findFirst().map(e -> ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(LangchainTypes.COMMON_WEIGHT)).putProperty("value", AnnotationProperty.create((Object)"weight", (TypeName)configType.typeName(), (String)e.elementName()))).build())).orElseGet(() -> ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(LangchainTypes.COMMON_WEIGHT)).putValue("value", (Object)98.0)).build());
        String modelClassNamePrefix = modelAnnotation.typeValue().map(rec$ -> ((TypeName)rec$).className()).orElseThrow(() -> new CodegenException("Missing model class"));
        TypeName factoryTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(configType.typeName().packageName())).className(modelClassNamePrefix + "Factory")).build();
        TypeName.Builder superTypeName = (TypeName.Builder)TypeName.builder((TypeName)LangchainTypes.SVC_SERVICES_FACTORY).addTypeArgument(modelType);
        TypeName modelSupplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(modelType)).build())).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().classType(ClassType.CLASS)).type(factoryTypeName).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)configType.typeName(), (TypeName)factoryTypeName)).addDescriptionLine("Service factory for the " + modelClassNamePrefix + ".")).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)configType.typeName(), (TypeName)factoryTypeName, (String)"1", (String)""))).accessModifier(AccessModifier.PUBLIC).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON))).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED)).putProperty("value", AnnotationProperty.create((Object)"value", (TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED, (String)"WILDCARD_NAME"))).build())).addAnnotation(modelFactoryWeightAnnotation)).addInterface(superTypeName.build());
        classModel.addMethod(((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("model")).accessModifier(AccessModifier.PRIVATE)).addContentLine("return model;")).returnType(modelSupplierType).build());
        classModel.addField(((Field.Builder)Field.builder().name("model")).accessModifier(AccessModifier.PRIVATE).isFinal(true).type(modelSupplierType).build());
        classModel.addConstructor((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)Constructor.builder().description("Creates a new " + modelClassNamePrefix + "Factory.")).addContent("var configBuilder = ")).addTypeToContent(modelClassNamePrefix + "Config")).addContentLine(".builder()")).increaseContentPadding()).addContentLine(".config(config.get(" + modelClassNamePrefix + "ConfigBlueprint")).addContentLine(".CONFIG_ROOT));")).decreaseContentPadding()).addContentLine("model = () -> buildModel(configBuilder);")).addParameter(((Parameter.Builder)((Parameter.Builder)Parameter.builder().description("Configuration for the new model.")).name("config")).type(LangchainTypes.COMMON_CONFIG).build()));
        classModel.addMethod(ModelFactoryCodegen.servicesMethod(modelType, constantClassTypeName));
        String modelNamePrefix = modelAnnotation.typeValue().map(rec$ -> ((TypeName)rec$).className()).orElseThrow(() -> new CodegenException("Missing model class"));
        TypeName modelConfigTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(configType.typeName().packageName())).className(modelNamePrefix + "Config")).build();
        TypeName modelConfigBuilderTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(modelConfigTypeName)).className(modelNamePrefix + "Config.Builder")).build();
        classModel.addMethod(ModelFactoryCodegen.buildModelMethod(modelType, modelConfigBuilderTypeName));
        classModel.addMethod(ModelFactoryCodegen.createMethod(modelType, modelConfigTypeName));
        roundContext.addGeneratedType(factoryTypeName, classModel, configType.typeName(), new Object[0]);
    }

    private static Method servicesMethod(TypeName modelType, TypeName constantClassTypeName) {
        return ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).name("services")).returnType(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.LIST).addTypeArgument(((TypeName.Builder)TypeName.builder((TypeName)LangchainTypes.SVC_QUALIFIED_INSTANCE).addTypeArgument(modelType)).build())).build()).addContentLine("var modelOptional = model().get();")).addContentLine("if (modelOptional.isEmpty()) {")).increaseContentPadding()).addContent("return ")).addContent(TypeNames.LIST)).addContentLine(".of();")).decreaseContentPadding()).addContentLine("}")).addContentLine("var theModel = modelOptional.get();")).addContent("return List.of(")).addContent(LangchainTypes.SVC_QUALIFIED_INSTANCE)).addContentLine(".create(theModel),")).increaseContentPadding()).addContent(LangchainTypes.SVC_QUALIFIED_INSTANCE)).addContent(".create(theModel, ")).addContent(constantClassTypeName)).addContentLine(".QUALIFIER));")).build();
    }

    private static Method buildModelMethod(TypeName modelType, TypeName modelConfigBuilderTypeName) {
        return ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().accessModifier(AccessModifier.PROTECTED)).name("buildModel")).isStatic(true).description("Builds a new model configured with the given configuration builder.")).addParameter(((Parameter.Builder)((Parameter.Builder)Parameter.builder().type(modelConfigBuilderTypeName).description("Configuration builder for the new model.")).name("configBuilder")).build())).returnType(Returns.builder().description("New model configured with the given configuration builder.").type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(modelType)).build()).build()).addContentLine("if (!configBuilder.enabled()) {")).increaseContentPadding()).addContent("return ")).addContent(TypeNames.OPTIONAL)).addContentLine(".empty();")).decreaseContentPadding()).addContentLine("}")).addContent("return ")).addContent(TypeNames.OPTIONAL)).addContentLine(".of(create(configBuilder.build()));")).build();
    }

    private static Method createMethod(TypeName modelType, TypeName modelConfigTypeName) {
        return ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("create")).accessModifier(AccessModifier.PUBLIC)).isStatic(true).description("Creates a new model configured with the given configuration.")).returnType(Returns.builder().description("New model configured with the given configuration.").type(modelType).build()).addParameter(((Parameter.Builder)((Parameter.Builder)Parameter.builder().name("config")).description("Configuration for the new model.")).type(modelConfigTypeName).build())).addContentLine("if (!config.enabled()) {")).increaseContentPadding()).addContent("throw new ")).addContent(IllegalStateException.class)).addContent("(")).addContentLiteral("Cannot create a model when the configuration is disabled.")).addContentLine(");")).decreaseContentPadding()).addContentLine("}")).addContentLine("return config.configuredBuilder().build();")).build();
    }
}

