/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.RoundContext;
import io.helidon.common.types.TypeInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ModelCodegenHelper {
    private static final Pattern LC4J_PROVIDER_NAME_MASK = Pattern.compile("([A-Z][A-Za-z0-9]*)(Lc4jProvider|NestedParentBlueprint)");

    private ModelCodegenHelper() {
    }

    static String providerConfigKeyFromClassName(TypeInfo typeInfo) {
        return ModelCodegenHelper.camelToKebabCase(ModelCodegenHelper.providerFromClassName(typeInfo));
    }

    static TypeInfo resolveModelBuilderType(RoundContext roundContext, TypeInfo typeInfo, String builderMethodName) {
        return (TypeInfo)typeInfo.elementInfo().stream().filter(m -> m.elementName().equals(builderMethodName)).filter(m -> m.parameterArguments().isEmpty()).map(m -> m.typeName()).findFirst().flatMap(arg_0 -> ((RoundContext)roundContext).typeInfo(arg_0)).orElseThrow(() -> new CodegenException("Builder type not found for " + String.valueOf(typeInfo.typeName())));
    }

    static String providerFromClassName(TypeInfo typeInfo) {
        String providerClassName = typeInfo.typeName().className();
        Matcher m = LC4J_PROVIDER_NAME_MASK.matcher(providerClassName);
        if (m.matches()) {
            return m.group(1);
        }
        throw new CodegenException("Unable to determine provider name from class name: " + providerClassName + ", provider name must be in format: " + LC4J_PROVIDER_NAME_MASK.pattern());
    }

    static String camelToKebabCase(String in) {
        StringBuilder sb = new StringBuilder();
        char[] chars = in.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i == 0) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append('-').append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

