/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.integrations.eureka.LeaseInfoConfigBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.eureka.LeaseInfoConfigBlueprint")
public interface LeaseInfoConfig
extends LeaseInfoConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LeaseInfoConfig instance) {
        return (Builder)LeaseInfoConfig.builder().from(instance);
    }

    public static LeaseInfoConfig create(Config config) {
        return ((Builder)LeaseInfoConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static LeaseInfoConfig create(io.helidon.common.config.Config config) {
        return LeaseInfoConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static LeaseInfoConfig create() {
        return LeaseInfoConfig.builder().buildPrototype();
    }

    @Override
    public int renewalIntervalInSecs();

    @Override
    public int durationInSecs();

    public static class Builder
    extends BuilderBase<Builder, LeaseInfoConfig>
    implements io.helidon.common.Builder<Builder, LeaseInfoConfig> {
        private Builder() {
        }

        public LeaseInfoConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.LeaseInfoConfigImpl(this);
        }

        public LeaseInfoConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends LeaseInfoConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private int durationInSecs = 90;
        private int renewalIntervalInSecs = 30;

        protected BuilderBase() {
        }

        public BUILDER from(LeaseInfoConfig prototype) {
            this.renewalIntervalInSecs(prototype.renewalIntervalInSecs());
            this.durationInSecs(prototype.durationInSecs());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.renewalIntervalInSecs(builder.renewalIntervalInSecs());
            this.durationInSecs(builder.durationInSecs());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("renewalInterval").as(Integer.class).ifPresent(this::renewalIntervalInSecs);
            config.get("duration").as(Integer.class).ifPresent(this::durationInSecs);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER renewalIntervalInSecs(int renewalIntervalInSecs) {
            this.renewalIntervalInSecs = renewalIntervalInSecs;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER durationInSecs(int durationInSecs) {
            this.durationInSecs = durationInSecs;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int renewalIntervalInSecs() {
            return this.renewalIntervalInSecs;
        }

        public int durationInSecs() {
            return this.durationInSecs;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "LeaseInfoConfigBuilder{renewalIntervalInSecs=" + this.renewalIntervalInSecs + ",durationInSecs=" + this.durationInSecs + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class LeaseInfoConfigImpl
        implements LeaseInfoConfig {
            private final int durationInSecs;
            private final int renewalIntervalInSecs;

            protected LeaseInfoConfigImpl(BuilderBase<?, ?> builder) {
                this.renewalIntervalInSecs = builder.renewalIntervalInSecs();
                this.durationInSecs = builder.durationInSecs();
            }

            @Override
            public int renewalIntervalInSecs() {
                return this.renewalIntervalInSecs;
            }

            @Override
            public int durationInSecs() {
                return this.durationInSecs;
            }

            public String toString() {
                return "LeaseInfoConfig{renewalIntervalInSecs=" + this.renewalIntervalInSecs + ",durationInSecs=" + this.durationInSecs + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LeaseInfoConfig)) {
                    return false;
                }
                LeaseInfoConfig other = (LeaseInfoConfig)o;
                return this.renewalIntervalInSecs == other.renewalIntervalInSecs() && this.durationInSecs == other.durationInSecs();
            }

            public int hashCode() {
                return Objects.hash(this.renewalIntervalInSecs, this.durationInSecs);
            }
        }
    }
}

