/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.integrations.eureka.InstanceInfoConfigBlueprint;
import io.helidon.integrations.eureka.InstanceInfoConfigSupport;
import io.helidon.integrations.eureka.LeaseInfoConfig;
import io.helidon.integrations.eureka.PortInfoConfig;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.eureka.InstanceInfoConfigBlueprint")
public interface InstanceInfoConfig
extends InstanceInfoConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InstanceInfoConfig instance) {
        return (Builder)InstanceInfoConfig.builder().from(instance);
    }

    public static InstanceInfoConfig create(Config config) {
        return ((Builder)InstanceInfoConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static InstanceInfoConfig create(io.helidon.common.config.Config config) {
        return InstanceInfoConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static InstanceInfoConfig create() {
        return InstanceInfoConfig.builder().buildPrototype();
    }

    public String instanceId(int var1);

    public int port(int var1, boolean var2);

    public boolean portEnabled(boolean var1);

    public int securePort(int var1, boolean var2);

    public boolean securePortEnabled(boolean var1);

    @Override
    public String appName();

    @Override
    public String appGroupName();

    @Override
    public Optional<String> asgName();

    @Override
    public Optional<URI> healthCheckUrl();

    @Override
    public String healthCheckUrlPath();

    @Override
    public Optional<URI> homePageUrl();

    @Override
    public String homePageUrlPath();

    @Override
    public String hostName();

    @Override
    public Optional<String> instanceId();

    @Override
    public String ipAddr();

    @Override
    public JsonBuilderFactory jsonBuilderFactory();

    @Override
    public LeaseInfoConfig leaseInfo();

    @Override
    public Map<String, String> metadata();

    @Override
    public PortInfoConfig portInfo();

    @Override
    public Optional<URI> secureHealthCheckUrl();

    @Override
    public PortInfoConfig securePortInfo();

    @Override
    public Optional<URI> statusPageUrl();

    @Override
    public String statusPageUrlPath();

    @Override
    public boolean trafficEnabled();

    @Override
    public Optional<String> vipAddress();

    @Override
    public Optional<String> secureVipAddress();

    public static class Builder
    extends BuilderBase<Builder, InstanceInfoConfig>
    implements io.helidon.common.Builder<Builder, InstanceInfoConfig> {
        private Builder() {
        }

        public InstanceInfoConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InstanceInfoConfigImpl(this);
        }

        public InstanceInfoConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InstanceInfoConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, String> metadata = Map.of();
        private boolean trafficEnabled = true;
        private Config config;
        private JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        private LeaseInfoConfig leaseInfo = LeaseInfoConfig.create();
        private PortInfoConfig portInfo = PortInfoConfig.create();
        private PortInfoConfig securePortInfo = PortInfoConfig.create();
        private String appGroupName = "unknown";
        private String appName = "unknown";
        private String asgName;
        private String healthCheckUrlPath;
        private String homePageUrlPath = "/";
        private String hostName;
        private String instanceId;
        private String ipAddr;
        private String secureVipAddress;
        private String statusPageUrlPath = "/Status";
        private String vipAddress;
        private URI healthCheckUrl;
        private URI homePageUrl;
        private URI secureHealthCheckUrl;
        private URI statusPageUrl;

        protected BuilderBase() {
        }

        public BUILDER from(InstanceInfoConfig prototype) {
            this.appName(prototype.appName());
            this.appGroupName(prototype.appGroupName());
            this.asgName(prototype.asgName());
            this.healthCheckUrl(prototype.healthCheckUrl());
            this.healthCheckUrlPath(prototype.healthCheckUrlPath());
            this.homePageUrl(prototype.homePageUrl());
            this.homePageUrlPath(prototype.homePageUrlPath());
            this.hostName(prototype.hostName());
            this.instanceId(prototype.instanceId());
            this.ipAddr(prototype.ipAddr());
            this.jsonBuilderFactory(prototype.jsonBuilderFactory());
            this.leaseInfo(prototype.leaseInfo());
            this.addMetadata(prototype.metadata());
            this.portInfo(prototype.portInfo());
            this.secureHealthCheckUrl(prototype.secureHealthCheckUrl());
            this.securePortInfo(prototype.securePortInfo());
            this.statusPageUrl(prototype.statusPageUrl());
            this.statusPageUrlPath(prototype.statusPageUrlPath());
            this.trafficEnabled(prototype.trafficEnabled());
            this.vipAddress(prototype.vipAddress());
            this.secureVipAddress(prototype.secureVipAddress());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.appName(builder.appName());
            this.appGroupName(builder.appGroupName());
            builder.asgName().ifPresent(this::asgName);
            builder.healthCheckUrl().ifPresent(this::healthCheckUrl);
            builder.healthCheckUrlPath().ifPresent(this::healthCheckUrlPath);
            builder.homePageUrl().ifPresent(this::homePageUrl);
            this.homePageUrlPath(builder.homePageUrlPath());
            builder.hostName().ifPresent(this::hostName);
            builder.instanceId().ifPresent(this::instanceId);
            builder.ipAddr().ifPresent(this::ipAddr);
            this.jsonBuilderFactory(builder.jsonBuilderFactory());
            this.leaseInfo(builder.leaseInfo());
            this.addMetadata(builder.metadata);
            this.portInfo(builder.portInfo());
            builder.secureHealthCheckUrl().ifPresent(this::secureHealthCheckUrl);
            this.securePortInfo(builder.securePortInfo());
            builder.statusPageUrl().ifPresent(this::statusPageUrl);
            this.statusPageUrlPath(builder.statusPageUrlPath());
            this.trafficEnabled(builder.trafficEnabled());
            builder.vipAddress().ifPresent(this::vipAddress);
            builder.secureVipAddress().ifPresent(this::secureVipAddress);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::appName);
            config.get("appGroup").as(String.class).ifPresent(this::appGroupName);
            config.get("asgName").as(String.class).ifPresent(this::asgName);
            config.get("healthCheckUrl").as(URI.class).ifPresent(this::healthCheckUrl);
            config.get("healthCheckUrlPath").as(String.class).ifPresent(this::healthCheckUrlPath);
            config.get("homePageUrl").as(URI.class).ifPresent(this::homePageUrl);
            config.get("homePageUrlPath").as(String.class).ifPresent(this::homePageUrlPath);
            config.get("hostName").as(String.class).ifPresent(this::hostName);
            config.get("instanceId").as(String.class).ifPresent(this::instanceId);
            config.get("ipAddr").as(String.class).ifPresent(this::ipAddr);
            config.get("lease").as(LeaseInfoConfig::create).ifPresent(this::leaseInfo);
            config.get("metadata").detach().asMap().ifPresent(this::metadata);
            config.get("port").as(PortInfoConfig::create).ifPresent(this::portInfo);
            config.get("secureHealthCheckUrl").as(URI.class).ifPresent(this::secureHealthCheckUrl);
            config.get("securePort").as(PortInfoConfig::create).ifPresent(this::securePortInfo);
            config.get("statusPageUrl").as(URI.class).ifPresent(this::statusPageUrl);
            config.get("statusPageUrlPath").as(String.class).ifPresent(this::statusPageUrlPath);
            config.get("traffic.enabled").as(Boolean.class).ifPresent(this::trafficEnabled);
            config.get("vipAddress").as(String.class).ifPresent(this::vipAddress);
            config.get("secureVipAddress").as(String.class).ifPresent(this::secureVipAddress);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER appName(String appName) {
            Objects.requireNonNull(appName);
            this.appName = appName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER appGroupName(String appGroupName) {
            Objects.requireNonNull(appGroupName);
            this.appGroupName = appGroupName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAsgName() {
            this.asgName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER asgName(String asgName) {
            Objects.requireNonNull(asgName);
            this.asgName = asgName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearHealthCheckUrl() {
            this.healthCheckUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER healthCheckUrl(URI healthCheckUrl) {
            Objects.requireNonNull(healthCheckUrl);
            this.healthCheckUrl = healthCheckUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER healthCheckUrlPath(String healthCheckUrlPath) {
            Objects.requireNonNull(healthCheckUrlPath);
            this.healthCheckUrlPath = healthCheckUrlPath;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearHomePageUrl() {
            this.homePageUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER homePageUrl(URI homePageUrl) {
            Objects.requireNonNull(homePageUrl);
            this.homePageUrl = homePageUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER homePageUrlPath(String homePageUrlPath) {
            Objects.requireNonNull(homePageUrlPath);
            this.homePageUrlPath = homePageUrlPath;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER hostName(String hostName) {
            Objects.requireNonNull(hostName);
            this.hostName = hostName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInstanceId() {
            this.instanceId = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER instanceId(String instanceId) {
            Objects.requireNonNull(instanceId);
            this.instanceId = instanceId;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ipAddr(String ipAddr) {
            Objects.requireNonNull(ipAddr);
            this.ipAddr = ipAddr;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER jsonBuilderFactory(JsonBuilderFactory jsonBuilderFactory) {
            Objects.requireNonNull(jsonBuilderFactory);
            this.jsonBuilderFactory = jsonBuilderFactory;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER leaseInfo(LeaseInfoConfig leaseInfo) {
            Objects.requireNonNull(leaseInfo);
            this.leaseInfo = leaseInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER leaseInfo(Consumer<LeaseInfoConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            LeaseInfoConfig.Builder builder = LeaseInfoConfig.builder();
            consumer.accept(builder);
            this.leaseInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER leaseInfo(Supplier<? extends LeaseInfoConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.leaseInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER metadata(Map<String, String> metadata) {
            Objects.requireNonNull(metadata);
            this.metadata.clear();
            this.metadata.putAll(metadata);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMetadata(Map<String, String> metadata) {
            Objects.requireNonNull(metadata);
            this.metadata.putAll(metadata);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER portInfo(PortInfoConfig portInfo) {
            Objects.requireNonNull(portInfo);
            this.portInfo = portInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER portInfo(Consumer<PortInfoConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            PortInfoConfig.Builder builder = PortInfoConfig.builder();
            consumer.accept(builder);
            this.portInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER portInfo(Supplier<? extends PortInfoConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.portInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSecureHealthCheckUrl() {
            this.secureHealthCheckUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER secureHealthCheckUrl(URI secureHealthCheckUrl) {
            Objects.requireNonNull(secureHealthCheckUrl);
            this.secureHealthCheckUrl = secureHealthCheckUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER securePortInfo(PortInfoConfig securePortInfo) {
            Objects.requireNonNull(securePortInfo);
            this.securePortInfo = securePortInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER securePortInfo(Consumer<PortInfoConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            PortInfoConfig.Builder builder = PortInfoConfig.builder();
            consumer.accept(builder);
            this.securePortInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER securePortInfo(Supplier<? extends PortInfoConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.securePortInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStatusPageUrl() {
            this.statusPageUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER statusPageUrl(URI statusPageUrl) {
            Objects.requireNonNull(statusPageUrl);
            this.statusPageUrl = statusPageUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER statusPageUrlPath(String statusPageUrlPath) {
            Objects.requireNonNull(statusPageUrlPath);
            this.statusPageUrlPath = statusPageUrlPath;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trafficEnabled(boolean trafficEnabled) {
            this.trafficEnabled = trafficEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearVipAddress() {
            this.vipAddress = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER vipAddress(String vipAddress) {
            Objects.requireNonNull(vipAddress);
            this.vipAddress = vipAddress;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSecureVipAddress() {
            this.secureVipAddress = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER secureVipAddress(String secureVipAddress) {
            Objects.requireNonNull(secureVipAddress);
            this.secureVipAddress = secureVipAddress;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String appName() {
            return this.appName;
        }

        public String appGroupName() {
            return this.appGroupName;
        }

        public Optional<String> asgName() {
            return Optional.ofNullable(this.asgName);
        }

        public Optional<URI> healthCheckUrl() {
            return Optional.ofNullable(this.healthCheckUrl);
        }

        public Optional<String> healthCheckUrlPath() {
            return Optional.ofNullable(this.healthCheckUrlPath);
        }

        public Optional<URI> homePageUrl() {
            return Optional.ofNullable(this.homePageUrl);
        }

        public String homePageUrlPath() {
            return this.homePageUrlPath;
        }

        public Optional<String> hostName() {
            return Optional.ofNullable(this.hostName);
        }

        public Optional<String> instanceId() {
            return Optional.ofNullable(this.instanceId);
        }

        public Optional<String> ipAddr() {
            return Optional.ofNullable(this.ipAddr);
        }

        public JsonBuilderFactory jsonBuilderFactory() {
            return this.jsonBuilderFactory;
        }

        public LeaseInfoConfig leaseInfo() {
            return this.leaseInfo;
        }

        public Map<String, String> metadata() {
            return this.metadata;
        }

        public PortInfoConfig portInfo() {
            return this.portInfo;
        }

        public Optional<URI> secureHealthCheckUrl() {
            return Optional.ofNullable(this.secureHealthCheckUrl);
        }

        public PortInfoConfig securePortInfo() {
            return this.securePortInfo;
        }

        public Optional<URI> statusPageUrl() {
            return Optional.ofNullable(this.statusPageUrl);
        }

        public String statusPageUrlPath() {
            return this.statusPageUrlPath;
        }

        public boolean trafficEnabled() {
            return this.trafficEnabled;
        }

        public Optional<String> vipAddress() {
            return Optional.ofNullable(this.vipAddress);
        }

        public Optional<String> secureVipAddress() {
            return Optional.ofNullable(this.secureVipAddress);
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "InstanceInfoConfigBuilder{appName=" + this.appName + ",appGroupName=" + this.appGroupName + ",asgName=" + this.asgName + ",healthCheckUrl=" + String.valueOf(this.healthCheckUrl) + ",healthCheckUrlPath=" + this.healthCheckUrlPath + ",homePageUrl=" + String.valueOf(this.homePageUrl) + ",homePageUrlPath=" + this.homePageUrlPath + ",hostName=" + this.hostName + ",instanceId=" + this.instanceId + ",ipAddr=" + this.ipAddr + ",jsonBuilderFactory=" + String.valueOf(this.jsonBuilderFactory) + ",leaseInfo=" + String.valueOf(this.leaseInfo) + ",metadata=" + String.valueOf(this.metadata) + ",portInfo=" + String.valueOf(this.portInfo) + ",secureHealthCheckUrl=" + String.valueOf(this.secureHealthCheckUrl) + ",securePortInfo=" + String.valueOf(this.securePortInfo) + ",statusPageUrl=" + String.valueOf(this.statusPageUrl) + ",statusPageUrlPath=" + this.statusPageUrlPath + ",trafficEnabled=" + this.trafficEnabled + ",vipAddress=" + this.vipAddress + ",secureVipAddress=" + this.secureVipAddress + "}";
        }

        protected void preBuildPrototype() {
            new InstanceInfoConfigSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.healthCheckUrlPath == null) {
                collector.fatal(this.getClass(), "Property \"healthCheckUrlPath\" must not be null, but not set");
            }
            if (this.hostName == null) {
                collector.fatal(this.getClass(), "Property \"hostName\" must not be null, but not set");
            }
            if (this.ipAddr == null) {
                collector.fatal(this.getClass(), "Property \"ipAddr\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER asgName(Optional<String> asgName) {
            Objects.requireNonNull(asgName);
            this.asgName = asgName.map(String.class::cast).orElse(this.asgName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER healthCheckUrl(Optional<? extends URI> healthCheckUrl) {
            Objects.requireNonNull(healthCheckUrl);
            this.healthCheckUrl = healthCheckUrl.map(URI.class::cast).orElse(this.healthCheckUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER homePageUrl(Optional<? extends URI> homePageUrl) {
            Objects.requireNonNull(homePageUrl);
            this.homePageUrl = homePageUrl.map(URI.class::cast).orElse(this.homePageUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER instanceId(Optional<String> instanceId) {
            Objects.requireNonNull(instanceId);
            this.instanceId = instanceId.map(String.class::cast).orElse(this.instanceId);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER secureHealthCheckUrl(Optional<? extends URI> secureHealthCheckUrl) {
            Objects.requireNonNull(secureHealthCheckUrl);
            this.secureHealthCheckUrl = secureHealthCheckUrl.map(URI.class::cast).orElse(this.secureHealthCheckUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER statusPageUrl(Optional<? extends URI> statusPageUrl) {
            Objects.requireNonNull(statusPageUrl);
            this.statusPageUrl = statusPageUrl.map(URI.class::cast).orElse(this.statusPageUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER vipAddress(Optional<String> vipAddress) {
            Objects.requireNonNull(vipAddress);
            this.vipAddress = vipAddress.map(String.class::cast).orElse(this.vipAddress);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER secureVipAddress(Optional<String> secureVipAddress) {
            Objects.requireNonNull(secureVipAddress);
            this.secureVipAddress = secureVipAddress.map(String.class::cast).orElse(this.secureVipAddress);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class InstanceInfoConfigImpl
        implements InstanceInfoConfig {
            private final boolean trafficEnabled;
            private final JsonBuilderFactory jsonBuilderFactory;
            private final LeaseInfoConfig leaseInfo;
            private final Map<String, String> metadata;
            private final Optional<String> asgName;
            private final Optional<String> instanceId;
            private final Optional<String> secureVipAddress;
            private final Optional<String> vipAddress;
            private final Optional<URI> healthCheckUrl;
            private final Optional<URI> homePageUrl;
            private final Optional<URI> secureHealthCheckUrl;
            private final Optional<URI> statusPageUrl;
            private final PortInfoConfig portInfo;
            private final PortInfoConfig securePortInfo;
            private final String appGroupName;
            private final String appName;
            private final String healthCheckUrlPath;
            private final String homePageUrlPath;
            private final String hostName;
            private final String ipAddr;
            private final String statusPageUrlPath;

            protected InstanceInfoConfigImpl(BuilderBase<?, ?> builder) {
                this.appName = builder.appName();
                this.appGroupName = builder.appGroupName();
                this.asgName = builder.asgName().map(Function.identity());
                this.healthCheckUrl = builder.healthCheckUrl().map(Function.identity());
                this.healthCheckUrlPath = builder.healthCheckUrlPath().get();
                this.homePageUrl = builder.homePageUrl().map(Function.identity());
                this.homePageUrlPath = builder.homePageUrlPath();
                this.hostName = builder.hostName().get();
                this.instanceId = builder.instanceId().map(Function.identity());
                this.ipAddr = builder.ipAddr().get();
                this.jsonBuilderFactory = builder.jsonBuilderFactory();
                this.leaseInfo = builder.leaseInfo();
                this.metadata = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.metadata()));
                this.portInfo = builder.portInfo();
                this.secureHealthCheckUrl = builder.secureHealthCheckUrl().map(Function.identity());
                this.securePortInfo = builder.securePortInfo();
                this.statusPageUrl = builder.statusPageUrl().map(Function.identity());
                this.statusPageUrlPath = builder.statusPageUrlPath();
                this.trafficEnabled = builder.trafficEnabled();
                this.vipAddress = builder.vipAddress().map(Function.identity());
                this.secureVipAddress = builder.secureVipAddress().map(Function.identity());
            }

            @Override
            public String instanceId(int actualPort) {
                return InstanceInfoConfigSupport.CustomMethods.instanceId(this, actualPort);
            }

            @Override
            public int port(int actualPort, boolean tls) {
                return InstanceInfoConfigSupport.CustomMethods.port(this, actualPort, tls);
            }

            @Override
            public boolean portEnabled(boolean tls) {
                return InstanceInfoConfigSupport.CustomMethods.portEnabled(this, tls);
            }

            @Override
            public int securePort(int actualPort, boolean tls) {
                return InstanceInfoConfigSupport.CustomMethods.securePort(this, actualPort, tls);
            }

            @Override
            public boolean securePortEnabled(boolean tls) {
                return InstanceInfoConfigSupport.CustomMethods.securePortEnabled(this, tls);
            }

            @Override
            public String appName() {
                return this.appName;
            }

            @Override
            public String appGroupName() {
                return this.appGroupName;
            }

            @Override
            public Optional<String> asgName() {
                return this.asgName;
            }

            @Override
            public Optional<URI> healthCheckUrl() {
                return this.healthCheckUrl;
            }

            @Override
            public String healthCheckUrlPath() {
                return this.healthCheckUrlPath;
            }

            @Override
            public Optional<URI> homePageUrl() {
                return this.homePageUrl;
            }

            @Override
            public String homePageUrlPath() {
                return this.homePageUrlPath;
            }

            @Override
            public String hostName() {
                return this.hostName;
            }

            @Override
            public Optional<String> instanceId() {
                return this.instanceId;
            }

            @Override
            public String ipAddr() {
                return this.ipAddr;
            }

            @Override
            public JsonBuilderFactory jsonBuilderFactory() {
                return this.jsonBuilderFactory;
            }

            @Override
            public LeaseInfoConfig leaseInfo() {
                return this.leaseInfo;
            }

            @Override
            public Map<String, String> metadata() {
                return this.metadata;
            }

            @Override
            public PortInfoConfig portInfo() {
                return this.portInfo;
            }

            @Override
            public Optional<URI> secureHealthCheckUrl() {
                return this.secureHealthCheckUrl;
            }

            @Override
            public PortInfoConfig securePortInfo() {
                return this.securePortInfo;
            }

            @Override
            public Optional<URI> statusPageUrl() {
                return this.statusPageUrl;
            }

            @Override
            public String statusPageUrlPath() {
                return this.statusPageUrlPath;
            }

            @Override
            public boolean trafficEnabled() {
                return this.trafficEnabled;
            }

            @Override
            public Optional<String> vipAddress() {
                return this.vipAddress;
            }

            @Override
            public Optional<String> secureVipAddress() {
                return this.secureVipAddress;
            }

            public String toString() {
                return "InstanceInfoConfig{appName=" + this.appName + ",appGroupName=" + this.appGroupName + ",asgName=" + String.valueOf(this.asgName) + ",healthCheckUrl=" + String.valueOf(this.healthCheckUrl) + ",healthCheckUrlPath=" + this.healthCheckUrlPath + ",homePageUrl=" + String.valueOf(this.homePageUrl) + ",homePageUrlPath=" + this.homePageUrlPath + ",hostName=" + this.hostName + ",instanceId=" + String.valueOf(this.instanceId) + ",ipAddr=" + this.ipAddr + ",jsonBuilderFactory=" + String.valueOf(this.jsonBuilderFactory) + ",leaseInfo=" + String.valueOf(this.leaseInfo) + ",metadata=" + String.valueOf(this.metadata) + ",portInfo=" + String.valueOf(this.portInfo) + ",secureHealthCheckUrl=" + String.valueOf(this.secureHealthCheckUrl) + ",securePortInfo=" + String.valueOf(this.securePortInfo) + ",statusPageUrl=" + String.valueOf(this.statusPageUrl) + ",statusPageUrlPath=" + this.statusPageUrlPath + ",trafficEnabled=" + this.trafficEnabled + ",vipAddress=" + String.valueOf(this.vipAddress) + ",secureVipAddress=" + String.valueOf(this.secureVipAddress) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InstanceInfoConfig)) {
                    return false;
                }
                InstanceInfoConfig other = (InstanceInfoConfig)o;
                return Objects.equals(this.appName, other.appName()) && Objects.equals(this.appGroupName, other.appGroupName()) && Objects.equals(this.asgName, other.asgName()) && Objects.equals(this.healthCheckUrl, other.healthCheckUrl()) && Objects.equals(this.healthCheckUrlPath, other.healthCheckUrlPath()) && Objects.equals(this.homePageUrl, other.homePageUrl()) && Objects.equals(this.homePageUrlPath, other.homePageUrlPath()) && Objects.equals(this.hostName, other.hostName()) && Objects.equals(this.instanceId, other.instanceId()) && Objects.equals(this.ipAddr, other.ipAddr()) && Objects.equals(this.jsonBuilderFactory, other.jsonBuilderFactory()) && Objects.equals(this.leaseInfo, other.leaseInfo()) && Objects.equals(this.metadata, other.metadata()) && Objects.equals(this.portInfo, other.portInfo()) && Objects.equals(this.secureHealthCheckUrl, other.secureHealthCheckUrl()) && Objects.equals(this.securePortInfo, other.securePortInfo()) && Objects.equals(this.statusPageUrl, other.statusPageUrl()) && Objects.equals(this.statusPageUrlPath, other.statusPageUrlPath()) && this.trafficEnabled == other.trafficEnabled() && Objects.equals(this.vipAddress, other.vipAddress()) && Objects.equals(this.secureVipAddress, other.secureVipAddress());
            }

            public int hashCode() {
                return Objects.hash(this.appName, this.appGroupName, this.asgName, this.healthCheckUrl, this.healthCheckUrlPath, this.homePageUrl, this.homePageUrlPath, this.hostName, this.instanceId, this.ipAddr, this.jsonBuilderFactory, this.leaseInfo, this.metadata, this.portInfo, this.secureHealthCheckUrl, this.securePortInfo, this.statusPageUrl, this.statusPageUrlPath, this.trafficEnabled, this.vipAddress, this.secureVipAddress);
            }
        }
    }
}

