/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.integrations.eureka.EurekaRegistrationConfigBlueprint;
import io.helidon.integrations.eureka.EurekaRegistrationConfigSupport;
import io.helidon.integrations.eureka.EurekaRegistrationServerFeature;
import io.helidon.integrations.eureka.InstanceInfoConfig;
import io.helidon.webclient.http1.Http1ClientConfig;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.eureka.EurekaRegistrationConfigBlueprint")
public interface EurekaRegistrationConfig
extends EurekaRegistrationConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EurekaRegistrationConfig instance) {
        return (Builder)EurekaRegistrationConfig.builder().from(instance);
    }

    public static EurekaRegistrationConfig create(Config config) {
        return ((Builder)EurekaRegistrationConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static EurekaRegistrationConfig create(io.helidon.common.config.Config config) {
        return EurekaRegistrationConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static EurekaRegistrationConfig create() {
        return EurekaRegistrationConfig.builder().buildPrototype();
    }

    @Override
    public Supplier<Http1ClientConfig.Builder> clientBuilderSupplier();

    @Override
    public InstanceInfoConfig instanceInfo();

    @Override
    public JsonBuilderFactory jsonBuilderFactory();

    @Override
    public boolean enabled();

    @Override
    public String name();

    @Override
    public double weight();

    public static class Builder
    extends BuilderBase<Builder, EurekaRegistrationConfig>
    implements io.helidon.common.Builder<Builder, EurekaRegistrationServerFeature> {
        private Builder() {
        }

        public EurekaRegistrationConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.EurekaRegistrationConfigImpl(this);
        }

        public EurekaRegistrationServerFeature build() {
            return EurekaRegistrationServerFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends EurekaRegistrationConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enabled = true;
        private Config config;
        private double weight = 100.0;
        private InstanceInfoConfig instanceInfo = InstanceInfoConfig.create();
        private JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        private String name = "eureka";
        private Supplier<Http1ClientConfig.Builder> clientBuilderSupplier;

        protected BuilderBase() {
        }

        public BUILDER from(EurekaRegistrationConfig prototype) {
            this.clientBuilderSupplier(prototype.clientBuilderSupplier());
            this.instanceInfo(prototype.instanceInfo());
            this.jsonBuilderFactory(prototype.jsonBuilderFactory());
            this.enabled(prototype.enabled());
            this.name(prototype.name());
            this.weight(prototype.weight());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.clientBuilderSupplier().ifPresent(this::clientBuilderSupplier);
            this.instanceInfo(builder.instanceInfo());
            this.jsonBuilderFactory(builder.jsonBuilderFactory());
            this.enabled(builder.enabled());
            this.name(builder.name());
            this.weight(builder.weight());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("instance").as(InstanceInfoConfig::create).ifPresent(this::instanceInfo);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("weight").as(Double.class).ifPresent(this::weight);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clientBuilderSupplier(Supplier<? extends Http1ClientConfig.Builder> clientBuilderSupplier) {
            Objects.requireNonNull(clientBuilderSupplier);
            this.clientBuilderSupplier = clientBuilderSupplier::get;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clientBuilderSupplier(Http1ClientConfig.Builder clientBuilderSupplier) {
            Objects.requireNonNull(clientBuilderSupplier);
            this.clientBuilderSupplier = () -> clientBuilderSupplier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER instanceInfo(InstanceInfoConfig instanceInfo) {
            Objects.requireNonNull(instanceInfo);
            this.instanceInfo = instanceInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER instanceInfo(Consumer<InstanceInfoConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            InstanceInfoConfig.Builder builder = InstanceInfoConfig.builder();
            consumer.accept(builder);
            this.instanceInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER instanceInfo(Supplier<? extends InstanceInfoConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.instanceInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER jsonBuilderFactory(JsonBuilderFactory jsonBuilderFactory) {
            Objects.requireNonNull(jsonBuilderFactory);
            this.jsonBuilderFactory = jsonBuilderFactory;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Supplier<Http1ClientConfig.Builder>> clientBuilderSupplier() {
            return Optional.ofNullable(this.clientBuilderSupplier);
        }

        public InstanceInfoConfig instanceInfo() {
            return this.instanceInfo;
        }

        public JsonBuilderFactory jsonBuilderFactory() {
            return this.jsonBuilderFactory;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String name() {
            return this.name;
        }

        public double weight() {
            return this.weight;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "EurekaRegistrationConfigBuilder{clientBuilderSupplier=" + String.valueOf(this.clientBuilderSupplier) + ",instanceInfo=" + String.valueOf(this.instanceInfo) + ",jsonBuilderFactory=" + String.valueOf(this.jsonBuilderFactory) + ",enabled=" + this.enabled + ",name=" + this.name + ",weight=" + this.weight + "}";
        }

        protected void preBuildPrototype() {
            new EurekaRegistrationConfigSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.clientBuilderSupplier == null) {
                collector.fatal(this.getClass(), "Property \"clientBuilderSupplier\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class EurekaRegistrationConfigImpl
        implements EurekaRegistrationConfig,
        Supplier<EurekaRegistrationServerFeature> {
            private final boolean enabled;
            private final double weight;
            private final InstanceInfoConfig instanceInfo;
            private final JsonBuilderFactory jsonBuilderFactory;
            private final String name;
            private final Supplier<Http1ClientConfig.Builder> clientBuilderSupplier;

            protected EurekaRegistrationConfigImpl(BuilderBase<?, ?> builder) {
                this.clientBuilderSupplier = builder.clientBuilderSupplier().get();
                this.instanceInfo = builder.instanceInfo();
                this.jsonBuilderFactory = builder.jsonBuilderFactory();
                this.enabled = builder.enabled();
                this.name = builder.name();
                this.weight = builder.weight();
            }

            public EurekaRegistrationServerFeature build() {
                return EurekaRegistrationServerFeature.create(this);
            }

            @Override
            public EurekaRegistrationServerFeature get() {
                return this.build();
            }

            @Override
            public Supplier<Http1ClientConfig.Builder> clientBuilderSupplier() {
                return this.clientBuilderSupplier;
            }

            @Override
            public InstanceInfoConfig instanceInfo() {
                return this.instanceInfo;
            }

            @Override
            public JsonBuilderFactory jsonBuilderFactory() {
                return this.jsonBuilderFactory;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public double weight() {
                return this.weight;
            }

            public String toString() {
                return "EurekaRegistrationConfig{clientBuilderSupplier=" + String.valueOf(this.clientBuilderSupplier) + ",instanceInfo=" + String.valueOf(this.instanceInfo) + ",jsonBuilderFactory=" + String.valueOf(this.jsonBuilderFactory) + ",enabled=" + this.enabled + ",name=" + this.name + ",weight=" + this.weight + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EurekaRegistrationConfig)) {
                    return false;
                }
                EurekaRegistrationConfig other = (EurekaRegistrationConfig)o;
                return Objects.equals(this.clientBuilderSupplier, other.clientBuilderSupplier()) && Objects.equals(this.instanceInfo, other.instanceInfo()) && Objects.equals(this.jsonBuilderFactory, other.jsonBuilderFactory()) && this.enabled == other.enabled() && Objects.equals(this.name, other.name()) && this.weight == other.weight();
            }

            public int hashCode() {
                return Objects.hash(this.clientBuilderSupplier, this.instanceInfo, this.jsonBuilderFactory, this.enabled, this.name, this.weight);
            }
        }
    }
}

