/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.integrations.eureka.InstanceInfoConfig;
import io.helidon.integrations.eureka.PortInfoConfig;
import io.helidon.service.registry.Services;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;

final class InstanceInfoConfigSupport {
    private InstanceInfoConfigSupport() {
    }

    static final class CustomMethods {
        private CustomMethods() {
        }

        @Prototype.PrototypeMethod
        static String instanceId(InstanceInfoConfig prototype, int actualPort) {
            return prototype.instanceId().orElseGet(() -> prototype.hostName() + ":" + actualPort);
        }

        @Prototype.PrototypeMethod
        static int port(InstanceInfoConfig prototype, int actualPort, boolean tls) {
            return tls ? prototype.portInfo().port() : actualPort;
        }

        @Prototype.PrototypeMethod
        static boolean portEnabled(InstanceInfoConfig prototype, boolean tls) {
            return tls ? prototype.portInfo().enabled() : true;
        }

        @Prototype.PrototypeMethod
        static int securePort(InstanceInfoConfig prototype, int actualPort, boolean tls) {
            return tls ? actualPort : prototype.securePortInfo().port();
        }

        @Prototype.PrototypeMethod
        static boolean securePortEnabled(InstanceInfoConfig prototype, boolean tls) {
            return tls ? true : prototype.securePortInfo().enabled();
        }
    }

    static final class BuilderDecorator
    implements Prototype.BuilderDecorator<InstanceInfoConfig.BuilderBase<?, ?>> {
        private static final System.Logger LOGGER = System.getLogger(BuilderDecorator.class.getName());

        BuilderDecorator() {
        }

        public void decorate(InstanceInfoConfig.BuilderBase<?, ?> builder) {
            PortInfoConfig portInfo;
            if (builder.hostName().isEmpty()) {
                builder.hostName((String)builder.config().orElseGet(Config::empty).get("hostName").asString().orElseGet(() -> BuilderDecorator.localhost().map(InetAddress::getHostName).orElse("")));
            }
            if (builder.ipAddr().isEmpty()) {
                builder.ipAddr((String)builder.config().orElseGet(Config::empty).get("ipAddr").asString().orElseGet(() -> BuilderDecorator.localhost().map(InetAddress::getHostAddress).orElse("")));
            }
            if (builder.healthCheckUrlPath().isEmpty()) {
                builder.healthCheckUrlPath((String)builder.config().orElseGet(() -> (Config)Services.get(Config.class)).root().get("server.reatures.observe.observers.health.endpoint").asString().orElse((Object)"/observe/health"));
            }
            if ((portInfo = builder.portInfo()).port() == 0) {
                builder.portInfo(((PortInfoConfig.Builder)((PortInfoConfig.Builder)((PortInfoConfig.Builder)PortInfoConfig.builder().from(portInfo)).enabled(true)).port(80)).build());
            }
            if ((portInfo = builder.securePortInfo()).port() == 0) {
                builder.securePortInfo(((PortInfoConfig.Builder)((PortInfoConfig.Builder)((PortInfoConfig.Builder)PortInfoConfig.builder().from(portInfo)).enabled(false)).port(443)).build());
            }
        }

        private static Optional<InetAddress> localhost() {
            try {
                return Optional.of(InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
                if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                    LOGGER.log(System.Logger.Level.WARNING, e);
                }
                return Optional.empty();
            }
        }
    }
}

