/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.integrations.eureka.InstanceInfoConfigSupport;
import io.helidon.integrations.eureka.LeaseInfoConfig;
import io.helidon.integrations.eureka.PortInfoConfig;
import jakarta.json.JsonBuilderFactory;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

@Prototype.Blueprint(decorator=InstanceInfoConfigSupport.BuilderDecorator.class)
@Prototype.Configured
@Prototype.CustomMethods(value=InstanceInfoConfigSupport.CustomMethods.class)
interface InstanceInfoConfigBlueprint {
    @Option.Configured(value="name")
    @Option.Default(value={"unknown"})
    public String appName();

    @Option.Configured(value="appGroup")
    @Option.Default(value={"unknown"})
    public String appGroupName();

    @Option.Configured(value="asgName")
    public Optional<String> asgName();

    @Option.Configured(value="healthCheckUrl")
    public Optional<URI> healthCheckUrl();

    @Option.Configured(value="healthCheckUrlPath")
    public String healthCheckUrlPath();

    @Option.Configured(value="homePageUrl")
    public Optional<URI> homePageUrl();

    @Option.Configured(value="homePageUrlPath")
    @Option.Default(value={"/"})
    public String homePageUrlPath();

    @Option.Configured(value="hostName")
    public String hostName();

    @Option.Configured(value="instanceId")
    public Optional<String> instanceId();

    @Option.Configured(value="ipAddr")
    public String ipAddr();

    @Option.DefaultCode(value="@jakarta.json.Json@.createBuilderFactory(@java.util.Map@.of())")
    public JsonBuilderFactory jsonBuilderFactory();

    @Option.Configured(value="lease")
    @Option.DefaultMethod(value="create")
    public LeaseInfoConfig leaseInfo();

    @Option.Configured(value="metadata")
    @Option.DefaultCode(value="@java.util.Map@.of()")
    public Map<String, String> metadata();

    default public int port() {
        return this.portInfo().port();
    }

    @Option.Configured(value="port")
    @Option.DefaultMethod(value="create")
    public PortInfoConfig portInfo();

    @Option.Configured(value="secureHealthCheckUrl")
    public Optional<URI> secureHealthCheckUrl();

    default public int securePort() {
        return this.securePortInfo().port();
    }

    @Option.Configured(value="securePort")
    @Option.DefaultMethod(value="create")
    public PortInfoConfig securePortInfo();

    @Option.Configured(value="statusPageUrl")
    public Optional<URI> statusPageUrl();

    @Option.Configured(value="statusPageUrlPath")
    @Option.Default(value={"/Status"})
    public String statusPageUrlPath();

    @Option.Configured(value="traffic.enabled")
    @Option.DefaultBoolean(value={true})
    public boolean trafficEnabled();

    @Option.Configured(value="vipAddress")
    public Optional<String> vipAddress();

    @Option.Configured(value="secureVipAddress")
    public Optional<String> secureVipAddress();
}

