/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.integrations.eureka.EurekaRegistrationConfig;
import io.helidon.integrations.eureka.EurekaRegistrationHttpFeature;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.spi.ServerFeature;
import java.util.Objects;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=EurekaRegistrationConfig.class)
public final class EurekaRegistrationServerFeature
implements RuntimeType.Api<EurekaRegistrationConfig>,
ServerFeature,
Weighted {
    static final String EUREKA_ID = "eureka";
    private static final System.Logger LOGGER = System.getLogger(EurekaRegistrationServerFeature.class.getName());
    private final EurekaRegistrationConfig prototype;

    private EurekaRegistrationServerFeature(EurekaRegistrationConfig prototype) {
        this.prototype = Objects.requireNonNull(prototype, "prototype");
    }

    public String name() {
        return this.prototype.name();
    }

    public EurekaRegistrationConfig prototype() {
        return this.prototype;
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (!this.prototype().enabled()) {
            if (LOGGER.isLoggable(System.Logger.Level.INFO)) {
                LOGGER.log(System.Logger.Level.INFO, "The " + this.type() + " ServerFeature implementation is disabled");
            }
            return;
        }
        featureContext.socket("@default").httpRouting().addFeature((HttpFeature)new EurekaRegistrationHttpFeature(this.prototype()));
    }

    public String type() {
        return EUREKA_ID;
    }

    public double weight() {
        return this.prototype.weight();
    }

    public static EurekaRegistrationServerFeature create(EurekaRegistrationConfig prototype) {
        return new EurekaRegistrationServerFeature(prototype);
    }

    public static EurekaRegistrationConfig.Builder builder() {
        return EurekaRegistrationConfig.builder();
    }

    public static EurekaRegistrationServerFeature create(Consumer<EurekaRegistrationConfig.Builder> builderConsumer) {
        return ((EurekaRegistrationConfig.Builder)EurekaRegistrationServerFeature.builder().update(builderConsumer)).build();
    }
}

