/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.eureka;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderNames;
import io.helidon.http.Status;
import io.helidon.integrations.eureka.EurekaRegistrationConfig;
import io.helidon.integrations.eureka.InstanceInfoConfig;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.ConnectException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

final class EurekaRegistrationHttpFeature
implements HttpFeature {
    private static final System.Logger LOGGER = System.getLogger(EurekaRegistrationHttpFeature.class.getName());
    private static final JsonString UP = Json.createValue((String)"UP");
    private static final JsonString DOWN = Json.createValue((String)"DOWN");
    private static final JsonString STARTING = Json.createValue((String)"STARTING");
    private static final JsonString OUT_OF_SERVICE = Json.createValue((String)"OUT_OF_SERVICE");
    private static final JsonString UNKNOWN = Json.createValue((String)"UNKNOWN");
    private final EurekaRegistrationConfig prototype;
    private volatile JsonObject instanceInfo;
    private volatile boolean stop;
    private volatile Thread renewer;
    private volatile Http1Client client;

    EurekaRegistrationHttpFeature(EurekaRegistrationConfig prototype) {
        this.prototype = Objects.requireNonNull(prototype, "prototype");
    }

    @Deprecated
    public void afterStart(WebServer webServer) {
        if (webServer.isRunning()) {
            this.afterStart(webServer.port(), webServer.hasTls());
        }
    }

    void afterStart(int actualPort, boolean tls) {
        if (this.stop) {
            if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                LOGGER.log(System.Logger.Level.WARNING, "Unexpected stop explicitly requested; no attempt at registration will occur");
            }
            return;
        }
        Http1ClientConfig.Builder clientBuilder = null;
        try {
            clientBuilder = this.prototype.clientBuilderSupplier().get();
        }
        catch (RuntimeException e) {
            if (LOGGER.isLoggable(System.Logger.Level.ERROR)) {
                LOGGER.log(System.Logger.Level.ERROR, "Getting a client builder failed so no attempt at registration can or will occur", (Throwable)e);
            }
            return;
        }
        if (clientBuilder == null) {
            if (LOGGER.isLoggable(System.Logger.Level.ERROR)) {
                LOGGER.log(System.Logger.Level.ERROR, "No " + Http1ClientConfig.Builder.class.getName() + " was supplied so no attempt at registration can or will occur");
            }
            return;
        }
        if (clientBuilder.baseUri().isPresent()) {
            JsonObject instanceInfo = null;
            try {
                instanceInfo = EurekaRegistrationHttpFeature.json(this.prototype.instanceInfo(), actualPort, tls);
            }
            catch (RuntimeException e) {
                if (LOGGER.isLoggable(System.Logger.Level.ERROR)) {
                    LOGGER.log(System.Logger.Level.ERROR, "Producing the initial JSON failed so no attempt at registration can or will occur", (Throwable)e);
                }
                return;
            }
            if (instanceInfo == null) {
                if (LOGGER.isLoggable(System.Logger.Level.ERROR)) {
                    LOGGER.log(System.Logger.Level.ERROR, "Producing the initial JSON resulted in null so no attempt at registration can or will occur");
                }
                return;
            }
            Http1Client client = ((Http1ClientConfig.Builder)clientBuilder.sendExpectContinue(false)).build();
            this.instanceInfo = instanceInfo;
            this.client = client;
            this.createAndStartRenewalLoop(instanceInfo, client);
        } else if (LOGGER.isLoggable(System.Logger.Level.ERROR)) {
            LOGGER.log(System.Logger.Level.ERROR, "No baseUri was set on " + String.valueOf(clientBuilder) + " so a Eureka Server cannot be contacted, so no attempt at registration will occur");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void afterStop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        Http1Client client = this.client;
        if (client == null) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "No cancellation necessary; registration never occurred");
            }
            return;
        }
        Thread renewer = this.renewer;
        if (renewer != null) {
            renewer.interrupt();
        }
        boolean canceled = false;
        RuntimeException e = null;
        try {
            canceled = this.cancel(client);
        }
        catch (RuntimeException e0) {
            e = e0;
        }
        finally {
            try {
                client.closeResource();
            }
            catch (RuntimeException e1) {
                if (e == null) {
                    e = e1;
                }
                e.addSuppressed(e1);
            }
            if (!canceled && LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                if (e == null) {
                    LOGGER.log(System.Logger.Level.WARNING, "Cancellation operation failed");
                } else {
                    LOGGER.log(System.Logger.Level.WARNING, "Cancellation operation failed", (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    public void setup(HttpRouting.Builder routingBuilder) {
    }

    private boolean cancel(Http1Client client) {
        if (!this.stop) {
            throw new IllegalStateException();
        }
        JsonObject instanceInfo = this.instanceInfo;
        this.up(instanceInfo, false);
        JsonObject instance = instanceInfo.getJsonObject("instance");
        return this.cancel(client, instance.getString("app"), instance.getString("instanceId"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cancel(Http1Client client, String appName, String id) {
        try (Http1ClientResponse response = ((Http1ClientRequest)client.delete("/v2/apps/" + Objects.requireNonNull(appName, "appName") + "/" + Objects.requireNonNull(id, "id"))).request();){
            if (response.status().family() == Status.Family.SUCCESSFUL) {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "DELETE /v2/apps/" + appName + "/" + id + ": " + String.valueOf(response.status()));
                }
                boolean bl = true;
                return bl;
            }
            if (!LOGGER.isLoggable(System.Logger.Level.WARNING)) return false;
            LOGGER.log(System.Logger.Level.WARNING, "DELETE /v2/apps/" + appName + "/" + id + ": " + String.valueOf(response.status()));
            return false;
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            if (!(cause instanceof ConnectException)) throw e;
            if (!LOGGER.isLoggable(System.Logger.Level.WARNING)) return false;
            LOGGER.log(System.Logger.Level.WARNING, "Eureka Server (" + String.valueOf(((Http1ClientConfig)this.client.prototype()).baseUri().orElse(null)) + ") not reachable", (Throwable)e);
            return false;
        }
    }

    private void createAndStartRenewalLoop(JsonObject instanceInfo, Http1Client client) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Creating and starting Eureka lease renewal loop");
        }
        long sleepTimeInMilliSeconds = (long)instanceInfo.getJsonObject("instance").getJsonObject("leaseInfo").getInt("renewalIntervalInSecs") * 1000L;
        this.renewer = Thread.ofVirtual().name("Eureka lease renewer").uncaughtExceptionHandler((t, e) -> {
            if (LOGGER.isLoggable(System.Logger.Level.ERROR)) {
                LOGGER.log(System.Logger.Level.ERROR, e.getMessage(), e);
            }
            this.stop = true;
        }).start(() -> {
            while (!this.stop) {
                JsonObject newInstanceInfo = this.renew();
                if (newInstanceInfo != this.instanceInfo) {
                    this.instanceInfo = newInstanceInfo;
                }
                try {
                    Thread.sleep(sleepTimeInMilliSeconds);
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                    LOGGER.log(System.Logger.Level.DEBUG, "Eureka lease renewal loop interrupted", (Throwable)e);
                }
            }
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Eureka lease renewal loop stopped");
            }
        });
        this.up(instanceInfo, true);
    }

    private Http1ClientResponse heartbeat(String appName, String id, String status, Long lastDirtyTimestamp) {
        Http1ClientRequest request = (Http1ClientRequest)((Http1ClientRequest)this.client.put("/v2/apps/" + Objects.requireNonNull(appName, "appName") + "/" + Objects.requireNonNull(id, "id"))).accept(new MediaType[]{MediaTypes.APPLICATION_JSON});
        if (status != null) {
            request.queryParam("status", new String[]{status});
        }
        if (lastDirtyTimestamp != null) {
            request.queryParam("lastDirtyTimestamp", new String[]{lastDirtyTimestamp.toString()});
        }
        return request.request();
    }

    private void statusChange() {
    }

    private boolean register(JsonObject payload) {
        if (payload == null) {
            return false;
        }
        try (Http1ClientResponse response = ((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)this.client.post("/v2/apps/" + payload.getJsonObject("instance").getString("app"))).accept(new MediaType[]{MediaTypes.APPLICATION_JSON})).contentType(MediaTypes.APPLICATION_JSON)).header(HeaderNames.ACCEPT_ENCODING, new String[]{"gzip"})).submit((Object)payload);){
            switch (response.status().code()) {
                case 200: {
                    if (LOGGER.isLoggable(System.Logger.Level.DEBUG) && response.entity().hasEntity()) {
                        LOGGER.log(System.Logger.Level.DEBUG, "Registration succeeded: 200; " + String.valueOf(response.entity().as(JsonObject.class)));
                    }
                    boolean bl = true;
                    return bl;
                }
                case 204: {
                    boolean bl = true;
                    return bl;
                }
            }
            if (response.status().family() == Status.Family.SUCCESSFUL) {
                boolean bl = true;
                return bl;
            }
            if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                if (response.entity().hasEntity()) {
                    LOGGER.log(System.Logger.Level.WARNING, "Registration failed: " + String.valueOf(response.status()) + "; " + ((JsonObject)response.entity().as(JsonObject.class)).getString("error"));
                } else {
                    LOGGER.log(System.Logger.Level.WARNING, "Registration failed: " + String.valueOf(response.status()));
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonObject renew() {
        JsonObject instanceInfo = this.instanceInfo;
        JsonObject instance = instanceInfo.getJsonObject("instance");
        try (Http1ClientResponse response = this.heartbeat(instance.getString("app"), instance.getString("instanceId"), instance.getString("status"), instance.getJsonNumber("lastDirtyTimestamp").longValueExact());){
            Status status = response.status();
            Objects.requireNonNull(status);
            Status status2 = status;
            int n = 0;
            block11: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Status.class, Status.class}, (Object)status2, n)) {
                    case 0: {
                        Status s = status2;
                        if (!s.family().equals((Object)Status.Family.SUCCESSFUL)) {
                            n = 1;
                            continue block11;
                        }
                        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                            LOGGER.log(System.Logger.Level.DEBUG, "Successfully renewed lease");
                        }
                        if (!response.entity().hasEntity()) return instanceInfo;
                        instanceInfo = (JsonObject)response.entity().as(JsonObject.class);
                        assert (instanceInfo != null) : "Eureka Server contract violation; instanceInfo == null";
                        if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) return instanceInfo;
                        LOGGER.log(System.Logger.Level.DEBUG, "New registration details received: " + String.valueOf(instanceInfo));
                        return instanceInfo;
                    }
                    case 1: {
                        boolean registrationResult;
                        Status s = status2;
                        if (s.code() != 404) {
                            n = 2;
                            continue block11;
                        }
                        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                            LOGGER.log(System.Logger.Level.DEBUG, "Lease not found; reregistering");
                        }
                        if ((registrationResult = this.register(instanceInfo = this.json(instanceInfo, System.currentTimeMillis()))) || !LOGGER.isLoggable(System.Logger.Level.DEBUG)) return instanceInfo;
                        LOGGER.log(System.Logger.Level.DEBUG, "Reregistration failed");
                        return instanceInfo;
                    }
                    default: {
                        if (!LOGGER.isLoggable(System.Logger.Level.WARNING)) return instanceInfo;
                        LOGGER.log(System.Logger.Level.WARNING, "Heartbeat HTTP status: " + String.valueOf(response.status()));
                        if (!response.entity().hasEntity()) return instanceInfo;
                        LOGGER.log(System.Logger.Level.WARNING, ((JsonObject)response.entity().as(JsonObject.class)).getString("error"));
                        return instanceInfo;
                    }
                }
                break;
            }
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            if (!(cause instanceof ConnectException)) throw e;
            if (!LOGGER.isLoggable(System.Logger.Level.WARNING)) return instanceInfo;
            LOGGER.log(System.Logger.Level.WARNING, "Eureka Server (" + String.valueOf(((Http1ClientConfig)this.client.prototype()).baseUri().orElse(null)) + ") not reachable", (Throwable)e);
            return instanceInfo;
        }
    }

    private boolean up(JsonObject oldInstanceInfo, boolean up) {
        if (oldInstanceInfo == null) {
            return false;
        }
        JsonObject instanceInfo = this.json(oldInstanceInfo, up ? UP : DOWN);
        if (instanceInfo == oldInstanceInfo) {
            return false;
        }
        this.instanceInfo = instanceInfo;
        this.statusChange();
        return true;
    }

    private JsonObject json(JsonObject json, long lastDirtyTimestamp) {
        JsonObject instance = json.getJsonObject("instance");
        if (lastDirtyTimestamp <= instance.getJsonNumber("lastDirtyTimestamp").longValueExact()) {
            return json;
        }
        JsonBuilderFactory jbf = this.prototype.instanceInfo().jsonBuilderFactory();
        JsonObjectBuilder b = jbf.createObjectBuilder();
        instance.forEach((k, v) -> b.add(k, (JsonValue)(k.equals("lastDirtyTimestamp") ? Json.createValue((long)lastDirtyTimestamp) : v)));
        return jbf.createObjectBuilder().add("instance", b).build();
    }

    private JsonObject json(JsonObject json, JsonString status) {
        JsonObject instance = json.getJsonObject("instance");
        if (((JsonValue)instance.get((Object)"status")).equals((Object)Objects.requireNonNull(status, "status"))) {
            return json;
        }
        JsonBuilderFactory jbf = this.prototype.instanceInfo().jsonBuilderFactory();
        JsonObjectBuilder b = jbf.createObjectBuilder();
        JsonObjectBuilder b0 = jbf.createObjectBuilder();
        instance.forEach((k, v) -> b0.add(k, switch (k) {
            case "lastDirtyTimestamp" -> Json.createValue((Number)System.currentTimeMillis());
            case "status" -> {
                switch (status.getString()) {
                    case "UP": {
                        yield UP;
                    }
                    case "DOWN": {
                        yield DOWN;
                    }
                    case "STARTING": {
                        yield STARTING;
                    }
                    case "OUT_OF_SERVICE": {
                        yield OUT_OF_SERVICE;
                    }
                }
                yield UNKNOWN;
            }
            default -> v;
        }));
        b.add("instance", b0);
        return b.build();
    }

    static JsonObject json(InstanceInfoConfig prototype, int actualPort, boolean tls) {
        JsonBuilderFactory jbf = prototype.jsonBuilderFactory();
        JsonObjectBuilder instance = jbf.createObjectBuilder();
        instance.add("instanceId", prototype.instanceId(actualPort));
        instance.add("app", prototype.appName());
        instance.add("appGroupName", prototype.appGroupName());
        instance.add("dataCenterInfo", jbf.createObjectBuilder().add("name", "MyOwn").add("@class", "com.netflix.appinfo.MyDataCenterInfo"));
        instance.add("ipAddr", prototype.ipAddr());
        instance.add("hostName", prototype.hostName());
        boolean portEnabled = prototype.portEnabled(tls);
        int port = prototype.port(actualPort, tls);
        instance.add("port", jbf.createObjectBuilder().add("$", port).add("@enabled", portEnabled));
        boolean securePortEnabled = prototype.securePortEnabled(tls);
        int securePort = prototype.securePort(actualPort, tls);
        instance.add("securePort", jbf.createObjectBuilder().add("$", securePort).add("@enabled", securePortEnabled));
        if (portEnabled) {
            instance.add("vipAddress", prototype.vipAddress().orElseGet(() -> prototype.hostName() + ":" + port));
        }
        if (securePortEnabled) {
            instance.add("secureVipAddress", prototype.secureVipAddress().orElseGet(() -> prototype.hostName() + ":" + securePort));
        }
        instance.add("homePageUrl", prototype.homePageUrl().map(URI::toString).orElseGet(() -> "http://" + prototype.hostName() + ":" + port + prototype.homePageUrlPath()));
        instance.add("statusPageUrl", prototype.statusPageUrl().map(URI::toString).orElseGet(() -> "http://" + prototype.hostName() + ":" + port + prototype.statusPageUrlPath()));
        prototype.asgName().ifPresent(asgName -> instance.add("asgName", asgName));
        instance.add("healthCheckUrl", prototype.healthCheckUrl().map(URI::toString).orElseGet(() -> "http://" + prototype.hostName() + ":" + port + prototype.healthCheckUrlPath()));
        instance.add("secureHealthCheckUrl", prototype.secureHealthCheckUrl().map(URI::toString).orElseGet(() -> "https://" + prototype.hostName() + ":" + securePort + prototype.healthCheckUrlPath()));
        instance.add("sid", "na");
        instance.add("countryId", 1);
        instance.add("overriddenStatus", "UNKNOWN");
        long ts = System.currentTimeMillis();
        instance.add("lastUpdatedTimestamp", ts);
        instance.add("lastDirtyTimestamp", ts);
        instance.add("status", prototype.trafficEnabled() ? "UP" : "STARTING");
        Map<String, String> metadata = prototype.metadata();
        if (metadata.isEmpty()) {
            instance.add("metadata", (JsonValue)JsonValue.EMPTY_JSON_OBJECT);
        } else {
            JsonObjectBuilder mb = jbf.createObjectBuilder();
            metadata.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)mb).add(arg_0, arg_1));
            instance.add("metadata", mb);
        }
        instance.add("leaseInfo", jbf.createObjectBuilder().add("renewalIntervalInSecs", prototype.leaseInfo().renewalIntervalInSecs()).add("durationInSecs", prototype.leaseInfo().durationInSecs()));
        return jbf.createObjectBuilder().add("instance", instance).build();
    }
}

