/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.integrations.common.rest.ApiEntityResponse;
import io.helidon.integrations.common.rest.ApiOptionalResponse;
import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.webclient.WebClient;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriterFactory;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Consumer;

public interface RestApi {
    default public <R, T extends ApiOptionalResponse<R>> Single<T> get(String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> responseBuilder) {
        return this.invokeOptional((Http.RequestMethod)Http.Method.GET, path, request, responseBuilder);
    }

    default public <R, T extends ApiOptionalResponse<R>> Single<T> getPublisher(String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, Multi<DataChunk>, R> responseBuilder) {
        return this.invokePublisherResponse((Http.RequestMethod)Http.Method.GET, path, request, responseBuilder);
    }

    default public <R, T extends ApiOptionalResponse<R>> Single<T> getBytes(String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, byte[], R> responseBuilder) {
        return this.invokeBytesResponse((Http.RequestMethod)Http.Method.GET, path, request, responseBuilder);
    }

    default public <T extends ApiResponse> Single<T> post(String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        return this.invoke((Http.RequestMethod)Http.Method.POST, path, request, responseBuilder);
    }

    default public <T extends ApiResponse> Single<T> put(String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        return this.invoke((Http.RequestMethod)Http.Method.PUT, path, request, responseBuilder);
    }

    default public <T extends ApiResponse> Single<T> delete(String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        return this.invoke((Http.RequestMethod)Http.Method.DELETE, path, request, responseBuilder);
    }

    public <T extends ApiResponse> Single<T> invoke(Http.RequestMethod var1, String var2, ApiRequest<?> var3, ApiResponse.Builder<?, T> var4);

    public <T extends ApiEntityResponse> Single<T> invokeWithResponse(Http.RequestMethod var1, String var2, ApiRequest<?> var3, ApiEntityResponse.Builder<?, T, JsonObject> var4);

    public <T extends ApiResponse> Single<T> invokeBytesRequest(Http.RequestMethod var1, String var2, ApiRequest<?> var3, Flow.Publisher<DataChunk> var4, ApiResponse.Builder<?, T> var5);

    public <R, T extends ApiOptionalResponse<R>> Single<T> invokePublisherResponse(Http.RequestMethod var1, String var2, ApiRequest<?> var3, ApiOptionalResponse.BuilderBase<?, T, Multi<DataChunk>, R> var4);

    public <R, T extends ApiOptionalResponse<R>> Single<T> invokeBytesResponse(Http.RequestMethod var1, String var2, ApiRequest<?> var3, ApiOptionalResponse.BuilderBase<?, T, byte[], R> var4);

    public <R, T extends ApiOptionalResponse<R>> Single<T> invokeOptional(Http.RequestMethod var1, String var2, ApiRequest<?> var3, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> var4);

    public static abstract class Builder<B extends Builder<B, T>, T extends RestApi>
    implements io.helidon.common.Builder<B, T> {
        private final WebClient.Builder webClientBuilder = WebClient.builder().followRedirects(true).keepAlive(true);
        private FtHandler ftHandler = FaultTolerance.builder().build();
        private JsonBuilderFactory jsonBuilderFactory;
        private JsonReaderFactory jsonReaderFactory;
        private JsonWriterFactory jsonWriterFactory;
        private WebClient webClient;

        public final T build() {
            this.preBuild();
            T result = this.doBuild();
            this.postBuild();
            return result;
        }

        public final T get() {
            return (T)this.build();
        }

        public B config(Config config) {
            this.webClientBuilder.config(config.get("webclient"));
            Map jsonConfig = (Map)config.get("jsonp").asMap().orElseGet(Map::of);
            if (this.jsonBuilderFactory == null) {
                this.jsonBuilderFactory = Json.createBuilderFactory((Map)jsonConfig);
            }
            if (this.jsonReaderFactory == null) {
                this.jsonReaderFactory = Json.createReaderFactory((Map)jsonConfig);
            }
            if (this.jsonWriterFactory == null) {
                this.jsonWriterFactory = Json.createWriterFactory((Map)jsonConfig);
            }
            return this.me();
        }

        public B faultTolerance(FtHandler ftHandler) {
            this.ftHandler = ftHandler;
            return this.me();
        }

        public B webClientBuilder(Consumer<WebClient.Builder> updater) {
            updater.accept(this.webClientBuilder);
            return this.me();
        }

        protected B me() {
            return (B)this;
        }

        protected void preBuild() {
            this.webClientBuilder.addMediaSupport((MediaSupport)JsonpSupport.create());
            this.webClient = this.webClientBuilder.build();
            if (this.jsonBuilderFactory == null) {
                this.jsonBuilderFactory = Json.createBuilderFactory(Map.of());
            }
            if (this.jsonReaderFactory == null) {
                this.jsonReaderFactory = Json.createReaderFactory(Map.of());
            }
            if (this.jsonWriterFactory == null) {
                this.jsonWriterFactory = Json.createWriterFactory(Map.of());
            }
        }

        protected void postBuild() {
        }

        protected abstract T doBuild();

        protected WebClient webClient() {
            return this.webClient;
        }

        protected FtHandler ftHandler() {
            return this.ftHandler;
        }

        protected JsonBuilderFactory jsonBuilderFactory() {
            return this.jsonBuilderFactory;
        }

        protected JsonReaderFactory jsonReaderFactory() {
            return this.jsonReaderFactory;
        }

        protected JsonWriterFactory jsonWriterFactory() {
            return this.jsonWriterFactory;
        }
    }
}

