/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.integrations.common.rest.ApiException;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ApiJsonParser {
    private static final Optional<Boolean> EMPTY = Optional.empty();
    private static final Optional<Boolean> PRESENT = Optional.of(true);

    protected static String stringValue(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                throw new ApiException("Cannot create a simple String from an array: " + value);
            }
            case OBJECT: {
                throw new ApiException("Cannot create a simple String from an object: " + value);
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case NULL: {
                return "null";
            }
        }
        return value.toString();
    }

    protected static List<String> toList(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> {
            LinkedList<String> result = new LinkedList<String>();
            JsonArray jsonArray = json.getJsonArray(name);
            for (JsonValue jsonValue : jsonArray) {
                result.add(ApiJsonParser.stringValue(jsonValue));
            }
            return List.copyOf(result);
        }).orElseGet(List::of);
    }

    protected static Optional<byte[]> toBytesBase64(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> Base64.getDecoder().decode(json.getString(name)));
    }

    protected static Optional<JsonObject> toObject(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> json.getJsonObject(name));
    }

    protected static Optional<String> toString(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> json.getString(name));
    }

    protected static Optional<Integer> toInt(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> json.getInt(name));
    }

    protected static Optional<Long> toLong(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> json.getJsonNumber(name).longValue());
    }

    protected static Optional<Double> toDouble(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> json.getJsonNumber(name).doubleValue());
    }

    protected static Optional<Boolean> toBoolean(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> json.getBoolean(name));
    }

    protected static Optional<Instant> toInstant(JsonObject json, String name, DateTimeFormatter formatter) {
        return ApiJsonParser.isPresent(json, name).flatMap(ignored -> {
            String timeString = json.getString(name);
            if (timeString.isBlank()) {
                return Optional.empty();
            }
            return Optional.of(Instant.from(formatter.parse(timeString)));
        });
    }

    protected static Map<String, String> toMap(JsonObject json, String name) {
        return ApiJsonParser.isPresent(json, name).map(ignored -> {
            HashMap map = new HashMap();
            json.getJsonObject(name).forEach((key, value) -> map.put(key, ApiJsonParser.stringValue(value)));
            return Map.copyOf(map);
        }).orElseGet(Map::of);
    }

    protected static Optional<Boolean> isPresent(JsonObject json, String name) {
        if (!json.containsKey((Object)name) || json.isNull(name)) {
            return EMPTY;
        }
        return PRESENT;
    }
}

