/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.datasource.cdi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.inject.Named;
import javax.sql.DataSource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

public abstract class AbstractDataSourceExtension
implements Extension {
    private final Map<String, Properties> masterProperties = new HashMap<String, Properties>();
    private final Map<String, Properties> explicitlySetProperties = new HashMap<String, Properties>();
    private final Config config = ConfigProvider.getConfig();

    protected AbstractDataSourceExtension() {
    }

    protected abstract Matcher getDataSourcePropertyPatternMatcher(String var1);

    protected abstract String getDataSourceName(Matcher var1);

    protected abstract String getDataSourcePropertyName(Matcher var1);

    protected abstract void addBean(BeanConfigurator<DataSource> var1, Named var2, Properties var3);

    protected final Config getConfig() {
        return this.config;
    }

    protected final Set<String> getDataSourceNames() {
        Set<Object> returnValue = this.masterProperties.isEmpty() ? (this.explicitlySetProperties.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.explicitlySetProperties.keySet())) : Collections.unmodifiableSet(this.masterProperties.keySet());
        return returnValue;
    }

    protected final Properties putDataSourceProperties(String dataSourceName, Properties properties) {
        return this.explicitlySetProperties.put(dataSourceName, properties);
    }

    protected final void initializeMasterProperties() {
        this.masterProperties.clear();
        Set<String> allPropertyNames = this.getPropertyNames();
        if (allPropertyNames != null && !allPropertyNames.isEmpty()) {
            for (String propertyName : allPropertyNames) {
                Matcher matcher;
                Optional propertyValue = this.config.getOptionalValue(propertyName, String.class);
                if (propertyValue == null || !propertyValue.isPresent() || (matcher = this.getDataSourcePropertyPatternMatcher(propertyName)) == null || !matcher.matches()) continue;
                String dataSourceName = this.getDataSourceName(matcher);
                Properties properties = this.masterProperties.get(dataSourceName);
                if (properties == null) {
                    properties = new Properties();
                    this.masterProperties.put(dataSourceName, properties);
                }
                String dataSourcePropertyName = this.getDataSourcePropertyName(matcher);
                properties.setProperty(dataSourcePropertyName, (String)propertyValue.get());
            }
        }
        this.masterProperties.putAll(this.explicitlySetProperties);
    }

    protected final Set<String> getPropertyNames() {
        Set<String> propertyNames = AbstractDataSourceExtension.getPropertyNames(this.config.getConfigSources());
        assert (propertyNames != null);
        Iterable configPropertyNames = this.config.getPropertyNames();
        if (configPropertyNames != null) {
            for (String configPropertyName : configPropertyNames) {
                propertyNames.add(configPropertyName);
            }
        }
        Set<Object> returnValue = propertyNames.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(propertyNames);
        return returnValue;
    }

    private static Set<String> getPropertyNames(Iterable<? extends ConfigSource> configSources) {
        HashSet<String> returnValue = new HashSet<String>();
        if (configSources != null) {
            for (ConfigSource configSource : configSources) {
                Set configSourcePropertyNames;
                if (configSource == null || (configSourcePropertyNames = configSource.getPropertyNames()) == null || configSourcePropertyNames.isEmpty()) continue;
                returnValue.addAll(configSourcePropertyNames);
            }
        }
        return returnValue;
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        if (event != null) {
            Set<Map.Entry<String, Properties>> masterPropertiesEntries;
            if (this.masterProperties.isEmpty()) {
                this.initializeMasterProperties();
            }
            if ((masterPropertiesEntries = this.masterProperties.entrySet()) != null && !masterPropertiesEntries.isEmpty()) {
                for (Map.Entry<String, Properties> entry : masterPropertiesEntries) {
                    if (entry == null) continue;
                    this.addBean((BeanConfigurator<DataSource>)event.addBean(), (Named)NamedLiteral.of((String)entry.getKey()), entry.getValue());
                }
            }
        }
        this.masterProperties.clear();
        this.explicitlySetProperties.clear();
    }
}

