/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.datasource.ucp.cdi;

import io.helidon.integrations.datasource.cdi.AbstractDataSourceExtension;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Named;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;

public class UCPBackedDataSourceExtension
extends AbstractDataSourceExtension {
    static final Pattern DATASOURCE_NAME_PATTERN = Pattern.compile("^(?:javax\\.sql\\.|oracle\\.ucp\\.jdbc\\.Pool)(XA)?DataSource\\.([^.]+)\\.(.*)$");
    private final Map<String, Boolean> xa = new HashMap<String, Boolean>();

    @Deprecated
    public UCPBackedDataSourceExtension() {
    }

    protected final Matcher getDataSourcePropertyPatternMatcher(String configPropertyName) {
        return configPropertyName == null ? null : DATASOURCE_NAME_PATTERN.matcher(configPropertyName);
    }

    protected final String getDataSourceName(Matcher dataSourcePropertyPatternMatcher) {
        String returnValue;
        if (dataSourcePropertyPatternMatcher == null) {
            returnValue = null;
        } else {
            returnValue = dataSourcePropertyPatternMatcher.group(2);
            this.xa.put(returnValue, dataSourcePropertyPatternMatcher.group(1) != null);
        }
        return returnValue;
    }

    protected final String getDataSourcePropertyName(Matcher dataSourcePropertyPatternMatcher) {
        return dataSourcePropertyPatternMatcher == null ? null : dataSourcePropertyPatternMatcher.group(3);
    }

    protected final void addBean(BeanConfigurator<DataSource> beanConfigurator, Named dataSourceName, Properties dataSourceProperties) {
        boolean xa = this.xa.get(dataSourceName.value());
        beanConfigurator.addQualifier((Annotation)dataSourceName).addTransitiveTypeClosure(xa ? PoolXADataSourceImpl.class : PoolDataSourceImpl.class).scope(ApplicationScoped.class).produceWith(instance -> {
            try {
                return UCPBackedDataSourceExtension.createDataSource((Instance<Object>)instance, dataSourceName, xa, dataSourceProperties);
            }
            catch (IntrospectionException | ReflectiveOperationException | SQLException | UniversalConnectionPoolException exception) {
                throw new CreationException(exception.getMessage(), exception);
            }
        }).disposeWith((dataSource, ignored) -> {
            if (dataSource instanceof AutoCloseable) {
                AutoCloseable autoCloseable = (AutoCloseable)dataSource;
                try {
                    autoCloseable.close();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new CreationException(exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    private static PoolDataSource createDataSource(Instance<Object> instance, Named dataSourceName, boolean xa, Properties properties) throws IntrospectionException, ReflectiveOperationException, SQLException, UniversalConnectionPoolException {
        Instance sslContextInstance;
        PoolXADataSource returnValue = xa ? PoolDataSourceFactory.getPoolXADataSource() : PoolDataSourceFactory.getPoolDataSource();
        Set<String> propertyNames = properties.stringPropertyNames();
        if (!propertyNames.isEmpty()) {
            Properties connectionFactoryProperties = new Properties();
            BeanInfo beanInfo = Introspector.getBeanInfo(returnValue.getClass());
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            for (String propertyName : propertyNames) {
                if (propertyName == null) continue;
                boolean handled = false;
                for (PropertyDescriptor pd : pds) {
                    Method writeMethod;
                    if (!propertyName.equals(pd.getName()) || (writeMethod = pd.getWriteMethod()) == null) continue;
                    Class<?> type = pd.getPropertyType();
                    if (type.equals(String.class)) {
                        writeMethod.invoke((Object)returnValue, properties.getProperty(propertyName));
                        handled = true;
                        continue;
                    }
                    if (type.equals(Integer.TYPE)) {
                        writeMethod.invoke((Object)returnValue, Integer.parseInt(properties.getProperty(propertyName)));
                        handled = true;
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        writeMethod.invoke((Object)returnValue, Long.parseLong(properties.getProperty(propertyName)));
                        handled = true;
                        continue;
                    }
                    if (!type.equals(Boolean.TYPE)) continue;
                    writeMethod.invoke((Object)returnValue, Boolean.parseBoolean(properties.getProperty(propertyName)));
                    handled = true;
                }
                if (handled) continue;
                connectionFactoryProperties.setProperty(propertyName, properties.getProperty(propertyName));
            }
            if (!connectionFactoryProperties.stringPropertyNames().isEmpty()) {
                returnValue.setConnectionFactoryProperties(connectionFactoryProperties);
            }
        }
        if (returnValue.getConnectionPoolName() == null) {
            String[] existingConnectionPoolNames;
            String proposedConnectionPoolName = dataSourceName.value();
            for (String existingConnectionPoolName : existingConnectionPoolNames = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager().getConnectionPoolNames()) {
                if (!proposedConnectionPoolName.equals(existingConnectionPoolName)) continue;
                proposedConnectionPoolName = null;
                break;
            }
            if (proposedConnectionPoolName != null) {
                returnValue.setConnectionPoolName(proposedConnectionPoolName);
            }
        }
        if (!(sslContextInstance = instance.select(SSLContext.class, new Annotation[]{dataSourceName})).isUnsatisfied()) {
            returnValue.setSSLContext((SSLContext)sslContextInstance.get());
        }
        if (xa) {
            ((Event)instance.select((TypeLiteral)new TypeLiteral<Event<PoolXADataSource>>(){}, new Annotation[]{dataSourceName}).get()).fire((Object)returnValue);
        } else {
            ((Event)instance.select((TypeLiteral)new TypeLiteral<Event<PoolDataSource>>(){}, new Annotation[]{dataSourceName}).get()).fire((Object)returnValue);
        }
        return returnValue;
    }
}

