/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.datasource.ucp.cdi;

import io.helidon.integrations.cdi.configurable.AbstractConfigurableExtension;
import io.helidon.integrations.datasource.ucp.cdi.UCPBackedDataSourceExtension;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.regex.Matcher;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;

public class UniversalConnectionPoolExtension
extends AbstractConfigurableExtension<UniversalConnectionPool> {
    @Deprecated
    public UniversalConnectionPoolExtension() {
    }

    protected final Matcher matcher(String configPropertyName) {
        return configPropertyName == null ? null : UCPBackedDataSourceExtension.DATASOURCE_NAME_PATTERN.matcher(configPropertyName);
    }

    protected final String name(Matcher configPropertyNameMatcher) {
        return configPropertyNameMatcher == null ? null : configPropertyNameMatcher.group(2);
    }

    protected final String propertyName(Matcher configPropertyNameMatcher) {
        return configPropertyNameMatcher == null ? null : configPropertyNameMatcher.group(3);
    }

    private void installManager(@Observes AfterBeanDiscovery event) {
        event.addBean().addTransitiveTypeClosure(UniversalConnectionPoolManager.class).scope(ApplicationScoped.class).produceWith(instance -> {
            UniversalConnectionPoolManager ucpm;
            try {
                ucpm = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
            }
            catch (UniversalConnectionPoolException e) {
                throw new CreationException(e.getMessage(), (Throwable)e);
            }
            ((Event)instance.select((TypeLiteral)new TypeLiteral<Event<UniversalConnectionPoolManager>>(){}, new Annotation[0]).get()).fire((Object)ucpm);
            return ucpm;
        });
    }

    protected void addBean(BeanConfigurator<UniversalConnectionPool> beanConfigurator, Named name, Properties properties) {
        beanConfigurator.addQualifier((Annotation)name).addTransitiveTypeClosure(UniversalConnectionPool.class).scope(ApplicationScoped.class).produceWith(instance -> {
            UniversalConnectionPool ucp;
            PoolDataSource pds = (PoolDataSource)instance.select(PoolDataSource.class, new Annotation[]{name}).get();
            UniversalConnectionPoolManager ucpm = (UniversalConnectionPoolManager)instance.select(UniversalConnectionPoolManager.class, new Annotation[0]).get();
            try {
                ucpm.createConnectionPool((UniversalConnectionPoolAdapter)pds);
                ucp = ucpm.getConnectionPool(pds.getConnectionPoolName());
            }
            catch (UniversalConnectionPoolException e) {
                throw new CreationException(e.getMessage(), (Throwable)e);
            }
            ((Event)instance.select((TypeLiteral)new TypeLiteral<Event<UniversalConnectionPool>>(){}, new Annotation[0]).get()).fire((Object)ucp);
            return ucp;
        }).disposeWith((ucp, instance) -> {
            try {
                ucp.stop();
                UniversalConnectionPoolManager ucpm = (UniversalConnectionPoolManager)instance.select(UniversalConnectionPoolManager.class, new Annotation[0]).get();
                ucpm.destroyConnectionPool(ucp.getName());
            }
            catch (UniversalConnectionPoolException e) {
                throw new CreationException(e.getMessage(), (Throwable)e);
            }
        });
    }
}

