/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.datasource.ucp.cdi;

import io.helidon.integrations.datasource.cdi.AbstractDataSourceExtension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;

public class UCPBackedDataSourceExtension
extends AbstractDataSourceExtension {
    private static final Pattern DATASOURCE_NAME_PATTERN = Pattern.compile("^(?:javax\\.sql\\.|oracle\\.ucp\\.jdbc\\.Pool)DataSource\\.([^.]+)\\.(.*)$");

    protected final Matcher getDataSourcePropertyPatternMatcher(String configPropertyName) {
        Matcher returnValue = configPropertyName == null ? null : DATASOURCE_NAME_PATTERN.matcher(configPropertyName);
        return returnValue;
    }

    protected final String getDataSourceName(Matcher dataSourcePropertyPatternMatcher) {
        String returnValue = dataSourcePropertyPatternMatcher == null ? null : dataSourcePropertyPatternMatcher.group(1);
        return returnValue;
    }

    protected final String getDataSourcePropertyName(Matcher dataSourcePropertyPatternMatcher) {
        String returnValue = dataSourcePropertyPatternMatcher == null ? null : dataSourcePropertyPatternMatcher.group(2);
        return returnValue;
    }

    protected final void addBean(BeanConfigurator<DataSource> beanConfigurator, Named dataSourceName, Properties dataSourceProperties) {
        beanConfigurator.addQualifier((Annotation)dataSourceName).addTransitiveTypeClosure(PoolDataSourceImpl.class).scope(ApplicationScoped.class).produceWith(instance -> {
            try {
                return UCPBackedDataSourceExtension.createDataSource((Instance<Object>)instance, dataSourceName, dataSourceProperties);
            }
            catch (IntrospectionException | ReflectiveOperationException | SQLException exception) {
                throw new CreationException(exception.getMessage(), (Throwable)exception);
            }
        }).disposeWith((dataSource, ignored) -> {
            if (dataSource instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)dataSource).close();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new CreationException(exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    private static PoolDataSourceImpl createDataSource(Instance<Object> instance, Named dataSourceName, Properties properties) throws IntrospectionException, ReflectiveOperationException, SQLException {
        Instance sslContextInstance;
        PoolDataSourceImpl returnValue = new PoolDataSourceImpl();
        Set<String> propertyNames = properties.stringPropertyNames();
        if (!propertyNames.isEmpty()) {
            Properties connectionFactoryProperties = new Properties();
            BeanInfo beanInfo = Introspector.getBeanInfo(returnValue.getClass());
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            for (String propertyName : propertyNames) {
                if (propertyName == null) continue;
                boolean handled = false;
                for (PropertyDescriptor pd : pds) {
                    Method writeMethod;
                    if (!propertyName.equals(pd.getName()) || (writeMethod = pd.getWriteMethod()) == null) continue;
                    Class<?> type = pd.getPropertyType();
                    if (type.equals(String.class)) {
                        writeMethod.invoke((Object)returnValue, properties.getProperty(propertyName));
                        handled = true;
                        continue;
                    }
                    if (type.equals(Integer.TYPE)) {
                        writeMethod.invoke((Object)returnValue, Integer.parseInt(properties.getProperty(propertyName)));
                        handled = true;
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        writeMethod.invoke((Object)returnValue, Long.parseLong(properties.getProperty(propertyName)));
                        handled = true;
                        continue;
                    }
                    if (!type.equals(Boolean.TYPE)) continue;
                    writeMethod.invoke((Object)returnValue, Boolean.parseBoolean(properties.getProperty(propertyName)));
                    handled = true;
                }
                if (handled) continue;
                connectionFactoryProperties.setProperty(propertyName, properties.getProperty(propertyName));
            }
            Object serviceName = connectionFactoryProperties.remove("serviceName");
            Object pdbRoles = connectionFactoryProperties.remove("pdbRoles");
            connectionFactoryProperties.remove("tnsNetServiceName");
            if (!connectionFactoryProperties.stringPropertyNames().isEmpty()) {
                returnValue.setConnectionFactoryProperties(connectionFactoryProperties);
            }
            if (serviceName instanceof String) {
                try {
                    Method m = returnValue.getClass().getDeclaredMethod("setServiceName", String.class);
                    if (m.trySetAccessible()) {
                        m.invoke((Object)returnValue, serviceName);
                    }
                }
                catch (NoSuchMethodException m) {
                    // empty catch block
                }
            }
            if (pdbRoles instanceof Properties) {
                try {
                    Method m = returnValue.getClass().getDeclaredMethod("setPdbRoles", Properties.class);
                    if (m.trySetAccessible()) {
                        m.invoke((Object)returnValue, pdbRoles);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (!(sslContextInstance = instance.select(SSLContext.class, new Annotation[]{dataSourceName})).isUnsatisfied()) {
            returnValue.setSSLContext((SSLContext)sslContextInstance.get());
        }
        ((Event)instance.select((TypeLiteral)new TypeLiteral<Event<PoolDataSource>>(){}, new Annotation[]{dataSourceName}).get()).fire((Object)returnValue);
        return returnValue;
    }
}

