/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.datasource.ucp.cdi;

import io.helidon.integrations.datasource.cdi.AbstractDataSourceExtension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.inject.Named;
import javax.sql.DataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

public class UCPBackedDataSourceExtension
extends AbstractDataSourceExtension {
    private static final Pattern DATASOURCE_NAME_PATTERN = Pattern.compile("^(?:javax\\.sql\\.|oracle\\.ucp\\.jdbc\\.Pool)DataSource\\.([^.]+)\\.(.*)$");

    protected final Matcher getDataSourcePropertyPatternMatcher(String configPropertyName) {
        Matcher returnValue = configPropertyName == null ? null : DATASOURCE_NAME_PATTERN.matcher(configPropertyName);
        return returnValue;
    }

    protected final String getDataSourceName(Matcher dataSourcePropertyPatternMatcher) {
        String returnValue = dataSourcePropertyPatternMatcher == null ? null : dataSourcePropertyPatternMatcher.group(1);
        return returnValue;
    }

    protected final String getDataSourcePropertyName(Matcher dataSourcePropertyPatternMatcher) {
        String returnValue = dataSourcePropertyPatternMatcher == null ? null : dataSourcePropertyPatternMatcher.group(2);
        return returnValue;
    }

    protected final void addBean(BeanConfigurator<DataSource> beanConfigurator, Named dataSourceName, Properties dataSourceProperties) {
        beanConfigurator.addQualifier((Annotation)dataSourceName).addTransitiveTypeClosure(PoolDataSource.class).scope(ApplicationScoped.class).createWith(cc -> {
            try {
                return UCPBackedDataSourceExtension.createDataSource(dataSourceProperties);
            }
            catch (IntrospectionException | ReflectiveOperationException exception) {
                throw new CreationException(exception.getMessage(), (Throwable)exception);
            }
        }).destroyWith((dataSource, ignored) -> {
            if (dataSource instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)dataSource)).close();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new CreationException(exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    private static PoolDataSource createDataSource(Properties properties) throws IntrospectionException, ReflectiveOperationException {
        Objects.requireNonNull(properties);
        PoolDataSource returnValue = PoolDataSourceFactory.getPoolDataSource();
        assert (returnValue != null);
        Set<String> propertyNames = properties.stringPropertyNames();
        assert (propertyNames != null);
        if (!propertyNames.isEmpty()) {
            BeanInfo beanInfo = Introspector.getBeanInfo(returnValue.getClass());
            assert (beanInfo != null);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            assert (pds != null);
            assert (pds.length > 0);
            for (String propertyName : propertyNames) {
                if (propertyName == null) continue;
                for (PropertyDescriptor pd : pds) {
                    Method writeMethod;
                    assert (pd != null);
                    if (!propertyName.equals(pd.getName()) || (writeMethod = pd.getWriteMethod()) == null) continue;
                    Class<?> type = pd.getPropertyType();
                    assert (type != null);
                    if (type.equals(String.class)) {
                        writeMethod.invoke((Object)returnValue, properties.getProperty(propertyName));
                        continue;
                    }
                    if (type.equals(Integer.TYPE)) {
                        writeMethod.invoke((Object)returnValue, Integer.parseInt(properties.getProperty(propertyName)));
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        writeMethod.invoke((Object)returnValue, Long.parseLong(properties.getProperty(propertyName)));
                        continue;
                    }
                    if (!type.equals(Boolean.TYPE)) continue;
                    writeMethod.invoke((Object)returnValue, Boolean.parseBoolean(properties.getProperty(propertyName)));
                }
            }
        }
        return returnValue;
    }
}

