/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.encoding;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.http.Headers;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncoder;
import io.helidon.http.encoding.ContentEncodingContextConfig;
import io.helidon.http.encoding.ContentEncodingSupportImpl;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public interface ContentEncodingContext
extends RuntimeType.Api<ContentEncodingContextConfig> {
    public static ContentEncodingContext create() {
        return ContentEncodingContext.builder().build();
    }

    public static ContentEncodingContext create(Config config) {
        return ((ContentEncodingContextConfig.Builder)ContentEncodingContext.builder().config(config)).build();
    }

    public static ContentEncodingContext create(ContentEncodingContextConfig config) {
        return new ContentEncodingSupportImpl(config);
    }

    public static ContentEncodingContext create(Consumer<ContentEncodingContextConfig.Builder> consumer) {
        return ((ContentEncodingContextConfig.Builder)ContentEncodingContext.builder().update(consumer)).build();
    }

    public static ContentEncodingContextConfig.Builder builder() {
        return ContentEncodingContextConfig.builder();
    }

    public boolean contentEncodingEnabled();

    public boolean contentDecodingEnabled();

    public boolean contentEncodingSupported(String var1);

    public boolean contentDecodingSupported(String var1);

    public ContentEncoder encoder(String var1) throws NoSuchElementException;

    public ContentDecoder decoder(String var1) throws NoSuchElementException;

    public ContentEncoder encoder(Headers var1);
}

