/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.encoding.gzip;

import io.helidon.http.Http;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncoder;
import io.helidon.http.encoding.ContentEncoding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipEncoding
implements ContentEncoding {
    private static final Http.Header CONTENT_ENCODING_GZIP = Http.Headers.createCached((Http.HeaderName)Http.HeaderNames.CONTENT_ENCODING, (boolean)false, (boolean)false, (String)"gzip");
    private final String name;

    GzipEncoding(String name) {
        this.name = name;
    }

    public static GzipEncoding create() {
        return new GzipEncoding("gzip");
    }

    public Set<String> ids() {
        return Set.of("gzip", "x-gzip");
    }

    public boolean supportsEncoding() {
        return true;
    }

    public boolean supportsDecoding() {
        return true;
    }

    public ContentDecoder decoder() {
        return network -> {
            try {
                return new GZIPInputStream(network);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public ContentEncoder encoder() {
        return new ContentEncoder(this){

            public OutputStream encode(OutputStream network) {
                try {
                    return new GZIPOutputStream(network);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void headers(WritableHeaders<?> headers) {
                headers.add(CONTENT_ENCODING_GZIP);
                headers.remove(Http.HeaderNames.CONTENT_LENGTH);
            }
        };
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "gzip";
    }
}

