/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.RetriableStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ServiceConfigUtil {
    private ServiceConfigUtil() {
    }

    @Nullable
    public static String getHealthCheckedServiceName(@Nullable Map<String, ?> serviceConfig) {
        if (serviceConfig == null) {
            return null;
        }
        Map<String, ?> healthCheck = JsonUtil.getObject(serviceConfig, "healthCheckConfig");
        if (healthCheck == null) {
            return null;
        }
        return JsonUtil.getString(healthCheck, "serviceName");
    }

    @Nullable
    static RetriableStream.Throttle getThrottlePolicy(@Nullable Map<String, ?> serviceConfig) {
        if (serviceConfig == null) {
            return null;
        }
        Map<String, ?> throttling = JsonUtil.getObject(serviceConfig, "retryThrottling");
        if (throttling == null) {
            return null;
        }
        float maxTokens = JsonUtil.getNumber(throttling, "maxTokens").floatValue();
        float tokenRatio = JsonUtil.getNumber(throttling, "tokenRatio").floatValue();
        Preconditions.checkState((maxTokens > 0.0f ? 1 : 0) != 0, (Object)"maxToken should be greater than zero");
        Preconditions.checkState((tokenRatio > 0.0f ? 1 : 0) != 0, (Object)"tokenRatio should be greater than zero");
        return new RetriableStream.Throttle(maxTokens, tokenRatio);
    }

    @Nullable
    static Integer getMaxAttemptsFromRetryPolicy(Map<String, ?> retryPolicy) {
        return JsonUtil.getNumberAsInteger(retryPolicy, "maxAttempts");
    }

    @Nullable
    static Long getInitialBackoffNanosFromRetryPolicy(Map<String, ?> retryPolicy) {
        return JsonUtil.getStringAsDuration(retryPolicy, "initialBackoff");
    }

    @Nullable
    static Long getMaxBackoffNanosFromRetryPolicy(Map<String, ?> retryPolicy) {
        return JsonUtil.getStringAsDuration(retryPolicy, "maxBackoff");
    }

    @Nullable
    static Double getBackoffMultiplierFromRetryPolicy(Map<String, ?> retryPolicy) {
        return JsonUtil.getNumber(retryPolicy, "backoffMultiplier");
    }

    private static Set<Status.Code> getListOfStatusCodesAsSet(Map<String, ?> obj, String key) {
        List<?> statuses = JsonUtil.getList(obj, key);
        if (statuses == null) {
            return null;
        }
        return ServiceConfigUtil.getStatusCodesFromList(statuses);
    }

    private static Set<Status.Code> getStatusCodesFromList(List<?> statuses) {
        EnumSet<Status.Code> codes = EnumSet.noneOf(Status.Code.class);
        for (Object status : statuses) {
            Status.Code code;
            if (status instanceof Double) {
                Double statusD = (Double)status;
                int codeValue = statusD.intValue();
                Verify.verify(((double)codeValue == statusD ? 1 : 0) != 0, (String)"Status code %s is not integral", status);
                code = Status.fromCodeValue(codeValue).getCode();
                Verify.verify((code.value() == statusD.intValue() ? 1 : 0) != 0, (String)"Status code %s is not valid", status);
            } else if (status instanceof String) {
                try {
                    code = Status.Code.valueOf((String)status);
                }
                catch (IllegalArgumentException iae) {
                    throw new VerifyException("Status code " + status + " is not valid", (Throwable)iae);
                }
            } else {
                throw new VerifyException("Can not convert status code " + status + " to Status.Code, because its type is " + status.getClass());
            }
            codes.add(code);
        }
        return Collections.unmodifiableSet(codes);
    }

    static Set<Status.Code> getRetryableStatusCodesFromRetryPolicy(Map<String, ?> retryPolicy) {
        String retryableStatusCodesKey = "retryableStatusCodes";
        Set<Status.Code> codes = ServiceConfigUtil.getListOfStatusCodesAsSet(retryPolicy, retryableStatusCodesKey);
        Verify.verify((codes != null ? 1 : 0) != 0, (String)"%s is required in retry policy", (Object)retryableStatusCodesKey);
        Verify.verify((!codes.isEmpty() ? 1 : 0) != 0, (String)"%s must not be empty", (Object)retryableStatusCodesKey);
        Verify.verify((!codes.contains((Object)Status.Code.OK) ? 1 : 0) != 0, (String)"%s must not contain OK", (Object)retryableStatusCodesKey);
        return codes;
    }

    @Nullable
    static Integer getMaxAttemptsFromHedgingPolicy(Map<String, ?> hedgingPolicy) {
        return JsonUtil.getNumberAsInteger(hedgingPolicy, "maxAttempts");
    }

    @Nullable
    static Long getHedgingDelayNanosFromHedgingPolicy(Map<String, ?> hedgingPolicy) {
        return JsonUtil.getStringAsDuration(hedgingPolicy, "hedgingDelay");
    }

    static Set<Status.Code> getNonFatalStatusCodesFromHedgingPolicy(Map<String, ?> hedgingPolicy) {
        String nonFatalStatusCodesKey = "nonFatalStatusCodes";
        Set<Status.Code> codes = ServiceConfigUtil.getListOfStatusCodesAsSet(hedgingPolicy, nonFatalStatusCodesKey);
        if (codes == null) {
            return Collections.unmodifiableSet(EnumSet.noneOf(Status.Code.class));
        }
        Verify.verify((!codes.contains((Object)Status.Code.OK) ? 1 : 0) != 0, (String)"%s must not contain OK", (Object)nonFatalStatusCodesKey);
        return codes;
    }

    @Nullable
    static String getServiceFromName(Map<String, ?> name) {
        return JsonUtil.getString(name, "service");
    }

    @Nullable
    static String getMethodFromName(Map<String, ?> name) {
        return JsonUtil.getString(name, "method");
    }

    @Nullable
    static Map<String, ?> getRetryPolicyFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getObject(methodConfig, "retryPolicy");
    }

    @Nullable
    static Map<String, ?> getHedgingPolicyFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getObject(methodConfig, "hedgingPolicy");
    }

    @Nullable
    static List<Map<String, ?>> getNameListFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getListOfObjects(methodConfig, "name");
    }

    @Nullable
    static Long getTimeoutFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getStringAsDuration(methodConfig, "timeout");
    }

    @Nullable
    static Boolean getWaitForReadyFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getBoolean(methodConfig, "waitForReady");
    }

    @Nullable
    static Integer getMaxRequestMessageBytesFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getNumberAsInteger(methodConfig, "maxRequestMessageBytes");
    }

    @Nullable
    static Integer getMaxResponseMessageBytesFromMethodConfig(Map<String, ?> methodConfig) {
        return JsonUtil.getNumberAsInteger(methodConfig, "maxResponseMessageBytes");
    }

    @Nullable
    static List<Map<String, ?>> getMethodConfigFromServiceConfig(Map<String, ?> serviceConfig) {
        return JsonUtil.getListOfObjects(serviceConfig, "methodConfig");
    }

    @VisibleForTesting
    public static List<Map<String, ?>> getLoadBalancingConfigsFromServiceConfig(Map<String, ?> serviceConfig) {
        String policy;
        ArrayList lbConfigs = new ArrayList();
        String loadBalancingConfigKey = "loadBalancingConfig";
        if (serviceConfig.containsKey(loadBalancingConfigKey)) {
            lbConfigs.addAll(JsonUtil.getListOfObjects(serviceConfig, loadBalancingConfigKey));
        }
        if (lbConfigs.isEmpty() && (policy = JsonUtil.getString(serviceConfig, "loadBalancingPolicy")) != null) {
            policy = policy.toLowerCase(Locale.ROOT);
            Map fakeConfig = Collections.singletonMap(policy, Collections.emptyMap());
            lbConfigs.add(fakeConfig);
        }
        return Collections.unmodifiableList(lbConfigs);
    }

    public static LbConfig unwrapLoadBalancingConfig(Map<String, ?> lbConfig) {
        if (lbConfig.size() != 1) {
            throw new RuntimeException("There are " + lbConfig.size() + " fields in a LoadBalancingConfig object. Exactly one is expected. Config=" + lbConfig);
        }
        String key = lbConfig.entrySet().iterator().next().getKey();
        return new LbConfig(key, JsonUtil.getObject(lbConfig, key));
    }

    public static List<LbConfig> unwrapLoadBalancingConfigList(List<Map<String, ?>> list) {
        if (list == null) {
            return null;
        }
        ArrayList<LbConfig> result = new ArrayList<LbConfig>();
        for (Map<String, ?> rawChildPolicy : list) {
            result.add(ServiceConfigUtil.unwrapLoadBalancingConfig(rawChildPolicy));
        }
        return Collections.unmodifiableList(result);
    }

    @Nullable
    public static String getEdsServiceNameFromXdsConfig(Map<String, ?> rawXdsConfig) {
        return JsonUtil.getString(rawXdsConfig, "edsServiceName");
    }

    @Nullable
    public static String getLrsServerNameFromXdsConfig(Map<String, ?> rawXdsConfig) {
        return JsonUtil.getString(rawXdsConfig, "lrsLoadReportingServerName");
    }

    @Nullable
    public static List<LbConfig> getChildPolicyFromXdsConfig(Map<String, ?> rawXdsConfig) {
        return ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.getListOfObjects(rawXdsConfig, "childPolicy"));
    }

    @Nullable
    public static List<LbConfig> getFallbackPolicyFromXdsConfig(Map<String, ?> rawXdsConfig) {
        return ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.getListOfObjects(rawXdsConfig, "fallbackPolicy"));
    }

    @Nullable
    public static String getStickinessMetadataKeyFromServiceConfig(Map<String, ?> serviceConfig) {
        return JsonUtil.getString(serviceConfig, "stickinessMetadataKey");
    }

    public static final class LbConfig {
        private final String policyName;
        private final Map<String, ?> rawConfigValue;

        public LbConfig(String policyName, Map<String, ?> rawConfigValue) {
            this.policyName = (String)Preconditions.checkNotNull((Object)policyName, (Object)"policyName");
            this.rawConfigValue = (Map)Preconditions.checkNotNull(rawConfigValue, (Object)"rawConfigValue");
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public Map<String, ?> getRawConfigValue() {
            return this.rawConfigValue;
        }

        public boolean equals(Object o) {
            if (o instanceof LbConfig) {
                LbConfig other = (LbConfig)o;
                return this.policyName.equals(other.policyName) && this.rawConfigValue.equals(other.rawConfigValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.policyName, this.rawConfigValue});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("policyName", (Object)this.policyName).add("rawConfigValue", this.rawConfigValue).toString();
        }
    }
}

