/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ClientStreamTracer;
import io.grpc.CompressorRegistry;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.Context;
import io.grpc.DecompressorRegistry;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.InternalWithLogId;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.NameResolverRegistry;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractSubchannel;
import io.grpc.internal.AutoConfiguredLoadBalancerFactory2;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.CallCredentialsApplyingTransportFactory;
import io.grpc.internal.CallTracer;
import io.grpc.internal.ChannelLoggerImpl;
import io.grpc.internal.ChannelTracer;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectivityStateManager;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.InternalSubchannel;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.ManagedChannelServiceConfig2;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.OobChannel;
import io.grpc.internal.PickSubchannelArgsImpl;
import io.grpc.internal.Rescheduler;
import io.grpc.internal.RetriableStream;
import io.grpc.internal.ServiceConfigInterceptor2;
import io.grpc.internal.SubchannelChannel;
import io.grpc.internal.TimeProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ManagedChannelImpl2
extends ManagedChannel
implements InternalInstrumented<InternalChannelz.ChannelStats> {
    static final Logger logger = Logger.getLogger(ManagedChannelImpl2.class.getName());
    @VisibleForTesting
    static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:/.*");
    static final long IDLE_TIMEOUT_MILLIS_DISABLE = -1L;
    @VisibleForTesting
    static final long SUBCHANNEL_SHUTDOWN_DELAY_SECONDS = 5L;
    @VisibleForTesting
    static final Status SHUTDOWN_NOW_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdownNow invoked");
    @VisibleForTesting
    static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdown invoked");
    @VisibleForTesting
    static final Status SUBCHANNEL_SHUTDOWN_STATUS = Status.UNAVAILABLE.withDescription("Subchannel shutdown invoked");
    private static final ServiceConfigHolder EMPTY_SERVICE_CONFIG = new ServiceConfigHolder(Collections.emptyMap(), ManagedChannelServiceConfig2.empty());
    private final InternalLogId logId;
    private final String target;
    private final NameResolverRegistry nameResolverRegistry;
    private final NameResolver.Factory nameResolverFactory;
    private final NameResolver.Args nameResolverArgs;
    private final AutoConfiguredLoadBalancerFactory2 loadBalancerFactory;
    private final ClientTransportFactory transportFactory;
    private final RestrictedScheduledExecutor scheduledExecutor;
    private final Executor executor;
    private final ObjectPool<? extends Executor> executorPool;
    private final ObjectPool<? extends Executor> balancerRpcExecutorPool;
    private final ExecutorHolder balancerRpcExecutorHolder;
    private final ExecutorHolder offloadExecutorHolder;
    private final TimeProvider timeProvider;
    private final int maxTraceEvents;
    @VisibleForTesting
    final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.log(Level.SEVERE, "[" + ManagedChannelImpl2.this.getLogId() + "] Uncaught exception in the SynchronizationContext. Panic!", e);
            ManagedChannelImpl2.this.panic(e);
        }
    });
    private boolean fullStreamDecompression;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final long idleTimeoutMillis;
    private final ConnectivityStateManager channelStateManager = new ConnectivityStateManager();
    private final ServiceConfigInterceptor2 serviceConfigInterceptor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Channel interceptorChannel;
    @Nullable
    private final String userAgent;
    private NameResolver nameResolver;
    private boolean nameResolverStarted;
    @Nullable
    private LbHelperImpl lbHelper;
    @Nullable
    private volatile LoadBalancer.SubchannelPicker subchannelPicker;
    private boolean panicMode;
    private final Set<InternalSubchannel> subchannels = new HashSet<InternalSubchannel>(16, 0.75f);
    private final Set<OobChannel> oobChannels = new HashSet<OobChannel>(1, 0.75f);
    private final DelayedClientTransport delayedTransport;
    private final UncommittedRetriableStreamsRegistry uncommittedRetriableStreamsRegistry = new UncommittedRetriableStreamsRegistry();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean shutdownNowed;
    private volatile boolean terminating;
    private volatile boolean terminated;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private final CallTracer.Factory callTracerFactory;
    private final CallTracer channelCallTracer;
    private final ChannelTracer channelTracer;
    private final ChannelLogger channelLogger;
    private final InternalChannelz channelz;
    private ResolutionState lastResolutionState = ResolutionState.NO_RESOLUTION;
    private ServiceConfigHolder lastServiceConfig = EMPTY_SERVICE_CONFIG;
    @Nullable
    private final ServiceConfigHolder defaultServiceConfig;
    private boolean serviceConfigUpdated = false;
    private final boolean lookUpServiceConfig;
    private final RetriableStream.ChannelBufferMeter channelBufferUsed = new RetriableStream.ChannelBufferMeter();
    private final long perRpcBufferLimit;
    private final long channelBufferLimit;
    private final boolean retryEnabled;
    private final ManagedClientTransport.Listener delayedTransportListener = new DelayedTransportListener();
    @VisibleForTesting
    final InUseStateAggregator<Object> inUseStateAggregator = new IdleModeStateAggregator();
    @Nullable
    private SynchronizationContext.ScheduledHandle scheduledNameResolverRefresh;
    @Nullable
    private BackoffPolicy nameResolverBackoffPolicy;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ChannelTransportProvider();
    private final Rescheduler idleTimer;

    private void maybeShutdownNowSubchannels() {
        if (this.shutdownNowed) {
            for (InternalSubchannel subchannel : this.subchannels) {
                subchannel.shutdownNow(SHUTDOWN_NOW_STATUS);
            }
            for (OobChannel oobChannel : this.oobChannels) {
                oobChannel.getInternalSubchannel().shutdownNow(SHUTDOWN_NOW_STATUS);
            }
        }
    }

    @Override
    public ListenableFuture<InternalChannelz.ChannelStats> getStats() {
        final SettableFuture ret = SettableFuture.create();
        final class StatsFetcher
        implements Runnable {
            StatsFetcher() {
            }

            @Override
            public void run() {
                InternalChannelz.ChannelStats.Builder builder = new InternalChannelz.ChannelStats.Builder();
                ManagedChannelImpl2.this.channelCallTracer.updateBuilder(builder);
                ManagedChannelImpl2.this.channelTracer.updateBuilder(builder);
                builder.setTarget(ManagedChannelImpl2.this.target).setState(ManagedChannelImpl2.this.channelStateManager.getState());
                ArrayList<InternalWithLogId> children = new ArrayList<InternalWithLogId>();
                children.addAll(ManagedChannelImpl2.this.subchannels);
                children.addAll(ManagedChannelImpl2.this.oobChannels);
                builder.setSubchannels(children);
                ret.set((Object)builder.build());
            }
        }
        this.syncContext.execute(new StatsFetcher());
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    private void shutdownNameResolverAndLoadBalancer(boolean channelIsActive) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (channelIsActive) {
            Preconditions.checkState((boolean)this.nameResolverStarted, (Object)"nameResolver is not started");
            Preconditions.checkState((this.lbHelper != null ? 1 : 0) != 0, (Object)"lbHelper is null");
        }
        if (this.nameResolver != null) {
            this.cancelNameResolverBackoff();
            this.nameResolver.shutdown();
            this.nameResolverStarted = false;
            this.nameResolver = channelIsActive ? ManagedChannelImpl2.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverArgs) : null;
        }
        if (this.lbHelper != null) {
            this.lbHelper.lb.shutdown();
            this.lbHelper = null;
        }
        this.subchannelPicker = null;
    }

    @VisibleForTesting
    void exitIdleMode() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.shutdown.get() || this.panicMode) {
            return;
        }
        if (this.inUseStateAggregator.isInUse()) {
            this.cancelIdleTimer(false);
        } else {
            this.rescheduleIdleTimer();
        }
        if (this.lbHelper != null) {
            return;
        }
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Exiting idle mode");
        LbHelperImpl lbHelper = new LbHelperImpl();
        lbHelper.lb = this.loadBalancerFactory.newLoadBalancer(lbHelper);
        this.lbHelper = lbHelper;
        NameResolverListener listener = new NameResolverListener(lbHelper, this.nameResolver);
        this.nameResolver.start(listener);
        this.nameResolverStarted = true;
    }

    private void enterIdleMode() {
        this.shutdownNameResolverAndLoadBalancer(true);
        this.delayedTransport.reprocess(null);
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering IDLE state");
        this.channelStateManager.gotoState(ConnectivityState.IDLE);
        if (this.inUseStateAggregator.isInUse()) {
            this.exitIdleMode();
        }
    }

    private void cancelIdleTimer(boolean permanent) {
        this.idleTimer.cancel(permanent);
    }

    private void rescheduleIdleTimer() {
        if (this.idleTimeoutMillis == -1L) {
            return;
        }
        this.idleTimer.reschedule(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelNameResolverBackoff() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.scheduledNameResolverRefresh != null) {
            this.scheduledNameResolverRefresh.cancel();
            this.scheduledNameResolverRefresh = null;
            this.nameResolverBackoffPolicy = null;
        }
    }

    private void refreshAndResetNameResolution() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cancelNameResolverBackoff();
        this.refreshNameResolution();
    }

    private void refreshNameResolution() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.nameResolverStarted) {
            this.nameResolver.refresh();
        }
    }

    ManagedChannelImpl2(AbstractManagedChannelImplBuilder<?> builder, ClientTransportFactory clientTransportFactory, BackoffPolicy.Provider backoffPolicyProvider, ObjectPool<? extends Executor> balancerRpcExecutorPool, Supplier<Stopwatch> stopwatchSupplier, List<ClientInterceptor> interceptors, final TimeProvider timeProvider) {
        this.target = (String)Preconditions.checkNotNull((Object)builder.target, (Object)"target");
        this.logId = InternalLogId.allocate("Channel", this.target);
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)timeProvider, (Object)"timeProvider");
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(builder.executorPool, (Object)"executorPool");
        this.executor = (Executor)Preconditions.checkNotNull((Object)this.executorPool.getObject(), (Object)"executor");
        this.transportFactory = new CallCredentialsApplyingTransportFactory(clientTransportFactory, this.executor);
        this.scheduledExecutor = new RestrictedScheduledExecutor(this.transportFactory.getScheduledExecutorService());
        this.maxTraceEvents = builder.maxTraceEvents;
        this.channelTracer = new ChannelTracer(this.logId, builder.maxTraceEvents, timeProvider.currentTimeNanos(), "Channel for '" + this.target + "'");
        this.channelLogger = new ChannelLoggerImpl(this.channelTracer, timeProvider);
        this.nameResolverFactory = builder.getNameResolverFactory();
        ProxyDetector proxyDetector = builder.proxyDetector != null ? builder.proxyDetector : GrpcUtil.DEFAULT_PROXY_DETECTOR;
        this.retryEnabled = builder.retryEnabled && !builder.temporarilyDisableRetry;
        this.loadBalancerFactory = new AutoConfiguredLoadBalancerFactory2(builder.defaultLbPolicy);
        this.offloadExecutorHolder = new ExecutorHolder((ObjectPool)Preconditions.checkNotNull(builder.offloadExecutorPool, (Object)"offloadExecutorPool"));
        this.nameResolverRegistry = builder.nameResolverRegistry;
        ScParser serviceConfigParser = new ScParser(this.retryEnabled, builder.maxRetryAttempts, builder.maxHedgedAttempts, this.loadBalancerFactory, this.channelLogger);
        this.nameResolverArgs = NameResolver.Args.newBuilder().setDefaultPort(builder.getDefaultPort()).setProxyDetector(proxyDetector).setSynchronizationContext(this.syncContext).setScheduledExecutorService(this.scheduledExecutor).setServiceConfigParser(serviceConfigParser).setChannelLogger(this.channelLogger).setOffloadExecutor(new Executor(){

            @Override
            public void execute(Runnable command) {
                ManagedChannelImpl2.this.offloadExecutorHolder.getExecutor().execute(command);
            }
        }).build();
        this.nameResolver = ManagedChannelImpl2.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverArgs);
        this.balancerRpcExecutorPool = (ObjectPool)Preconditions.checkNotNull(balancerRpcExecutorPool, (Object)"balancerRpcExecutorPool");
        this.balancerRpcExecutorHolder = new ExecutorHolder(balancerRpcExecutorPool);
        this.delayedTransport = new DelayedClientTransport(this.executor, this.syncContext);
        this.delayedTransport.start(this.delayedTransportListener);
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.serviceConfigInterceptor = new ServiceConfigInterceptor2(this.retryEnabled);
        if (builder.defaultServiceConfig != null) {
            NameResolver.ConfigOrError parsedDefaultServiceConfig = serviceConfigParser.parseServiceConfig(builder.defaultServiceConfig);
            Preconditions.checkState((parsedDefaultServiceConfig.getError() == null ? 1 : 0) != 0, (String)"Default config is invalid: %s", (Object)parsedDefaultServiceConfig.getError());
            this.lastServiceConfig = this.defaultServiceConfig = new ServiceConfigHolder(builder.defaultServiceConfig, (ManagedChannelServiceConfig2)parsedDefaultServiceConfig.getConfig());
        } else {
            this.defaultServiceConfig = null;
        }
        this.lookUpServiceConfig = builder.lookUpServiceConfig;
        Channel channel = new RealChannel(this.nameResolver.getServiceAuthority());
        channel = ClientInterceptors.intercept(channel, this.serviceConfigInterceptor);
        if (builder.binlog != null) {
            channel = builder.binlog.wrapChannel(channel);
        }
        this.interceptorChannel = ClientInterceptors.intercept(channel, interceptors);
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        if (builder.idleTimeoutMillis == -1L) {
            this.idleTimeoutMillis = builder.idleTimeoutMillis;
        } else {
            Preconditions.checkArgument((builder.idleTimeoutMillis >= AbstractManagedChannelImplBuilder.IDLE_MODE_MIN_TIMEOUT_MILLIS ? 1 : 0) != 0, (String)"invalid idleTimeoutMillis %s", (long)builder.idleTimeoutMillis);
            this.idleTimeoutMillis = builder.idleTimeoutMillis;
        }
        this.idleTimer = new Rescheduler(new IdleModeTimer(), this.syncContext, this.transportFactory.getScheduledExecutorService(), (Stopwatch)stopwatchSupplier.get());
        this.fullStreamDecompression = builder.fullStreamDecompression;
        this.decompressorRegistry = (DecompressorRegistry)Preconditions.checkNotNull((Object)builder.decompressorRegistry, (Object)"decompressorRegistry");
        this.compressorRegistry = (CompressorRegistry)Preconditions.checkNotNull((Object)builder.compressorRegistry, (Object)"compressorRegistry");
        this.userAgent = builder.userAgent;
        this.channelBufferLimit = builder.retryBufferSize;
        this.perRpcBufferLimit = builder.perRpcBufferLimit;
        final class ChannelCallTracerFactory
        implements CallTracer.Factory {
            ChannelCallTracerFactory() {
            }

            @Override
            public CallTracer create() {
                return new CallTracer(timeProvider);
            }
        }
        this.callTracerFactory = new ChannelCallTracerFactory();
        this.channelCallTracer = this.callTracerFactory.create();
        this.channelz = (InternalChannelz)Preconditions.checkNotNull((Object)builder.channelz);
        this.channelz.addRootChannel(this);
        if (!this.lookUpServiceConfig) {
            if (this.defaultServiceConfig != null) {
                this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config look-up disabled, using default service config");
            }
            this.handleServiceConfigUpdate();
        }
    }

    private void handleServiceConfigUpdate() {
        this.serviceConfigUpdated = true;
        this.serviceConfigInterceptor.handleUpdate(this.lastServiceConfig.managedChannelServiceConfig);
    }

    @VisibleForTesting
    static NameResolver getNameResolver(String target, NameResolver.Factory nameResolverFactory, NameResolver.Args nameResolverArgs) {
        NameResolver resolver;
        URI targetUri = null;
        StringBuilder uriSyntaxErrors = new StringBuilder();
        try {
            targetUri = new URI(target);
        }
        catch (URISyntaxException e) {
            uriSyntaxErrors.append(e.getMessage());
        }
        if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverArgs)) != null) {
            return resolver;
        }
        if (!URI_PATTERN.matcher(target).matches()) {
            try {
                targetUri = new URI(nameResolverFactory.getDefaultScheme(), "", "/" + target, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverArgs);
            if (resolver != null) {
                return resolver;
            }
        }
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", target, uriSyntaxErrors.length() > 0 ? " (" + uriSyntaxErrors + ")" : ""));
    }

    @Override
    public ManagedChannelImpl2 shutdown() {
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "shutdown() called");
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        final class Shutdown
        implements Runnable {
            Shutdown() {
            }

            @Override
            public void run() {
                ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering SHUTDOWN state");
                ManagedChannelImpl2.this.channelStateManager.gotoState(ConnectivityState.SHUTDOWN);
            }
        }
        this.syncContext.executeLater(new Shutdown());
        this.uncommittedRetriableStreamsRegistry.onShutdown(SHUTDOWN_STATUS);
        final class CancelIdleTimer
        implements Runnable {
            CancelIdleTimer() {
            }

            @Override
            public void run() {
                ManagedChannelImpl2.this.cancelIdleTimer(true);
            }
        }
        this.syncContext.execute(new CancelIdleTimer());
        return this;
    }

    @Override
    public ManagedChannelImpl2 shutdownNow() {
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "shutdownNow() called");
        this.shutdown();
        this.uncommittedRetriableStreamsRegistry.onShutdownNow(SHUTDOWN_NOW_STATUS);
        final class ShutdownNow
        implements Runnable {
            ShutdownNow() {
            }

            @Override
            public void run() {
                if (ManagedChannelImpl2.this.shutdownNowed) {
                    return;
                }
                ManagedChannelImpl2.this.shutdownNowed = true;
                ManagedChannelImpl2.this.maybeShutdownNowSubchannels();
            }
        }
        this.syncContext.execute(new ShutdownNow());
        return this;
    }

    @VisibleForTesting
    void panic(final Throwable t) {
        if (this.panicMode) {
            return;
        }
        this.panicMode = true;
        this.cancelIdleTimer(true);
        this.shutdownNameResolverAndLoadBalancer(false);
        final class PanicSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            private final LoadBalancer.PickResult panicPickResult;

            PanicSubchannelPicker() {
                this.panicPickResult = LoadBalancer.PickResult.withDrop(Status.INTERNAL.withDescription("Panic! This is a bug!").withCause(t));
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return this.panicPickResult;
            }
        }
        this.updateSubchannelPicker(new PanicSubchannelPicker());
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "PANIC! Entering TRANSIENT_FAILURE");
        this.channelStateManager.gotoState(ConnectivityState.TRANSIENT_FAILURE);
    }

    @VisibleForTesting
    boolean isInPanicMode() {
        return this.panicMode;
    }

    private void updateSubchannelPicker(LoadBalancer.SubchannelPicker newPicker) {
        this.subchannelPicker = newPicker;
        this.delayedTransport.reprocess(newPicker);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminatedLatch.await(timeout, unit);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        return this.interceptorChannel.newCall(method, callOptions);
    }

    @Override
    public String authority() {
        return this.interceptorChannel.authority();
    }

    private Executor getCallExecutor(CallOptions callOptions) {
        Executor executor = callOptions.getExecutor();
        if (executor == null) {
            executor = this.executor;
        }
        return executor;
    }

    private void maybeTerminateChannel() {
        if (this.terminated) {
            return;
        }
        if (this.shutdown.get() && this.subchannels.isEmpty() && this.oobChannels.isEmpty()) {
            this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Terminated");
            this.channelz.removeRootChannel(this);
            this.executorPool.returnObject(this.executor);
            this.balancerRpcExecutorHolder.release();
            this.offloadExecutorHolder.release();
            this.transportFactory.close();
            this.terminated = true;
            this.terminatedLatch.countDown();
        }
    }

    private void handleInternalSubchannelState(ConnectivityStateInfo newState) {
        if (newState.getState() == ConnectivityState.TRANSIENT_FAILURE || newState.getState() == ConnectivityState.IDLE) {
            this.refreshAndResetNameResolution();
        }
    }

    @Override
    public ConnectivityState getState(boolean requestConnection) {
        ConnectivityState savedChannelState = this.channelStateManager.getState();
        if (requestConnection && savedChannelState == ConnectivityState.IDLE) {
            final class RequestConnection
            implements Runnable {
                RequestConnection() {
                }

                @Override
                public void run() {
                    ManagedChannelImpl2.this.exitIdleMode();
                    if (ManagedChannelImpl2.this.subchannelPicker != null) {
                        ManagedChannelImpl2.this.subchannelPicker.requestConnection();
                    }
                    if (ManagedChannelImpl2.this.lbHelper != null) {
                        ((ManagedChannelImpl2)ManagedChannelImpl2.this).lbHelper.lb.requestConnection();
                    }
                }
            }
            this.syncContext.execute(new RequestConnection());
        }
        return savedChannelState;
    }

    @Override
    public void notifyWhenStateChanged(final ConnectivityState source, final Runnable callback) {
        final class NotifyStateChanged
        implements Runnable {
            NotifyStateChanged() {
            }

            @Override
            public void run() {
                ManagedChannelImpl2.this.channelStateManager.notifyWhenStateChanged(callback, ManagedChannelImpl2.this.executor, source);
            }
        }
        this.syncContext.execute(new NotifyStateChanged());
    }

    @Override
    public void resetConnectBackoff() {
        final class ResetConnectBackoff
        implements Runnable {
            ResetConnectBackoff() {
            }

            @Override
            public void run() {
                if (ManagedChannelImpl2.this.shutdown.get()) {
                    return;
                }
                if (ManagedChannelImpl2.this.scheduledNameResolverRefresh != null && ManagedChannelImpl2.this.scheduledNameResolverRefresh.isPending()) {
                    Preconditions.checkState((boolean)ManagedChannelImpl2.this.nameResolverStarted, (Object)"name resolver must be started");
                    ManagedChannelImpl2.this.refreshAndResetNameResolution();
                }
                for (InternalSubchannel subchannel : ManagedChannelImpl2.this.subchannels) {
                    subchannel.resetConnectBackoff();
                }
                for (OobChannel oobChannel : ManagedChannelImpl2.this.oobChannels) {
                    oobChannel.resetConnectBackoff();
                }
            }
        }
        this.syncContext.execute(new ResetConnectBackoff());
    }

    @Override
    public void enterIdle() {
        final class PrepareToLoseNetworkRunnable
        implements Runnable {
            PrepareToLoseNetworkRunnable() {
            }

            @Override
            public void run() {
                if (ManagedChannelImpl2.this.shutdown.get() || ManagedChannelImpl2.this.lbHelper == null) {
                    return;
                }
                ManagedChannelImpl2.this.cancelIdleTimer(false);
                ManagedChannelImpl2.this.enterIdleMode();
            }
        }
        this.syncContext.execute(new PrepareToLoseNetworkRunnable());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logId", this.logId.getId()).add("target", (Object)this.target).toString();
    }

    private void logWarningIfNotInSyncContext(String method) {
        try {
            this.syncContext.throwIfNotInThisSynchronizationContext();
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, method + " should be called from SynchronizationContext. This warning will become an exception in a future release. See https://github.com/grpc/grpc-java/issues/5015 for more details", e);
        }
    }

    private static final class ServiceConfigHolder {
        Map<String, ?> rawServiceConfig;
        ManagedChannelServiceConfig2 managedChannelServiceConfig;

        ServiceConfigHolder(Map<String, ?> rawServiceConfig, ManagedChannelServiceConfig2 managedChannelServiceConfig) {
            this.rawServiceConfig = (Map)Preconditions.checkNotNull(rawServiceConfig, (Object)"rawServiceConfig");
            this.managedChannelServiceConfig = (ManagedChannelServiceConfig2)Preconditions.checkNotNull((Object)managedChannelServiceConfig, (Object)"managedChannelServiceConfig");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceConfigHolder that = (ServiceConfigHolder)o;
            return Objects.equal(this.rawServiceConfig, that.rawServiceConfig) && Objects.equal((Object)this.managedChannelServiceConfig, (Object)that.managedChannelServiceConfig);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.rawServiceConfig, this.managedChannelServiceConfig});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("rawServiceConfig", this.rawServiceConfig).add("managedChannelServiceConfig", (Object)this.managedChannelServiceConfig).toString();
        }
    }

    static enum ResolutionState {
        NO_RESOLUTION,
        SUCCESS,
        ERROR;

    }

    @VisibleForTesting
    static final class ScParser
    extends NameResolver.ServiceConfigParser {
        private final boolean retryEnabled;
        private final int maxRetryAttemptsLimit;
        private final int maxHedgedAttemptsLimit;
        private final AutoConfiguredLoadBalancerFactory2 autoLoadBalancerFactory;
        private final ChannelLogger channelLogger;

        ScParser(boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit, AutoConfiguredLoadBalancerFactory2 autoLoadBalancerFactory, ChannelLogger channelLogger) {
            this.retryEnabled = retryEnabled;
            this.maxRetryAttemptsLimit = maxRetryAttemptsLimit;
            this.maxHedgedAttemptsLimit = maxHedgedAttemptsLimit;
            this.autoLoadBalancerFactory = (AutoConfiguredLoadBalancerFactory2)Preconditions.checkNotNull((Object)autoLoadBalancerFactory, (Object)"autoLoadBalancerFactory");
            this.channelLogger = (ChannelLogger)Preconditions.checkNotNull((Object)channelLogger, (Object)"channelLogger");
        }

        @Override
        public NameResolver.ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
            try {
                Object loadBalancingPolicySelection;
                NameResolver.ConfigOrError choiceFromLoadBalancer = this.autoLoadBalancerFactory.parseLoadBalancerPolicy(rawServiceConfig, this.channelLogger);
                if (choiceFromLoadBalancer == null) {
                    loadBalancingPolicySelection = null;
                } else {
                    if (choiceFromLoadBalancer.getError() != null) {
                        return NameResolver.ConfigOrError.fromError(choiceFromLoadBalancer.getError());
                    }
                    loadBalancingPolicySelection = choiceFromLoadBalancer.getConfig();
                }
                return NameResolver.ConfigOrError.fromConfig(ManagedChannelServiceConfig2.fromServiceConfig(rawServiceConfig, this.retryEnabled, this.maxRetryAttemptsLimit, this.maxHedgedAttemptsLimit, loadBalancingPolicySelection));
            }
            catch (RuntimeException e) {
                return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("failed to parse service config").withCause(e));
            }
        }
    }

    private static final class RestrictedScheduledExecutor
    implements ScheduledExecutorService {
        final ScheduledExecutorService delegate;

        private RestrictedScheduledExecutor(ScheduledExecutorService delegate) {
            this.delegate = (ScheduledExecutorService)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable cmd, long delay, TimeUnit unit) {
            return this.delegate.schedule(cmd, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException("Restricted: shutdown() is not allowed");
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("Restricted: shutdownNow() is not allowed");
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.delegate.submit(task, result);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }

    private static final class ExecutorHolder {
        private final ObjectPool<? extends Executor> pool;
        private Executor executor;

        ExecutorHolder(ObjectPool<? extends Executor> executorPool) {
            this.pool = (ObjectPool)Preconditions.checkNotNull(executorPool, (Object)"executorPool");
        }

        synchronized Executor getExecutor() {
            if (this.executor == null) {
                this.executor = (Executor)Preconditions.checkNotNull((Object)this.pool.getObject(), (String)"%s.getObject()", (Object)this.executor);
            }
            return this.executor;
        }

        synchronized void release() {
            if (this.executor != null) {
                this.executor = this.pool.returnObject(this.executor);
            }
        }
    }

    private final class IdleModeStateAggregator
    extends InUseStateAggregator<Object> {
        private IdleModeStateAggregator() {
        }

        @Override
        protected void handleInUse() {
            ManagedChannelImpl2.this.exitIdleMode();
        }

        @Override
        protected void handleNotInUse() {
            if (ManagedChannelImpl2.this.shutdown.get()) {
                return;
            }
            ManagedChannelImpl2.this.rescheduleIdleTimer();
        }
    }

    private final class DelayedTransportListener
    implements ManagedClientTransport.Listener {
        private DelayedTransportListener() {
        }

        @Override
        public void transportShutdown(Status s) {
            Preconditions.checkState((boolean)ManagedChannelImpl2.this.shutdown.get(), (Object)"Channel must have been shut down");
        }

        @Override
        public void transportReady() {
        }

        @Override
        public void transportInUse(boolean inUse) {
            ManagedChannelImpl2.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl2.this.delayedTransport, inUse);
        }

        @Override
        public void transportTerminated() {
            Preconditions.checkState((boolean)ManagedChannelImpl2.this.shutdown.get(), (Object)"Channel must have been shut down");
            ManagedChannelImpl2.this.terminating = true;
            ManagedChannelImpl2.this.shutdownNameResolverAndLoadBalancer(false);
            ManagedChannelImpl2.this.maybeShutdownNowSubchannels();
            ManagedChannelImpl2.this.maybeTerminateChannel();
        }
    }

    private final class SubchannelImpl
    extends AbstractSubchannel {
        final LoadBalancer.CreateSubchannelArgs args;
        final LbHelperImpl helper;
        final InternalLogId subchannelLogId;
        final ChannelLoggerImpl subchannelLogger;
        final ChannelTracer subchannelTracer;
        LoadBalancer.SubchannelStateListener listener;
        InternalSubchannel subchannel;
        boolean started;
        boolean shutdown;
        SynchronizationContext.ScheduledHandle delayedShutdownTask;

        SubchannelImpl(LoadBalancer.CreateSubchannelArgs args, LbHelperImpl helper) {
            this.args = (LoadBalancer.CreateSubchannelArgs)Preconditions.checkNotNull((Object)args, (Object)"args");
            this.helper = (LbHelperImpl)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            this.subchannelLogId = InternalLogId.allocate("Subchannel", ManagedChannelImpl2.this.authority());
            this.subchannelTracer = new ChannelTracer(this.subchannelLogId, ManagedChannelImpl2.this.maxTraceEvents, ManagedChannelImpl2.this.timeProvider.currentTimeNanos(), "Subchannel for " + args.getAddresses());
            this.subchannelLogger = new ChannelLoggerImpl(this.subchannelTracer, ManagedChannelImpl2.this.timeProvider);
        }

        private void internalStart(final LoadBalancer.SubchannelStateListener listener) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"already shutdown");
            this.started = true;
            this.listener = listener;
            if (ManagedChannelImpl2.this.terminating) {
                ManagedChannelImpl2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onSubchannelState(ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN));
                    }
                });
                return;
            }
            final class ManagedInternalSubchannelCallback
            extends InternalSubchannel.Callback {
                ManagedInternalSubchannelCallback() {
                }

                @Override
                void onTerminated(InternalSubchannel is) {
                    ManagedChannelImpl2.this.subchannels.remove(is);
                    ManagedChannelImpl2.this.channelz.removeSubchannel(is);
                    ManagedChannelImpl2.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
                    ManagedChannelImpl2.this.handleInternalSubchannelState(newState);
                    Preconditions.checkState((listener != null ? 1 : 0) != 0, (Object)"listener is null");
                    listener.onSubchannelState(newState);
                }

                @Override
                void onInUse(InternalSubchannel is) {
                    ManagedChannelImpl2.this.inUseStateAggregator.updateObjectInUse(is, true);
                }

                @Override
                void onNotInUse(InternalSubchannel is) {
                    ManagedChannelImpl2.this.inUseStateAggregator.updateObjectInUse(is, false);
                }
            }
            final InternalSubchannel internalSubchannel = new InternalSubchannel(this.args.getAddresses(), ManagedChannelImpl2.this.authority(), ManagedChannelImpl2.this.userAgent, ManagedChannelImpl2.this.backoffPolicyProvider, ManagedChannelImpl2.this.transportFactory, ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService(), (Supplier<Stopwatch>)ManagedChannelImpl2.this.stopwatchSupplier, ManagedChannelImpl2.this.syncContext, new ManagedInternalSubchannelCallback(), ManagedChannelImpl2.this.channelz, ManagedChannelImpl2.this.callTracerFactory.create(), this.subchannelTracer, this.subchannelLogId, this.subchannelLogger);
            ManagedChannelImpl2.this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child Subchannel started").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(ManagedChannelImpl2.this.timeProvider.currentTimeNanos()).setSubchannelRef(internalSubchannel).build());
            this.subchannel = internalSubchannel;
            ManagedChannelImpl2.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    ManagedChannelImpl2.this.channelz.addSubchannel(internalSubchannel);
                    ManagedChannelImpl2.this.subchannels.add(internalSubchannel);
                }
            });
        }

        @Override
        public void start(LoadBalancer.SubchannelStateListener listener) {
            ManagedChannelImpl2.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.internalStart(listener);
        }

        @Override
        InternalInstrumented<InternalChannelz.ChannelStats> getInstrumentedInternalSubchannel() {
            Preconditions.checkState((boolean)this.started, (Object)"not started");
            return this.subchannel;
        }

        @Override
        public void shutdown() {
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("Subchannel.shutdown()");
            ManagedChannelImpl2.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    SubchannelImpl.this.internalShutdown();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void internalShutdown() {
            ManagedChannelImpl2.this.syncContext.throwIfNotInThisSynchronizationContext();
            if (this.subchannel == null) {
                this.shutdown = true;
                return;
            }
            if (this.shutdown) {
                if (!ManagedChannelImpl2.this.terminating || this.delayedShutdownTask == null) return;
                this.delayedShutdownTask.cancel();
                this.delayedShutdownTask = null;
            } else {
                this.shutdown = true;
            }
            if (!ManagedChannelImpl2.this.terminating) {
                final class ShutdownSubchannel
                implements Runnable {
                    ShutdownSubchannel() {
                    }

                    @Override
                    public void run() {
                        SubchannelImpl.this.subchannel.shutdown(SUBCHANNEL_SHUTDOWN_STATUS);
                    }
                }
                this.delayedShutdownTask = ManagedChannelImpl2.this.syncContext.schedule(new LogExceptionRunnable(new ShutdownSubchannel()), 5L, TimeUnit.SECONDS, ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService());
                return;
            }
            this.subchannel.shutdown(SHUTDOWN_STATUS);
        }

        @Override
        public void requestConnection() {
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("Subchannel.requestConnection()");
            Preconditions.checkState((boolean)this.started, (Object)"not started");
            this.subchannel.obtainActiveTransport();
        }

        @Override
        public List<EquivalentAddressGroup> getAllAddresses() {
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("Subchannel.getAllAddresses()");
            Preconditions.checkState((boolean)this.started, (Object)"not started");
            return this.subchannel.getAddressGroups();
        }

        @Override
        public Attributes getAttributes() {
            return this.args.getAttributes();
        }

        public String toString() {
            return this.subchannelLogId.toString();
        }

        @Override
        public Channel asChannel() {
            Preconditions.checkState((boolean)this.started, (Object)"not started");
            return new SubchannelChannel(this.subchannel, ManagedChannelImpl2.this.balancerRpcExecutorHolder.getExecutor(), ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl2.this.callTracerFactory.create());
        }

        @Override
        public Object getInternalSubchannel() {
            Preconditions.checkState((boolean)this.started, (Object)"Subchannel is not started");
            return this.subchannel;
        }

        @Override
        public ChannelLogger getChannelLogger() {
            return this.subchannelLogger;
        }

        @Override
        public void updateAddresses(List<EquivalentAddressGroup> addrs) {
            ManagedChannelImpl2.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.subchannel.updateAddresses(addrs);
        }
    }

    private final class NameResolverListener
    extends NameResolver.Listener2 {
        final LbHelperImpl helper;
        final NameResolver resolver;

        NameResolverListener(LbHelperImpl helperImpl, NameResolver resolver) {
            this.helper = (LbHelperImpl)Preconditions.checkNotNull((Object)helperImpl, (Object)"helperImpl");
            this.resolver = (NameResolver)Preconditions.checkNotNull((Object)resolver, (Object)"resolver");
        }

        @Override
        public void onResult(final NameResolver.ResolutionResult resolutionResult) {
            final class NamesResolved
            implements Runnable {
                NamesResolved() {
                }

                @Override
                public void run() {
                    ServiceConfigHolder effectiveServiceConfig;
                    List<EquivalentAddressGroup> servers = resolutionResult.getAddresses();
                    Attributes attrs = resolutionResult.getAttributes();
                    ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Resolved address: {0}, config={1}", servers, attrs);
                    ResolutionState lastResolutionStateCopy = ManagedChannelImpl2.this.lastResolutionState;
                    if (ManagedChannelImpl2.this.lastResolutionState != ResolutionState.SUCCESS) {
                        ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Address resolved: {0}", servers);
                        ManagedChannelImpl2.this.lastResolutionState = ResolutionState.SUCCESS;
                    }
                    ManagedChannelImpl2.this.nameResolverBackoffPolicy = null;
                    NameResolver.ConfigOrError configOrError = resolutionResult.getServiceConfig();
                    ServiceConfigHolder validServiceConfig = null;
                    Status serviceConfigError = null;
                    if (configOrError != null) {
                        Map<String, ?> rawServiceConfig = resolutionResult.getAttributes().get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
                        validServiceConfig = configOrError.getConfig() == null ? null : new ServiceConfigHolder(rawServiceConfig, (ManagedChannelServiceConfig2)configOrError.getConfig());
                        serviceConfigError = configOrError.getError();
                    }
                    if (!ManagedChannelImpl2.this.lookUpServiceConfig) {
                        if (validServiceConfig != null) {
                            ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config from name resolver discarded by channel settings");
                        }
                        effectiveServiceConfig = ManagedChannelImpl2.this.defaultServiceConfig == null ? EMPTY_SERVICE_CONFIG : ManagedChannelImpl2.this.defaultServiceConfig;
                        attrs = attrs.toBuilder().discard(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG).build();
                    } else {
                        if (validServiceConfig != null) {
                            effectiveServiceConfig = validServiceConfig;
                        } else if (ManagedChannelImpl2.this.defaultServiceConfig != null) {
                            effectiveServiceConfig = ManagedChannelImpl2.this.defaultServiceConfig;
                            ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Received no service config, using default service config");
                        } else if (serviceConfigError != null) {
                            if (!ManagedChannelImpl2.this.serviceConfigUpdated) {
                                ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Fallback to error due to invalid first service config without default config");
                                NameResolverListener.this.onError(configOrError.getError());
                                return;
                            }
                            effectiveServiceConfig = ManagedChannelImpl2.this.lastServiceConfig;
                        } else {
                            effectiveServiceConfig = EMPTY_SERVICE_CONFIG;
                        }
                        if (!effectiveServiceConfig.equals(ManagedChannelImpl2.this.lastServiceConfig)) {
                            ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config changed{0}", effectiveServiceConfig == EMPTY_SERVICE_CONFIG ? " to empty" : "");
                            ManagedChannelImpl2.this.lastServiceConfig = effectiveServiceConfig;
                        }
                        try {
                            ManagedChannelImpl2.this.handleServiceConfigUpdate();
                        }
                        catch (RuntimeException re) {
                            logger.log(Level.WARNING, "[" + ManagedChannelImpl2.this.getLogId() + "] Unexpected exception from parsing service config", re);
                        }
                    }
                    if (NameResolverListener.this.helper == ManagedChannelImpl2.this.lbHelper) {
                        Status handleResult;
                        Attributes effectiveAttrs = attrs;
                        if (effectiveServiceConfig != validServiceConfig) {
                            effectiveAttrs = attrs.toBuilder().set(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG, effectiveServiceConfig.rawServiceConfig).build();
                        }
                        if (!(handleResult = NameResolverListener.this.helper.lb.tryHandleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(servers).setAttributes(effectiveAttrs).setLoadBalancingPolicyConfig(effectiveServiceConfig.managedChannelServiceConfig.getLoadBalancingConfig()).build())).isOk()) {
                            if (servers.isEmpty() && lastResolutionStateCopy == ResolutionState.SUCCESS) {
                                NameResolverListener.this.scheduleExponentialBackOffInSyncContext();
                            } else {
                                NameResolverListener.this.handleErrorInSyncContext(handleResult.augmentDescription(NameResolverListener.this.resolver + " was used"));
                            }
                        }
                    }
                }
            }
            ManagedChannelImpl2.this.syncContext.execute(new NamesResolved());
        }

        @Override
        public void onError(final Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"the error status must not be OK");
            final class NameResolverErrorHandler
            implements Runnable {
                NameResolverErrorHandler() {
                }

                @Override
                public void run() {
                    NameResolverListener.this.handleErrorInSyncContext(error);
                }
            }
            ManagedChannelImpl2.this.syncContext.execute(new NameResolverErrorHandler());
        }

        private void handleErrorInSyncContext(Status error) {
            logger.log(Level.WARNING, "[{0}] Failed to resolve name. status={1}", new Object[]{ManagedChannelImpl2.this.getLogId(), error});
            if (ManagedChannelImpl2.this.lastResolutionState != ResolutionState.ERROR) {
                ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.WARNING, "Failed to resolve name: {0}", error);
                ManagedChannelImpl2.this.lastResolutionState = ResolutionState.ERROR;
            }
            if (this.helper != ManagedChannelImpl2.this.lbHelper) {
                return;
            }
            this.helper.lb.handleNameResolutionError(error);
            this.scheduleExponentialBackOffInSyncContext();
        }

        private void scheduleExponentialBackOffInSyncContext() {
            if (ManagedChannelImpl2.this.scheduledNameResolverRefresh != null && ManagedChannelImpl2.this.scheduledNameResolverRefresh.isPending()) {
                return;
            }
            if (ManagedChannelImpl2.this.nameResolverBackoffPolicy == null) {
                ManagedChannelImpl2.this.nameResolverBackoffPolicy = ManagedChannelImpl2.this.backoffPolicyProvider.get();
            }
            long delayNanos = ManagedChannelImpl2.this.nameResolverBackoffPolicy.nextBackoffNanos();
            ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Scheduling DNS resolution backoff for {0} ns", delayNanos);
            ManagedChannelImpl2.this.scheduledNameResolverRefresh = ManagedChannelImpl2.this.syncContext.schedule(new DelayedNameResolverRefresh(), delayNanos, TimeUnit.NANOSECONDS, ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService());
        }
    }

    private class LbHelperImpl
    extends LoadBalancer.Helper {
        AutoConfiguredLoadBalancerFactory2.AutoConfiguredLoadBalancer lb;

        private LbHelperImpl() {
        }

        @Override
        @Deprecated
        public AbstractSubchannel createSubchannel(List<EquivalentAddressGroup> addressGroups, Attributes attrs) {
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("createSubchannel()");
            Preconditions.checkNotNull(addressGroups, (Object)"addressGroups");
            Preconditions.checkNotNull((Object)attrs, (Object)"attrs");
            final SubchannelImpl subchannel = this.createSubchannelInternal(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(addressGroups).setAttributes(attrs).build());
            LoadBalancer.SubchannelStateListener listener = new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (LbHelperImpl.this != ManagedChannelImpl2.this.lbHelper) {
                        return;
                    }
                    LbHelperImpl.this.lb.handleSubchannelState(subchannel, newState);
                }
            };
            subchannel.internalStart(listener);
            return subchannel;
        }

        @Override
        public AbstractSubchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            ManagedChannelImpl2.this.syncContext.throwIfNotInThisSynchronizationContext();
            return this.createSubchannelInternal(args);
        }

        private SubchannelImpl createSubchannelInternal(LoadBalancer.CreateSubchannelArgs args) {
            Preconditions.checkState((!ManagedChannelImpl2.this.terminated ? 1 : 0) != 0, (Object)"Channel is terminated");
            return new SubchannelImpl(args, this);
        }

        @Override
        public void updateBalancingState(final ConnectivityState newState, final LoadBalancer.SubchannelPicker newPicker) {
            Preconditions.checkNotNull((Object)((Object)newState), (Object)"newState");
            Preconditions.checkNotNull((Object)newPicker, (Object)"newPicker");
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("updateBalancingState()");
            final class UpdateBalancingState
            implements Runnable {
                UpdateBalancingState() {
                }

                @Override
                public void run() {
                    if (LbHelperImpl.this != ManagedChannelImpl2.this.lbHelper) {
                        return;
                    }
                    ManagedChannelImpl2.this.updateSubchannelPicker(newPicker);
                    if (newState != ConnectivityState.SHUTDOWN) {
                        ManagedChannelImpl2.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering {0} state", new Object[]{newState});
                        ManagedChannelImpl2.this.channelStateManager.gotoState(newState);
                    }
                }
            }
            ManagedChannelImpl2.this.syncContext.execute(new UpdateBalancingState());
        }

        @Override
        public void refreshNameResolution() {
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("refreshNameResolution()");
            final class LoadBalancerRefreshNameResolution
            implements Runnable {
                LoadBalancerRefreshNameResolution() {
                }

                @Override
                public void run() {
                    ManagedChannelImpl2.this.refreshAndResetNameResolution();
                }
            }
            ManagedChannelImpl2.this.syncContext.execute(new LoadBalancerRefreshNameResolution());
        }

        @Override
        @Deprecated
        public void updateSubchannelAddresses(LoadBalancer.Subchannel subchannel, List<EquivalentAddressGroup> addrs) {
            Preconditions.checkArgument((boolean)(subchannel instanceof SubchannelImpl), (Object)"subchannel must have been returned from createSubchannel");
            ManagedChannelImpl2.this.logWarningIfNotInSyncContext("updateSubchannelAddresses()");
            ((InternalSubchannel)subchannel.getInternalSubchannel()).updateAddresses(addrs);
        }

        @Override
        public ManagedChannel createOobChannel(EquivalentAddressGroup addressGroup, String authority) {
            Preconditions.checkState((!ManagedChannelImpl2.this.terminated ? 1 : 0) != 0, (Object)"Channel is terminated");
            long oobChannelCreationTime = ManagedChannelImpl2.this.timeProvider.currentTimeNanos();
            InternalLogId oobLogId = InternalLogId.allocate("OobChannel", null);
            InternalLogId subchannelLogId = InternalLogId.allocate("Subchannel-OOB", authority);
            ChannelTracer oobChannelTracer = new ChannelTracer(oobLogId, ManagedChannelImpl2.this.maxTraceEvents, oobChannelCreationTime, "OobChannel for " + addressGroup);
            final OobChannel oobChannel = new OobChannel(authority, ManagedChannelImpl2.this.balancerRpcExecutorPool, ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl2.this.syncContext, ManagedChannelImpl2.this.callTracerFactory.create(), oobChannelTracer, ManagedChannelImpl2.this.channelz, ManagedChannelImpl2.this.timeProvider);
            ManagedChannelImpl2.this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child OobChannel created").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(oobChannelCreationTime).setChannelRef(oobChannel).build());
            ChannelTracer subchannelTracer = new ChannelTracer(subchannelLogId, ManagedChannelImpl2.this.maxTraceEvents, oobChannelCreationTime, "Subchannel for " + addressGroup);
            ChannelLoggerImpl subchannelLogger = new ChannelLoggerImpl(subchannelTracer, ManagedChannelImpl2.this.timeProvider);
            final class ManagedOobChannelCallback
            extends InternalSubchannel.Callback {
                ManagedOobChannelCallback() {
                }

                @Override
                void onTerminated(InternalSubchannel is) {
                    ManagedChannelImpl2.this.oobChannels.remove(oobChannel);
                    ManagedChannelImpl2.this.channelz.removeSubchannel(is);
                    oobChannel.handleSubchannelTerminated();
                    ManagedChannelImpl2.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
                    ManagedChannelImpl2.this.handleInternalSubchannelState(newState);
                    oobChannel.handleSubchannelStateChange(newState);
                }
            }
            InternalSubchannel internalSubchannel = new InternalSubchannel(Collections.singletonList(addressGroup), authority, ManagedChannelImpl2.this.userAgent, ManagedChannelImpl2.this.backoffPolicyProvider, ManagedChannelImpl2.this.transportFactory, ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService(), (Supplier<Stopwatch>)ManagedChannelImpl2.this.stopwatchSupplier, ManagedChannelImpl2.this.syncContext, new ManagedOobChannelCallback(), ManagedChannelImpl2.this.channelz, ManagedChannelImpl2.this.callTracerFactory.create(), subchannelTracer, subchannelLogId, subchannelLogger);
            oobChannelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child Subchannel created").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(oobChannelCreationTime).setSubchannelRef(internalSubchannel).build());
            ManagedChannelImpl2.this.channelz.addSubchannel(oobChannel);
            ManagedChannelImpl2.this.channelz.addSubchannel(internalSubchannel);
            oobChannel.setSubchannel(internalSubchannel);
            final class AddOobChannel
            implements Runnable {
                AddOobChannel() {
                }

                @Override
                public void run() {
                    if (ManagedChannelImpl2.this.terminating) {
                        oobChannel.shutdown();
                    }
                    if (!ManagedChannelImpl2.this.terminated) {
                        ManagedChannelImpl2.this.oobChannels.add(oobChannel);
                    }
                }
            }
            ManagedChannelImpl2.this.syncContext.execute(new AddOobChannel());
            return oobChannel;
        }

        @Override
        public void updateOobChannelAddresses(ManagedChannel channel, EquivalentAddressGroup eag) {
            Preconditions.checkArgument((boolean)(channel instanceof OobChannel), (Object)"channel must have been returned from createOobChannel");
            ((OobChannel)channel).updateAddresses(eag);
        }

        @Override
        public String getAuthority() {
            return ManagedChannelImpl2.this.authority();
        }

        @Override
        @Deprecated
        public NameResolver.Factory getNameResolverFactory() {
            return ManagedChannelImpl2.this.nameResolverFactory;
        }

        @Override
        public SynchronizationContext getSynchronizationContext() {
            return ManagedChannelImpl2.this.syncContext;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return ManagedChannelImpl2.this.scheduledExecutor;
        }

        @Override
        public ChannelLogger getChannelLogger() {
            return ManagedChannelImpl2.this.channelLogger;
        }

        @Override
        public NameResolver.Args getNameResolverArgs() {
            return ManagedChannelImpl2.this.nameResolverArgs;
        }

        @Override
        public NameResolverRegistry getNameResolverRegistry() {
            return ManagedChannelImpl2.this.nameResolverRegistry;
        }
    }

    private final class UncommittedRetriableStreamsRegistry {
        final Object lock = new Object();
        @GuardedBy(value="lock")
        Collection<ClientStream> uncommittedRetriableStreams = new HashSet<ClientStream>();
        @GuardedBy(value="lock")
        Status shutdownStatus;

        private UncommittedRetriableStreamsRegistry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onShutdown(Status reason) {
            boolean shouldShutdownDelayedTransport = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStatus != null) {
                    return;
                }
                this.shutdownStatus = reason;
                if (this.uncommittedRetriableStreams.isEmpty()) {
                    shouldShutdownDelayedTransport = true;
                }
            }
            if (shouldShutdownDelayedTransport) {
                ManagedChannelImpl2.this.delayedTransport.shutdown(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onShutdownNow(Status reason) {
            ArrayList<ClientStream> streams;
            this.onShutdown(reason);
            Iterator iterator = this.lock;
            synchronized (iterator) {
                streams = new ArrayList<ClientStream>(this.uncommittedRetriableStreams);
            }
            for (ClientStream stream : streams) {
                stream.cancel(reason);
            }
            ManagedChannelImpl2.this.delayedTransport.shutdownNow(reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Status add(RetriableStream<?> retriableStream) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStatus != null) {
                    return this.shutdownStatus;
                }
                this.uncommittedRetriableStreams.add(retriableStream);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(RetriableStream<?> retriableStream) {
            Status shutdownStatusCopy = null;
            Object object = this.lock;
            synchronized (object) {
                this.uncommittedRetriableStreams.remove(retriableStream);
                if (this.uncommittedRetriableStreams.isEmpty()) {
                    shutdownStatusCopy = this.shutdownStatus;
                    this.uncommittedRetriableStreams = new HashSet<ClientStream>();
                }
            }
            if (shutdownStatusCopy != null) {
                ManagedChannelImpl2.this.delayedTransport.shutdown(shutdownStatusCopy);
            }
        }
    }

    private class RealChannel
    extends Channel {
        private final String authority;

        private RealChannel(String authority) {
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            return new ClientCallImpl<ReqT, RespT>(method, ManagedChannelImpl2.this.getCallExecutor(callOptions), callOptions, ManagedChannelImpl2.this.transportProvider, ManagedChannelImpl2.this.terminated ? null : ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl2.this.channelCallTracer, ManagedChannelImpl2.this.retryEnabled).setFullStreamDecompression(ManagedChannelImpl2.this.fullStreamDecompression).setDecompressorRegistry(ManagedChannelImpl2.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl2.this.compressorRegistry);
        }

        @Override
        public String authority() {
            return this.authority;
        }
    }

    private final class ChannelTransportProvider
    implements ClientCallImpl.ClientTransportProvider {
        private ChannelTransportProvider() {
        }

        @Override
        public ClientTransport get(LoadBalancer.PickSubchannelArgs args) {
            LoadBalancer.SubchannelPicker pickerCopy = ManagedChannelImpl2.this.subchannelPicker;
            if (ManagedChannelImpl2.this.shutdown.get()) {
                return ManagedChannelImpl2.this.delayedTransport;
            }
            if (pickerCopy == null) {
                final class ExitIdleModeForTransport
                implements Runnable {
                    ExitIdleModeForTransport() {
                    }

                    @Override
                    public void run() {
                        ManagedChannelImpl2.this.exitIdleMode();
                    }
                }
                ManagedChannelImpl2.this.syncContext.execute(new ExitIdleModeForTransport());
                return ManagedChannelImpl2.this.delayedTransport;
            }
            LoadBalancer.PickResult pickResult = pickerCopy.pickSubchannel(args);
            ClientTransport transport = GrpcUtil.getTransportFromPickResult(pickResult, args.getCallOptions().isWaitForReady());
            if (transport != null) {
                return transport;
            }
            return ManagedChannelImpl2.this.delayedTransport;
        }

        @Override
        public <ReqT> ClientStream newRetriableStream(final MethodDescriptor<ReqT, ?> method, final CallOptions callOptions, final Metadata headers, final Context context) {
            Preconditions.checkState((boolean)ManagedChannelImpl2.this.retryEnabled, (Object)"retry should be enabled");
            final RetriableStream.Throttle throttle = ((ManagedChannelImpl2)ManagedChannelImpl2.this).lastServiceConfig.managedChannelServiceConfig.getRetryThrottling();
            final class RetryStream
            extends RetriableStream<ReqT> {
                RetryStream() {
                    super(methodDescriptor, metadata, ManagedChannelImpl2.this.channelBufferUsed, ManagedChannelImpl2.this.perRpcBufferLimit, ManagedChannelImpl2.this.channelBufferLimit, ManagedChannelImpl2.this.getCallExecutor(callOptions2), ManagedChannelImpl2.this.transportFactory.getScheduledExecutorService(), callOptions2.getOption(ServiceConfigInterceptor2.RETRY_POLICY_KEY), callOptions2.getOption(ServiceConfigInterceptor2.HEDGING_POLICY_KEY), throttle2);
                }

                @Override
                Status prestart() {
                    return ManagedChannelImpl2.this.uncommittedRetriableStreamsRegistry.add(this);
                }

                @Override
                void postCommit() {
                    ManagedChannelImpl2.this.uncommittedRetriableStreamsRegistry.remove(this);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                ClientStream newSubstream(ClientStreamTracer.Factory tracerFactory, Metadata newHeaders) {
                    CallOptions newOptions = callOptions.withStreamTracerFactory(tracerFactory);
                    ClientTransport transport = ChannelTransportProvider.this.get(new PickSubchannelArgsImpl(method, newHeaders, newOptions));
                    Context origContext = context.attach();
                    try {
                        ClientStream clientStream = transport.newStream(method, newHeaders, newOptions);
                        return clientStream;
                    }
                    finally {
                        context.detach(origContext);
                    }
                }
            }
            return new RetryStream();
        }
    }

    @VisibleForTesting
    class DelayedNameResolverRefresh
    implements Runnable {
        DelayedNameResolverRefresh() {
        }

        @Override
        public void run() {
            ManagedChannelImpl2.this.scheduledNameResolverRefresh = null;
            ManagedChannelImpl2.this.refreshNameResolution();
        }
    }

    private class IdleModeTimer
    implements Runnable {
        private IdleModeTimer() {
        }

        @Override
        public void run() {
            ManagedChannelImpl2.this.enterIdleMode();
        }
    }
}

