/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.api;

import io.grpc.MethodDescriptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public interface Grpc {

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GrpcProxy {
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GrpcChannel {
        public String value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    public static @interface ResponseType {
        public Class<?> value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    public static @interface RequestType {
        public Class<?> value();
    }

    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    public static @interface GrpcMethod {
        public String name() default "";

        public MethodDescriptor.MethodType value();
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    public static @interface GrpcMarshaller {
        public static final String PROTO = "proto";
        public static final String DEFAULT = "default";

        public String value() default "default";
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GrpcInterceptors {
        public Class<?>[] value();
    }

    @Target(value={ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface GrpcInterceptorBinding {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface GrpcInterceptor {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GrpcMethod(value=MethodDescriptor.MethodType.SERVER_STREAMING)
    @Documented
    @Inherited
    public static @interface ServerStreaming {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GrpcMethod(value=MethodDescriptor.MethodType.CLIENT_STREAMING)
    @Documented
    @Inherited
    public static @interface ClientStreaming {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GrpcMethod(value=MethodDescriptor.MethodType.BIDI_STREAMING)
    @Documented
    @Inherited
    public static @interface Bidirectional {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GrpcMethod(value=MethodDescriptor.MethodType.UNARY)
    @Documented
    @Inherited
    public static @interface Unary {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    public static @interface Proto {
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.CONSTRUCTOR})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Documented
    public static @interface GrpcService {
        public String value() default "";

        public int version() default 0;
    }
}

