/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.graphql.server;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import graphql.validation.ValidationError;
import io.helidon.graphql.server.ExecutionContext;
import io.helidon.graphql.server.ExecutionContextImpl;
import io.helidon.graphql.server.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class InvocationHandlerImpl
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(InvocationHandlerImpl.class.getName());
    private final String defaultErrorMessage;
    private final Set<String> exceptionDenySet = new HashSet<String>();
    private final Set<String> exceptionAllowSet = new HashSet<String>();
    private final Map<Class<?>, Boolean> denyExceptions = new ConcurrentHashMap();
    private final Map<Class<?>, Boolean> allowExceptions = new ConcurrentHashMap();
    private final GraphQLSchema schema;
    private final GraphQL graphQl;
    private final SchemaPrinter schemaPrinter;

    InvocationHandlerImpl(InvocationHandler.Builder builder, GraphQL graphQl) {
        this.schema = builder.schema();
        this.schemaPrinter = builder.schemaPrinter();
        this.defaultErrorMessage = builder.defaultErrorMessage();
        this.graphQl = graphQl;
        this.exceptionDenySet.addAll(builder.denyExceptions());
        this.exceptionAllowSet.addAll(builder.allowExceptions());
    }

    @Override
    public Map<String, Object> execute(String query, String operationName, Map<String, Object> variables) {
        try {
            return this.doExecute(query, operationName, variables);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.FINE, "Failed to execute query " + query, e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            this.addError(result, e, e.getMessage());
            return result;
        }
    }

    private Map<String, Object> doExecute(String query, String operationName, Map<String, Object> variables) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).context((Object)context).variables(variables).build();
        ExecutionResult result = this.graphQl.execute(executionInput);
        List errors = result.getErrors();
        if (errors.isEmpty() && context.hasPartialResultsException()) {
            return this.processPartialResultsException(result, context);
        }
        if (errors.isEmpty()) {
            return result.toSpecification();
        }
        return this.processErrors(result, errors);
    }

    private Map<String, Object> processErrors(ExecutionResult result, List<GraphQLError> errors) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("data", result.getData());
        boolean hasErrors = false;
        for (GraphQLError error : errors) {
            if (error instanceof ExceptionWhileDataFetching) {
                ExceptionWhileDataFetching e = (ExceptionWhileDataFetching)error;
                Throwable cause = e.getException().getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                hasErrors = true;
                this.addError(resultMap, error, cause);
                continue;
            }
            if (!(error instanceof ValidationError)) continue;
            this.addError(resultMap, error);
            if (result.getData() == null) {
                resultMap.put("data", null);
            }
            hasErrors = true;
        }
        if (hasErrors) {
            return resultMap;
        }
        return result.toSpecification();
    }

    private Map<String, Object> processPartialResultsException(ExecutionResult result, ExecutionContext context) {
        Throwable cause = context.partialResultsException().getCause();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("data", result.getData());
        this.addError(resultMap, cause, context.partialResultsException().getMessage());
        return resultMap;
    }

    private void addError(Map<String, Object> resultMap, GraphQLError error, Throwable cause) {
        List listPath;
        int line = -1;
        int column = -1;
        String path = null;
        List locations = error.getLocations();
        if (locations != null && locations.size() > 0) {
            SourceLocation sourceLocation = (SourceLocation)locations.get(0);
            line = sourceLocation.getLine();
            column = sourceLocation.getColumn();
        }
        if ((listPath = error.getPath()) != null && listPath.size() > 0) {
            path = listPath.get(0).toString();
        }
        if (cause instanceof GraphQLException) {
            this.addErrorPayload(resultMap, this.getCheckedMessage(cause), path, line, column, error.getExtensions());
        } else if (cause instanceof Error || cause instanceof RuntimeException) {
            this.addErrorPayload(resultMap, this.getUncheckedMessage(cause), path, line, column, error.getExtensions());
        } else {
            this.addErrorPayload(resultMap, cause == null ? error.getMessage() : this.getCheckedMessage(cause), path, line, column, error.getExtensions());
        }
    }

    private void addError(Map<String, Object> resultMap, GraphQLError error) {
        List listPath;
        int line = -1;
        int column = -1;
        String path = null;
        List locations = error.getLocations();
        if (locations != null && locations.size() > 0) {
            SourceLocation sourceLocation = (SourceLocation)locations.get(0);
            line = sourceLocation.getLine();
            column = sourceLocation.getColumn();
        }
        if ((listPath = error.getPath()) != null && listPath.size() > 0) {
            path = listPath.get(0).toString();
        }
        this.addErrorPayload(resultMap, error.getMessage(), path, line, column, error.getExtensions());
    }

    private void addError(Map<String, Object> resultMap, Throwable cause, String originalMessage) {
        Object data = resultMap.get("data");
        String path = null;
        if (data instanceof Map) {
            Map dataMap = (Map)data;
            path = dataMap.keySet().stream().findFirst().orElse(null);
        }
        if (cause instanceof GraphQLException) {
            this.addErrorPayload(resultMap, this.getCheckedMessage(cause), path);
        } else if (cause instanceof Error || cause instanceof RuntimeException) {
            this.addErrorPayload(resultMap, this.getUncheckedMessage(cause), path);
        } else {
            this.addErrorPayload(resultMap, cause == null ? originalMessage : this.getCheckedMessage(cause), path);
        }
    }

    private void addErrorPayload(Map<String, Object> resultMap, String checkedMessage, String path) {
        this.addErrorPayload(resultMap, checkedMessage, path, -1, -1, Map.of());
    }

    private void addErrorPayload(Map<String, Object> resultMap, String message, String path, int line, int column, Map<String, Object> extensions) {
        LinkedList errorList = (LinkedList)resultMap.computeIfAbsent("errors", it -> new LinkedList());
        HashMap<String, Object> newErrorMap = new HashMap<String, Object>();
        newErrorMap.put("message", message);
        if (line != -1 && column != -1) {
            ArrayList<Map<String, Integer>> listLocations = new ArrayList<Map<String, Integer>>();
            listLocations.add(Map.of("line", line, "column", column));
            newErrorMap.put("locations", listLocations);
        }
        if (extensions != null && extensions.size() > 0) {
            newErrorMap.put("extensions", extensions);
        }
        if (path != null) {
            newErrorMap.put("path", List.of(path));
        }
        errorList.add(newErrorMap);
    }

    private String getUncheckedMessage(Throwable throwable) {
        Class<?> exceptionClazz = throwable.getClass();
        if (this.allowExceptions.containsKey(exceptionClazz)) {
            return throwable.getMessage();
        }
        do {
            if (!this.exceptionAllowSet.contains(exceptionClazz.getName())) continue;
            this.allowExceptions.put(exceptionClazz, true);
            return throwable.getMessage();
        } while ((exceptionClazz = exceptionClazz.getSuperclass()) != null);
        return this.defaultErrorMessage;
    }

    private String getCheckedMessage(Throwable throwable) {
        Class<?> exceptionClazz = throwable.getClass();
        if (this.denyExceptions.containsKey(exceptionClazz)) {
            return this.defaultErrorMessage;
        }
        do {
            if (!this.exceptionDenySet.contains(exceptionClazz.getName())) continue;
            this.denyExceptions.put(exceptionClazz, true);
            return this.defaultErrorMessage;
        } while ((exceptionClazz = exceptionClazz.getSuperclass()) != null);
        return throwable.getMessage();
    }

    @Override
    public String schemaString() {
        return this.schemaPrinter.print(this.schema);
    }

    @Override
    public String defaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    @Override
    public Set<String> blacklistedExceptions() {
        return Collections.unmodifiableSet(this.exceptionDenySet);
    }

    @Override
    public Set<String> whitelistedExceptions() {
        return Collections.unmodifiableSet(this.exceptionAllowSet);
    }
}

