/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.graphql.server;

import graphql.schema.GraphQLSchema;
import io.helidon.common.GenericType;
import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.uri.UriQuery;
import io.helidon.config.Config;
import io.helidon.graphql.server.InvocationHandler;
import io.helidon.reactive.media.common.MessageBodyReader;
import io.helidon.reactive.media.common.MessageBodyWriter;
import io.helidon.reactive.media.jsonb.JsonbSupport;
import io.helidon.reactive.webserver.Handler;
import io.helidon.reactive.webserver.Routing;
import io.helidon.reactive.webserver.ServerRequest;
import io.helidon.reactive.webserver.ServerResponse;
import io.helidon.reactive.webserver.Service;
import io.helidon.reactive.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.reactive.webserver.cors.CrossOriginConfig;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GraphQlSupport
implements Service {
    private static final Logger LOGGER = Logger.getLogger(GraphQlSupport.class.getName());
    private static final Jsonb JSONB = JsonbBuilder.newBuilder().withConfig(new JsonbConfig().setProperty("jsonb.zero-time-defaulting", (Object)true).withNullValues(Boolean.valueOf(true)).withAdapters(new JsonbAdapter[0])).build();
    private static final MessageBodyWriter<Object> JSONB_WRITER = JsonbSupport.writer((Jsonb)JSONB);
    private static final MessageBodyReader<Object> JSONB_READER = JsonbSupport.reader((Jsonb)JSONB);
    private static final GenericType<LinkedHashMap> LINKED_HASH_MAP_GENERIC_TYPE = GenericType.create(LinkedHashMap.class);
    private final String context;
    private final String schemaUri;
    private final InvocationHandler invocationHandler;
    private final CorsEnabledServiceHelper corsEnabled;
    private final ExecutorService executor;

    private GraphQlSupport(Builder builder) {
        this.context = builder.context;
        this.schemaUri = builder.schemaUri;
        this.invocationHandler = builder.handler;
        this.corsEnabled = CorsEnabledServiceHelper.create((String)"GraphQL", (CrossOriginConfig)builder.crossOriginConfig);
        this.executor = builder.executor.get();
    }

    public static GraphQlSupport create(GraphQLSchema schema) {
        return GraphQlSupport.builder().invocationHandler(InvocationHandler.create(schema)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update(Routing.Rules rules) {
        rules.any(this.context, new Handler[]{this.corsEnabled.processor()});
        rules.get(this.context + this.schemaUri, new Handler[]{this::graphQlSchema});
        rules.get(this.context, new Handler[]{this::graphQlGet}).post(this.context, new Handler[]{this::graphQlPost});
    }

    private void graphQlPost(ServerRequest req, ServerResponse res) {
        JSONB_READER.read((Flow.Publisher)req.content(), LINKED_HASH_MAP_GENERIC_TYPE, req.content().readerContext()).forSingle(entity -> this.processRequest(res, (String)entity.get("query"), (String)entity.get("operationName"), this.toVariableMap(entity.get("variables")))).exceptionallyAccept(arg_0 -> ((ServerResponse)res).send(arg_0));
    }

    private void graphQlGet(ServerRequest req, ServerResponse res) {
        UriQuery queryParams = req.queryParams();
        String query = (String)queryParams.first("query").orElseThrow(() -> new IllegalStateException("Query must be defined"));
        String operationName = queryParams.first("operationName").orElse(null);
        Map variables = queryParams.first("variables").map(this::toVariableMap).orElseGet(Map::of);
        this.processRequest(res, query, operationName, variables);
    }

    private void graphQlSchema(ServerRequest req, ServerResponse res) {
        res.send((Object)this.invocationHandler.schemaString());
    }

    private void processRequest(ServerResponse res, String query, String operationName, Map<String, Object> variables) {
        this.executor.submit(() -> {
            try {
                Map<String, Object> result = this.invocationHandler.execute(query, operationName, variables);
                res.send(JSONB_WRITER.marshall(result));
            }
            catch (Error e) {
                res.send((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unexpected exception when executing graphQL request", e);
            }
        });
    }

    private Map<String, Object> toVariableMap(Object variables) {
        if (variables == null) {
            return Map.of();
        }
        if (variables instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Map variablesMap = (Map)variables;
            variablesMap.forEach((k, v) -> result.put(String.valueOf(k), v));
            return result;
        }
        return this.toVariableMap(String.valueOf(variables));
    }

    private Map<String, Object> toVariableMap(String jsonString) {
        if (jsonString == null || jsonString.trim().isBlank()) {
            return Map.of();
        }
        return (Map)JSONB.fromJson(jsonString, LinkedHashMap.class);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, GraphQlSupport> {
        private String context = "/graphql";
        private String schemaUri = "/schema.graphql";
        private CrossOriginConfig crossOriginConfig;
        private Supplier<? extends ExecutorService> executor;
        private InvocationHandler handler;

        private Builder() {
        }

        public GraphQlSupport build() {
            if (this.handler == null) {
                throw new IllegalStateException("Invocation handler must be defined");
            }
            if (this.executor == null) {
                this.executor = ServerThreadPoolSupplier.builder().name("graphql").threadNamePrefix("graphql-").build();
            }
            return new GraphQlSupport(this);
        }

        public Builder config(Config config) {
            config.get("web-context").asString().ifPresent(this::webContext);
            config.get("schema-uri").asString().ifPresent(this::schemaUri);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            if (this.executor == null) {
                this.executor = ServerThreadPoolSupplier.builder().name("graphql").threadNamePrefix("graphql-").config((io.helidon.common.config.Config)config.get("executor-service")).build();
            }
            return this;
        }

        public Builder invocationHandler(InvocationHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder invocationHandler(Supplier<InvocationHandler> handler) {
            return this.invocationHandler(handler.get());
        }

        public Builder webContext(String path) {
            this.context = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        public Builder schemaUri(String uri) {
            this.schemaUri = uri.startsWith("/") ? uri : "/" + uri;
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = () -> executor;
            return this;
        }

        public Builder executor(Supplier<? extends ExecutorService> executor) {
            this.executor = executor;
            return this;
        }
    }
}

