/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.graphql.server;

import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import io.helidon.config.Config;
import io.helidon.graphql.server.InvocationHandlerImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface InvocationHandler {
    public static InvocationHandler create(GraphQLSchema schema) {
        return InvocationHandler.builder().schema(schema).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    default public Map<String, Object> execute(String query) {
        return this.execute(query, null, Map.of());
    }

    public Map<String, Object> execute(String var1, String var2, Map<String, Object> var3);

    public String schemaString();

    public String defaultErrorMessage();

    public Set<String> blacklistedExceptions();

    public Set<String> whitelistedExceptions();

    public static class Builder
    implements io.helidon.common.Builder<InvocationHandler> {
        private final Set<String> blacklistedExceptions = new HashSet<String>();
        private final Set<String> whitelistedExceptions = new HashSet<String>();
        private String defaultErrorMessage = "Server Error";
        private GraphQLSchema schema;
        private SchemaPrinter schemaPrinter;

        private Builder() {
        }

        public InvocationHandler build() {
            if (this.schema == null) {
                throw new IllegalStateException("GraphQL schema must be configured");
            }
            GraphQL graphQl = GraphQL.newGraphQL((GraphQLSchema)this.schema).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy()).build();
            SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeDirectives(false).useAstDefinitions(false).includeScalarTypes(true);
            this.schemaPrinter = new SchemaPrinter(options);
            return new InvocationHandlerImpl(this, graphQl);
        }

        public Builder config(Config config) {
            config.get("default-error-message").asString().ifPresent(this::defaultErrorMessage);
            config.get("exception-white-list").asList(String.class).stream().flatMap(Collection::stream).forEach(this::addWhitelistedException);
            config.get("exception-black-list").asList(String.class).stream().flatMap(Collection::stream).forEach(this::addBlacklistedException);
            return this;
        }

        public Builder schema(GraphQLSchema schema) {
            this.schema = schema;
            return this;
        }

        public Builder defaultErrorMessage(String defaultErrorMessage) {
            this.defaultErrorMessage = defaultErrorMessage;
            return this;
        }

        public Builder exceptionBlacklist(String[] classNames) {
            for (String className : classNames) {
                this.addBlacklistedException(className);
            }
            return this;
        }

        public Builder addBlacklistedException(String exceptionClass) {
            this.blacklistedExceptions.add(exceptionClass);
            return this;
        }

        public Builder exceptionWhitelist(String[] classNames) {
            for (String className : classNames) {
                this.addWhitelistedException(className);
            }
            return this;
        }

        public Builder addWhitelistedException(String exceptionClass) {
            this.whitelistedExceptions.add(exceptionClass);
            return this;
        }

        GraphQLSchema schema() {
            return this.schema;
        }

        String defaultErrorMessage() {
            return this.defaultErrorMessage;
        }

        Set<String> denyExceptions() {
            return this.blacklistedExceptions;
        }

        Set<String> allowExceptions() {
            return this.whitelistedExceptions;
        }

        SchemaPrinter schemaPrinter() {
            return this.schemaPrinter;
        }
    }
}

