/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.websocket.server;

import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.websocket.server.WebSocketExtension;
import io.helidon.declarative.codegen.websocket.server.WebSocketServerTypes;
import io.helidon.service.codegen.RegistryRoundContext;

class WebSocketRegistrationGenerator {
    private WebSocketRegistrationGenerator() {
    }

    static void generate(RegistryRoundContext roundContext, TypeInfo serverEndpoint, TypeName endpointType, TypeName generatedRegistration, TypeName generatedListener) {
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)WebSocketExtension.GENERATOR, (TypeName)endpointType, (TypeName)generatedRegistration)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)WebSocketExtension.GENERATOR, (TypeName)endpointType, (TypeName)generatedRegistration, (String)"1", (String)""))).accessModifier(AccessModifier.PACKAGE_PRIVATE).type(generatedRegistration).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addInterface(WebSocketServerTypes.WS_ROUTE_REGISTRATION);
        classModel.addField(route -> route.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(WebSocketServerTypes.WS_ROUTE).name("route"));
        classModel.addField(mappers -> mappers.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(DeclarativeTypes.COMMON_MAPPERS).name("mappers"));
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(DeclarativeTypes.COMMON_MAPPERS, "mappers")).addParameter(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(endpointType)).build(), "endpoint")).addContentLine("this.mappers = mappers;")).addContent("this.route = ")).addContent(WebSocketServerTypes.WS_ROUTE)).addContent(".create(")).addContent(generatedListener)).addContent(".PATH, () -> new ")).addContent(generatedListener)).addContentLine("(mappers, endpoint.get()));"));
        classModel.addMethod(route -> ((Method.Builder)((Method.Builder)((Method.Builder)route.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(WebSocketServerTypes.WS_ROUTE).name("route")).addContentLine("return route;"));
        classModel.addMethod(toString -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)toString.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("toString")).addContent("return ")).addContentLiteral("WebSocket route registration for " + endpointType.className() + "(")).addContent(" + ")).addContent(generatedListener)).addContent(".PATH + ")).addContentLiteral(")")).addContentLine(";"));
        String listener = serverEndpoint.findAnnotation(WebSocketServerTypes.ANNOTATION_LISTENER).flatMap(Annotation::stringValue).orElse("@default");
        if (!"@default".equals(listener)) {
            classModel.addMethod(socket -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)socket.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("socket")).addContent("return ")).addContentLiteral(listener)).addContentLine(";"));
            classModel.addMethod(socketRequired -> ((Method.Builder)((Method.Builder)((Method.Builder)socketRequired.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.PRIMITIVE_BOOLEAN).name("socketRequired")).addContent("return true;"));
        }
        roundContext.addGeneratedType(generatedRegistration, classModel, endpointType, new Object[]{serverEndpoint.originatingElementValue()});
    }
}

