/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.websocket.server;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.http.webserver.AbstractParametersProvider;
import io.helidon.declarative.codegen.websocket.WebSocketTypes;
import io.helidon.declarative.codegen.websocket.server.WebSocketExtension;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.RegistryRoundContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class WebSocketListenerGenerator
extends AbstractParametersProvider {
    WebSocketListenerGenerator() {
    }

    static void generate(RegistryRoundContext roundContext, TypeInfo serverEndpoint, TypeName endpointType, TypeName generatedListener) {
        new WebSocketListenerGenerator().process(roundContext, serverEndpoint, endpointType, generatedListener);
    }

    @Override
    protected String providerType() {
        return "Path Param";
    }

    private void process(RegistryRoundContext roundContext, TypeInfo serverEndpoint, TypeName endpointType, TypeName generatedListener) {
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)WebSocketExtension.GENERATOR, (TypeName)endpointType, (TypeName)generatedListener)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)WebSocketExtension.GENERATOR, (TypeName)endpointType, (TypeName)generatedListener, (String)"1", (String)""))).accessModifier(AccessModifier.PACKAGE_PRIVATE).type(generatedListener).superType(WebSocketTypes.WS_LISTENER_BASE);
        String path = serverEndpoint.findAnnotation(HttpTypes.HTTP_PATH_ANNOTATION).flatMap(Annotation::stringValue).orElse("/");
        classModel.addField(pathField -> ((Field.Builder)pathField.accessModifier(AccessModifier.PACKAGE_PRIVATE).isStatic(true).isFinal(true).type(TypeNames.STRING).name("PATH")).addContentLiteral(path));
        classModel.addField(endpoint -> endpoint.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(endpointType).name("endpoint"));
        classModel.addField(mappers -> mappers.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(DeclarativeTypes.COMMON_MAPPERS).name("mappers"));
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)Constructor.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(DeclarativeTypes.COMMON_MAPPERS, "mappers")).addParameter(endpoint -> endpoint.type(endpointType).name("endpoint"))).addContentLine("this.mappers = mappers;")).addContentLine("this.endpoint = endpoint;");
        FieldHandler fieldHandler = FieldHandler.create((ClassModel.Builder)classModel, (Constructor.Builder)ctr);
        HashMap<String, AtomicInteger> pathParamFieldCounters = new HashMap<String, AtomicInteger>();
        HashMap<PathParamKey, String> pathParamFields = new HashMap<PathParamKey, String>();
        List<TypedElementInfo> annotatedMethods = this.methods(serverEndpoint, WebSocketTypes.ANNOTATION_ON_ERROR);
        this.checkMaxOne(annotatedMethods, WebSocketTypes.ANNOTATION_ON_ERROR);
        if (!annotatedMethods.isEmpty()) {
            this.generateOnError(classModel, pathParamFieldCounters, pathParamFields, annotatedMethods.getFirst());
        }
        annotatedMethods = this.methods(serverEndpoint, WebSocketTypes.ANNOTATION_ON_CLOSE);
        this.checkMaxOne(annotatedMethods, WebSocketTypes.ANNOTATION_ON_CLOSE);
        if (!annotatedMethods.isEmpty()) {
            this.generateOnClose(classModel, pathParamFieldCounters, pathParamFields, annotatedMethods.getFirst());
        }
        annotatedMethods = this.methods(serverEndpoint, WebSocketTypes.ANNOTATION_ON_MESSAGE);
        this.generateOnMessage(classModel, fieldHandler, pathParamFieldCounters, pathParamFields, annotatedMethods);
        annotatedMethods = this.methods(serverEndpoint, WebSocketTypes.ANNOTATION_ON_OPEN);
        this.checkMaxOne(annotatedMethods, WebSocketTypes.ANNOTATION_ON_OPEN);
        if (!annotatedMethods.isEmpty()) {
            this.generateOnOpen(classModel, pathParamFieldCounters, pathParamFields, annotatedMethods.getFirst());
        }
        annotatedMethods = this.methods(serverEndpoint, WebSocketTypes.ANNOTATION_ON_UPGRADE);
        this.checkMaxOne(annotatedMethods, WebSocketTypes.ANNOTATION_ON_UPGRADE);
        this.generateOnHttpUpgrade(classModel, pathParamFieldCounters, pathParamFields, annotatedMethods);
        classModel.addConstructor(ctr);
        roundContext.addGeneratedType(generatedListener, classModel, endpointType, new Object[]{serverEndpoint.originatingElementValue()});
    }

    private void generateOnMessage(ClassModel.Builder classModel, FieldHandler fieldHandler, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, List<TypedElementInfo> annotatedMethods) {
        ArrayList<BinaryMethod> binaryMethods = new ArrayList<BinaryMethod>();
        ArrayList<TextMethod> textMethods = new ArrayList<TextMethod>();
        block0: for (TypedElementInfo annotatedMethod : annotatedMethods) {
            for (TypedElementInfo param : annotatedMethod.parameterArguments()) {
                TypeName typeName;
                if (param.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION) || (typeName = param.typeName()).equals((Object)WebSocketTypes.WS_SESSION)) continue;
                if (typeName.equals((Object)TypeNames.STRING)) {
                    textMethods.add(new TextMethod(TextKind.STRING, typeName, annotatedMethod));
                    continue block0;
                }
                if (typeName.equals((Object)TypeName.create(Reader.class))) {
                    textMethods.add(new TextMethod(TextKind.READER, typeName, annotatedMethod));
                    continue block0;
                }
                if (typeName.equals((Object)DeclarativeTypes.BUFFER_DATA)) {
                    binaryMethods.add(new BinaryMethod(BinaryKind.BUFFER_DATA, typeName, annotatedMethod));
                    continue block0;
                }
                if (typeName.equals((Object)TypeName.create(ByteBuffer.class))) {
                    binaryMethods.add(new BinaryMethod(BinaryKind.BYTE_BUFFER, typeName, annotatedMethod));
                    continue block0;
                }
                if (typeName.equals((Object)TypeName.create(InputStream.class))) {
                    binaryMethods.add(new BinaryMethod(BinaryKind.INPUT_STREAM, typeName, annotatedMethod));
                    continue block0;
                }
                if (typeName.equals((Object)TypeName.create(byte[].class))) {
                    binaryMethods.add(new BinaryMethod(BinaryKind.BYTE_ARRAY, typeName, annotatedMethod));
                    continue block0;
                }
                if (typeName.primitive()) {
                    textMethods.add(new TextMethod(TextKind.PRIMITIVE_TYPE, typeName, annotatedMethod));
                    continue block0;
                }
                throw new CodegenException("Invalid method signature. Method annotated with " + WebSocketTypes.ANNOTATION_ON_MESSAGE.fqName() + " does not have an expected binary or text parameter.", annotatedMethod.originatingElementValue());
            }
        }
        this.checkMaxOneBinary(binaryMethods);
        this.checkMaxOneText(textMethods);
        if (!binaryMethods.isEmpty()) {
            this.generateBinaryOnMessage(classModel, pathParamFieldCounters, pathParamFields, (BinaryMethod)binaryMethods.getFirst());
        }
        if (!textMethods.isEmpty()) {
            this.generateTextOnMessage(classModel, pathParamFieldCounters, pathParamFields, (TextMethod)textMethods.getFirst());
        }
    }

    private void generateTextOnMessage(ClassModel.Builder classModel, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, TextMethod method) {
        Method.Builder onMessage;
        block11: {
            block10: {
                onMessage = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("onMessage")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).addParameter(WebSocketTypes.WS_SESSION, "session")).addParameter(TypeNames.STRING, "text")).addParameter(TypeNames.PRIMITIVE_BOOLEAN, "last");
                if (!this.hasLast(method.handlingMethod())) break block10;
                switch (method.kind().ordinal()) {
                    case 0: {
                        this.textWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> it.addContent("text"));
                        break block11;
                    }
                    case 1: {
                        this.textWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> it.addContent("new ").addContent(StringReader.class).addContent("(text)"));
                        break block11;
                    }
                    case 2: {
                        this.textWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> it.addContent("mappers.map(text, ").addContent(String.class).addContent(".class, ").addContent(method.paramType()).addContent(".class, \"websocket\")"));
                        break block11;
                    }
                    default: {
                        throw new CodegenException("Unknown WebSocket method kind: " + String.valueOf((Object)method.kind()), method.handlingMethod().originatingElementValue());
                    }
                }
            }
            switch (method.kind().ordinal()) {
                case 0: {
                    this.textWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "textString", cb -> cb.addContent("it"));
                    break;
                }
                case 1: {
                    this.textWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "textReader", cb -> cb.addContent("it"));
                    break;
                }
                case 2: {
                    this.textWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "textString", it -> it.addContent("mappers.map(it, ").addContent(String.class).addContent(".class, ").addContent(method.paramType()).addContent(".class, \"websocket\")"));
                    break;
                }
                default: {
                    throw new CodegenException("Unknown WebSocket method kind: " + String.valueOf((Object)method.kind()), method.handlingMethod().originatingElementValue());
                }
            }
        }
        classModel.addMethod(onMessage);
    }

    private void textWithoutLast(Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, Method.Builder onMessage, TypedElementInfo handlingMethod, String invokeMethodName, Consumer<ContentBuilder<?>> itContentHandler) {
        ((Method.Builder)((Method.Builder)((Method.Builder)onMessage.addContent(invokeMethodName)).addContent("(session, text, last, it -> endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onMessage.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                onMessage.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onMessage.addContent("session");
                continue;
            }
            itContentHandler.accept((ContentBuilder<?>)onMessage);
        }
        onMessage.addContentLine("));");
    }

    private void binaryWithLast(Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, Method.Builder onMessage, TypedElementInfo handlingMethod, Consumer<ContentBuilder<?>> methodBodyConsumer, Consumer<ContentBuilder<?>> parameterConsumer) {
        methodBodyConsumer.accept((ContentBuilder<?>)onMessage);
        ((Method.Builder)((Method.Builder)onMessage.addContent("endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onMessage.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                onMessage.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onMessage.addContent("session");
                continue;
            }
            if (type.equals((Object)TypeNames.PRIMITIVE_BOOLEAN)) {
                onMessage.addContent("last");
                continue;
            }
            parameterConsumer.accept((ContentBuilder<?>)onMessage);
        }
        onMessage.addContentLine(");");
    }

    private void binaryWithoutLast(Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, Method.Builder onMessage, TypedElementInfo handlingMethod, String invokeMethodName) {
        ((Method.Builder)((Method.Builder)((Method.Builder)onMessage.addContent(invokeMethodName)).addContent("(session, buffer, last, it -> endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onMessage.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                onMessage.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onMessage.addContent("session");
                continue;
            }
            onMessage.addContent("it");
        }
        onMessage.addContentLine("));");
    }

    private void textWithLast(Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, Method.Builder onMessage, TypedElementInfo handlingMethod, Consumer<ContentBuilder<?>> consumer) {
        ((Method.Builder)((Method.Builder)onMessage.addContent("endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onMessage.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                onMessage.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onMessage.addContent("session");
                continue;
            }
            if (type.equals((Object)TypeNames.PRIMITIVE_BOOLEAN)) {
                onMessage.addContent("last");
                continue;
            }
            consumer.accept((ContentBuilder<?>)onMessage);
        }
        onMessage.addContentLine(");");
    }

    private boolean hasLast(TypedElementInfo typedElementInfo) {
        for (TypedElementInfo argument : typedElementInfo.parameterArguments()) {
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION) || !argument.typeName().equals((Object)TypeNames.PRIMITIVE_BOOLEAN)) continue;
            return true;
        }
        return false;
    }

    private void generateBinaryOnMessage(ClassModel.Builder classModel, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, BinaryMethod method) {
        Method.Builder onMessage;
        block13: {
            block12: {
                onMessage = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("onMessage")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).addParameter(WebSocketTypes.WS_SESSION, "session")).addParameter(DeclarativeTypes.BUFFER_DATA, "buffer")).addParameter(TypeNames.PRIMITIVE_BOOLEAN, "last");
                if (!this.hasLast(method.handlingMethod())) break block12;
                switch (method.kind().ordinal()) {
                    case 0: {
                        this.binaryWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> {}, it -> it.addContent("buffer"));
                        break block13;
                    }
                    case 1: {
                        this.binaryWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> it.addContent("var bb = ").addContent(DeclarativeTypes.BYTE_BUFFER).addContentLine(".allocate(buffer.available());").addContentLine("buffer.writeTo(bb, buffer.available());").addContentLine("bb.flip();"), it -> it.addContent("bb"));
                        break block13;
                    }
                    case 2: {
                        this.binaryWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> it.addContentLine("var bytes = new byte[buffer.available()];").addContentLine("buffer.read(bytes);"), it -> it.addContent("bytes"));
                        break block13;
                    }
                    case 3: {
                        this.binaryWithLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), it -> it.addContentLine("var bytes = new byte[buffer.available()];").addContentLine("buffer.read(bytes);").addContent("var inputStream = new ").addContent(ByteArrayInputStream.class).addContent("(bytes);"), it -> it.addContent("inputStream"));
                        break block13;
                    }
                    default: {
                        throw new CodegenException("Unknown WebSocket method kind: " + String.valueOf((Object)method.kind()), method.handlingMethod().originatingElementValue());
                    }
                }
            }
            switch (method.kind().ordinal()) {
                case 0: {
                    this.binaryWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "binaryBufferData");
                    break;
                }
                case 1: {
                    this.binaryWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "binaryByteBuffer");
                    break;
                }
                case 2: {
                    this.binaryWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "binaryByteArray");
                    break;
                }
                case 3: {
                    this.binaryWithoutLast(pathParamFieldCounters, pathParamFields, onMessage, method.handlingMethod(), "binaryInputStream");
                    break;
                }
                default: {
                    throw new CodegenException("Unknown WebSocket method kind: " + String.valueOf((Object)method.kind()), method.handlingMethod().originatingElementValue());
                }
            }
        }
        classModel.addMethod(onMessage);
    }

    private void generateOnOpen(ClassModel.Builder classModel, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, TypedElementInfo handlingMethod) {
        Method.Builder onOpen = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("onOpen")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).addParameter(WebSocketTypes.WS_SESSION, "session");
        ((Method.Builder)((Method.Builder)onOpen.addContent("endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onOpen.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION));
                onOpen.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onOpen.addContent("session");
                continue;
            }
            throw new CodegenException("Unsupported parameter type for onClose method: " + type.fqName(), handlingMethod.originatingElementValue());
        }
        onOpen.addContentLine(");");
        classModel.addMethod(onOpen);
    }

    private void generateOnHttpUpgrade(ClassModel.Builder classModel, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, List<TypedElementInfo> annotatedMethods) {
        TypedElementInfo handlingMethod;
        Method.Builder onUpgrade = ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("onHttpUpgrade")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).addParameter(HttpTypes.HTTP_PROLOGUE, "prologue")).addParameter(HttpTypes.HTTP_HEADERS, "headers")).addThrows(it -> it.type(WebSocketTypes.WS_UPGRADE_EXCEPTION))).returnType(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(HttpTypes.HTTP_HEADERS)).build());
        if (!annotatedMethods.isEmpty()) {
            handlingMethod = annotatedMethods.getFirst();
            for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
                TypeName type = argument.typeName();
                if (!argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) continue;
                this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION));
            }
        }
        if (annotatedMethods.isEmpty() && pathParamFields.isEmpty()) {
            return;
        }
        if (!pathParamFields.isEmpty()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)onUpgrade.addContent("var matched = ")).addContent(DeclarativeTypes.PATH_MATCHERS)).addContentLine(".create(PATH).match(prologue.uriPath());")).addContentLine("if (!matched.accepted()) {")).addContent("throw new ")).addContent(WebSocketTypes.WS_UPGRADE_EXCEPTION)).addContent("(")).addContentLiteral("Wrong matched path")).addContentLine(");")).addContentLine("}")).addContentLine()).addContentLine("var params = matched.path().pathParameters();")).addContentLine();
            pathParamFields.forEach((key, field) -> {
                classModel.addField(pathParamField -> pathParamField.accessModifier(AccessModifier.PRIVATE).isVolatile(true).type(key.type()).name(field));
                ((Method.Builder)onUpgrade.addContent(field)).addContent(" = params");
                this.codegenFromParameters((ContentBuilder<?>)onUpgrade, key.type(), key.name(), key.type().isOptional());
            });
        }
        if (annotatedMethods.isEmpty()) {
            ((Method.Builder)((Method.Builder)onUpgrade.addContent("return ")).addContent(TypeNames.OPTIONAL)).addContentLine(".empty();");
        } else {
            handlingMethod = annotatedMethods.getFirst();
            boolean isVoid = handlingMethod.typeName().equals((Object)TypeNames.PRIMITIVE_VOID);
            if (!isVoid) {
                onUpgrade.addContent("var response = ");
            }
            ((Method.Builder)((Method.Builder)onUpgrade.addContent("endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
            boolean first = true;
            for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
                if (first) {
                    first = false;
                } else {
                    onUpgrade.addContent(", ");
                }
                TypeName type = argument.typeName();
                if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                    onUpgrade.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                    continue;
                }
                if (type.equals((Object)HttpTypes.HTTP_PROLOGUE)) {
                    onUpgrade.addContent("prologue");
                    continue;
                }
                if (type.equals((Object)HttpTypes.HTTP_HEADERS)) {
                    onUpgrade.addContent("headers");
                    continue;
                }
                throw new CodegenException("Unsupported parameter type for onHttpUpgrade method: " + type.fqName(), handlingMethod.originatingElementValue());
            }
            onUpgrade.addContentLine(");");
            if (isVoid) {
                ((Method.Builder)((Method.Builder)onUpgrade.addContent("return ")).addContent(TypeNames.OPTIONAL)).addContentLine(".empty();");
            } else if (handlingMethod.typeName().isOptional()) {
                onUpgrade.addContentLine("return response;");
            } else {
                ((Method.Builder)((Method.Builder)onUpgrade.addContent("return ")).addContent(TypeNames.OPTIONAL)).addContentLine(".ofNullable(response);");
            }
        }
        classModel.addMethod(onUpgrade);
    }

    private void generateOnClose(ClassModel.Builder classModel, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, TypedElementInfo handlingMethod) {
        Method.Builder onClose = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("onClose")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).addParameter(WebSocketTypes.WS_SESSION, "session")).addParameter(TypeNames.PRIMITIVE_INT, "status")).addParameter(TypeNames.STRING, "reason");
        ((Method.Builder)((Method.Builder)onClose.addContent("endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onClose.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                onClose.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onClose.addContent("session");
                continue;
            }
            if (type.equals((Object)TypeNames.PRIMITIVE_INT)) {
                onClose.addContent("status");
                continue;
            }
            if (type.equals((Object)TypeNames.STRING)) {
                onClose.addContent("reason");
                continue;
            }
            throw new CodegenException("Unsupported parameter type for onClose method: " + type.fqName(), handlingMethod.originatingElementValue());
        }
        onClose.addContentLine(");");
        classModel.addMethod(onClose);
    }

    private void generateOnError(ClassModel.Builder classModel, Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, TypedElementInfo handlingMethod) {
        Method.Builder onError = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("onError")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).addParameter(WebSocketTypes.WS_SESSION, "session")).addParameter(DeclarativeTypes.THROWABLE, "t");
        ((Method.Builder)((Method.Builder)onError.addContent("endpoint.")).addContent(handlingMethod.elementName())).addContent("(");
        boolean first = true;
        for (TypedElementInfo argument : handlingMethod.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                onError.addContent(", ");
            }
            TypeName type = argument.typeName();
            if (argument.hasAnnotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)) {
                onError.addContent(this.pathParamField(pathParamFieldCounters, pathParamFields, type, argument.annotation(HttpTypes.HTTP_PATH_PARAM_ANNOTATION)));
                continue;
            }
            if (type.equals((Object)WebSocketTypes.WS_SESSION)) {
                onError.addContent("session");
                continue;
            }
            if (type.equals((Object)DeclarativeTypes.THROWABLE)) {
                onError.addContent("t");
                continue;
            }
            throw new CodegenException("Unsupported parameter type for onError method: " + type.fqName(), handlingMethod.originatingElementValue());
        }
        onError.addContentLine(");");
        classModel.addMethod(onError);
    }

    private String pathParamField(Map<String, AtomicInteger> pathParamFieldCounters, Map<PathParamKey, String> pathParamFields, TypeName type, Annotation annotation) {
        Object fieldName;
        String pathParamName = (String)annotation.stringValue().get();
        PathParamKey key = new PathParamKey(pathParamName, type);
        if (pathParamFields.containsKey(key)) {
            return pathParamFields.get(key);
        }
        if (pathParamFieldCounters.containsKey(pathParamName)) {
            fieldName = pathParamName + "_" + pathParamFieldCounters.get(pathParamName).getAndIncrement();
        } else {
            pathParamFieldCounters.put(pathParamName, new AtomicInteger());
            fieldName = pathParamName;
        }
        pathParamFields.put(key, (String)fieldName);
        return fieldName;
    }

    private List<TypedElementInfo> methods(TypeInfo serverEndpoint, TypeName annotationType) {
        List<TypedElementInfo> result = serverEndpoint.elementInfo().stream().filter(ElementInfoPredicates.hasAnnotation((TypeName)annotationType)).collect(Collectors.toUnmodifiableList());
        for (TypedElementInfo element : result) {
            this.checkNotPrivate(annotationType, element);
            this.checkNotStatic(annotationType, element);
            this.checkNotAbstract(annotationType, element);
        }
        return result;
    }

    private void checkNotAbstract(TypeName annotationType, TypedElementInfo it) {
        if (it.elementModifiers().contains(Modifier.ABSTRACT)) {
            throw new CodegenException("Methods annotated with " + annotationType.fqName() + " must be at least package private", it.originatingElementValue());
        }
    }

    private void checkNotStatic(TypeName annotationType, TypedElementInfo it) {
        if (it.elementModifiers().contains(Modifier.STATIC)) {
            throw new CodegenException("Methods annotated with " + annotationType.fqName() + " must not be static", it.originatingElementValue());
        }
    }

    private void checkNotPrivate(TypeName annotationType, TypedElementInfo it) {
        if (it.accessModifier() == AccessModifier.PRIVATE) {
            throw new CodegenException("Methods annotated with " + annotationType.fqName() + " must be at least package private", it.originatingElementValue());
        }
    }

    private void checkMaxOne(List<TypedElementInfo> annotatedMethods, TypeName annotationType) {
        if (annotatedMethods.size() > 1) {
            throw new CodegenException("There can be maximally one method annotated with " + annotationType.fqName(), annotatedMethods.getFirst().originatingElementValue());
        }
    }

    private void checkMaxOneBinary(List<BinaryMethod> annotatedMethods) {
        if (annotatedMethods.size() > 1) {
            throw new CodegenException("There can be maximally one method annotated with " + String.valueOf(WebSocketTypes.ANNOTATION_ON_MESSAGE) + " handling binary messages", annotatedMethods.getFirst().handlingMethod().originatingElementValue());
        }
    }

    private void checkMaxOneText(List<TextMethod> annotatedMethods) {
        if (annotatedMethods.size() > 1) {
            throw new CodegenException("There can be maximally one method annotated with " + String.valueOf(WebSocketTypes.ANNOTATION_ON_MESSAGE) + " handling text messages", annotatedMethods.getFirst().handlingMethod().originatingElementValue());
        }
    }

    private record TextMethod(TextKind kind, TypeName paramType, TypedElementInfo handlingMethod) {
    }

    private static enum TextKind {
        STRING,
        READER,
        PRIMITIVE_TYPE;

    }

    private record BinaryMethod(BinaryKind kind, TypeName paramType, TypedElementInfo handlingMethod) {
    }

    private static enum BinaryKind {
        BUFFER_DATA,
        BYTE_BUFFER,
        BYTE_ARRAY,
        INPUT_STREAM;

    }

    private record PathParamKey(String name, TypeName type) {
    }
}

