/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.websocket.server;

import io.helidon.codegen.CodegenException;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.declarative.codegen.websocket.server.WebSocketListenerGenerator;
import io.helidon.declarative.codegen.websocket.server.WebSocketRegistrationGenerator;
import io.helidon.declarative.codegen.websocket.server.WebSocketServerTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.Collection;

class WebSocketExtension
implements RegistryCodegenExtension {
    static final TypeName GENERATOR = TypeName.create(WebSocketExtension.class);
    private final RegistryCodegenContext ctx;

    WebSocketExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RegistryRoundContext roundContext) {
        Collection serverEndpoints = roundContext.annotatedTypes(WebSocketServerTypes.ANNOTATION_ENDPOINT);
        for (TypeInfo serverEndpoint : serverEndpoints) {
            this.process(roundContext, serverEndpoint);
        }
    }

    private void process(RegistryRoundContext roundContext, TypeInfo serverEndpoint) {
        if (serverEndpoint.kind() == ElementKind.INTERFACE) {
            throw new CodegenException("Interfaces should not be annotated with " + WebSocketServerTypes.ANNOTATION_ENDPOINT.fqName(), serverEndpoint.originatingElementValue());
        }
        TypeName endpointType = serverEndpoint.typeName();
        String classNameBase = endpointType.classNameWithEnclosingNames().replace('.', '_');
        String listenerClassName = classNameBase + "__WsListener";
        String registrationClassName = classNameBase + "__WsRegistration";
        TypeName generatedListener = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(endpointType.packageName())).className(listenerClassName)).build();
        TypeName generatedRegistration = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(endpointType.packageName())).className(registrationClassName)).build();
        WebSocketRegistrationGenerator.generate(roundContext, serverEndpoint, endpointType, generatedRegistration, generatedListener);
        WebSocketListenerGenerator.generate(roundContext, serverEndpoint, endpointType, generatedListener);
    }
}

