/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.validation;

import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.AnnotationProperty;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.validation.ValidationTypes;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class ValidationHelper {
    private ValidationHelper() {
    }

    static String addTypeValidator(FieldHandler fieldHandler, TypeName validatedType) {
        TypeName validatorType = ((TypeName.Builder)TypeName.builder((TypeName)ValidationTypes.TYPE_VALIDATOR).addTypeArgument(validatedType)).build();
        return fieldHandler.field(validatorType, "typeValidator", AccessModifier.PRIVATE, (Object)validatedType, it -> {}, (ctr, name) -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addParameter(param -> param.type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(validatorType)).build()).name(name + "_optional"))).addContent("this.")).addContent(name)).addContent(" = ")).addContent(name + "_optional")).addContent(".orElseThrow(() -> new ")).addContent(IllegalArgumentException.class)).addContent("(")).addContentLiteral("Type validator for ")).addContent(" + ")).addContent(validatedType.fqName())).addContent(".class.getName() + ")).addContentLiteral(" is not available, maybe it is not annotated with Validation.Validated, or the annotation processor setup is missing.")).addContentLine("));"));
    }

    static void addValidationOfValid(ContentBuilder<?> contentBuilder, String validatorField, String varName) {
        contentBuilder.addContent(validatorField).addContent(".check(validation__ctx, ").addContent(varName).addContentLine(");");
    }

    static void addValidationOfTypeArguments(TypeName generatedType, Collection<TypeName> constraintAnnotations, ContentBuilder<?> contentBuilder, FieldHandler fieldHandler, TypedElementInfo element, String localVariableName) {
        TypeName typeName = element.typeName();
        if (typeName.equals((Object)TypeNames.SET) || typeName.equals((Object)TypeNames.LIST) || typeName.equals((Object)TypeNames.COLLECTION) || typeName.equals((Object)TypeNames.OPTIONAL)) {
            ValidationHelper.addValidationForSingleTypeArgument(generatedType, constraintAnnotations, contentBuilder, fieldHandler, element, localVariableName, typeName);
        } else if (typeName.equals((Object)TypeNames.MAP)) {
            ValidationHelper.addValidationOfMap(generatedType, constraintAnnotations, contentBuilder, fieldHandler, element, localVariableName, typeName);
        }
    }

    static void addValidationOfConstraint(TypeName generatedType, FieldHandler fieldHandler, ContentBuilder<?> contentBuilder, Annotation constraint, String location, TypedElementInfo element, String varName) {
        String constraintType = fieldHandler.constant("CONSTRAINT", TypeNames.STRING, (Object)constraint.typeName(), it -> it.addContentLiteral(constraint.typeName().fqName()));
        String validator = fieldHandler.field(ValidationTypes.CONSTRAINT_VALIDATOR, "constraintValidator", AccessModifier.PRIVATE, (Object)constraint, it -> {}, (ctr, name) -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addParameter(param -> ((Parameter.Builder)((Parameter.Builder)param.name(name + "_provider")).addAnnotation(ValidationHelper.namedByConstant(generatedType, constraintType))).type(ValidationTypes.CONSTRAINT_VALIDATOR_PROVIDER))).addContent("this.")).addContent(name)).addContent(" = ")).addContent(name + "_provider")).addContent(".create(")).addContentCreate(element.typeName())).addContent(", ")).addContentCreate(constraint)).addContentLine(");"));
        contentBuilder.addContent("validation__ctx.check(").addContent(validator).addContent(", ").addContent(varName).addContentLine(");");
    }

    static boolean needsWork(Collection<TypeName> constraintAnnotations, TypedElementInfo element) {
        if (element.hasAnnotation(ValidationTypes.VALIDATION_VALID)) {
            return true;
        }
        for (TypeName constraintAnnotation : constraintAnnotations) {
            if (!element.hasAnnotation(constraintAnnotation)) continue;
            return true;
        }
        if (ValidationHelper.needsWork(constraintAnnotations, element.annotations())) {
            return true;
        }
        TypeName elementType = element.typeName();
        for (TypeName typeName : elementType.typeArguments()) {
            if (typeName.hasAnnotation(ValidationTypes.VALIDATION_VALID)) {
                return true;
            }
            for (TypeName constraintAnnotation : constraintAnnotations) {
                if (!typeName.hasAnnotation(constraintAnnotation)) continue;
                return true;
            }
            if (!ValidationHelper.needsWork(constraintAnnotations, typeName.annotations())) continue;
            return true;
        }
        for (TypedElementInfo param : element.parameterArguments()) {
            if (!ValidationHelper.needsWork(constraintAnnotations, param)) continue;
            return true;
        }
        return false;
    }

    static boolean needsWork(Collection<TypeName> constraintAnnotations, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.hasMetaAnnotation(ValidationTypes.VALIDATION_VALID)) {
                return true;
            }
            for (TypeName constraintAnnotation : constraintAnnotations) {
                if (!annotation.hasMetaAnnotation(constraintAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    static Annotation namedByConstant(TypeName type, String constantName) {
        return ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED)).putProperty("value", AnnotationProperty.create((Object)"", (TypeName)type, (String)constantName))).build();
    }

    static List<Annotation> findMetaAnnotations(List<Annotation> annotations, TypeName constraintAnnotation) {
        ArrayList<Annotation> response = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            List metaAnnotations = annotation.metaAnnotations();
            for (Annotation metaAnnotation : metaAnnotations) {
                if (metaAnnotation.typeName().equals((Object)constraintAnnotation)) {
                    response.add(metaAnnotation);
                }
                response.addAll(ValidationHelper.findMetaAnnotations(metaAnnotation.metaAnnotations(), constraintAnnotation));
            }
        }
        return response;
    }

    static boolean metaAnnotated(TypedElementInfo element, TypeName checkValid) {
        for (Annotation annotation : element.annotations()) {
            if (!annotation.hasMetaAnnotation(checkValid)) continue;
            return true;
        }
        return false;
    }

    private static void addValidationOfMap(TypeName generatedType, Collection<TypeName> constraintAnnotations, ContentBuilder<?> contentBuilder, FieldHandler fieldHandler, TypedElementInfo element, String localVariableName, TypeName typeName) {
        if (typeName.typeArguments().size() == 2) {
            TypeName keyType = (TypeName)typeName.typeArguments().get(0);
            TypeName valueType = (TypeName)typeName.typeArguments().get(1);
            boolean keyHasValid = keyType.hasAnnotation(ValidationTypes.VALIDATION_VALID);
            ArrayList keyConstraints = new ArrayList();
            boolean valueHasValid = valueType.hasAnnotation(ValidationTypes.VALIDATION_VALID);
            ArrayList valueConstraints = new ArrayList();
            for (TypeName constraintAnnotation : constraintAnnotations) {
                keyType.findAnnotation(constraintAnnotation).ifPresent(keyConstraints::add);
            }
            for (TypeName constraintAnnotation : constraintAnnotations) {
                valueType.findAnnotation(constraintAnnotation).ifPresent(valueConstraints::add);
            }
            if (keyHasValid || valueHasValid || !keyConstraints.isEmpty() || !valueConstraints.isEmpty()) {
                Object validatorField;
                contentBuilder.addContent("if (").addContent(localVariableName).addContentLine(" != null) {");
                contentBuilder.addContent("for (var validation__entry : ").addContent(localVariableName).addContentLine(".entrySet()) {").addContentLine("var validation__key = validation__entry.getKey();").addContentLine("var validation__value = validation__entry.getValue();");
                if (keyHasValid || !keyConstraints.isEmpty()) {
                    contentBuilder.addContent("try (var scope__mapkey = validation__ctx.scope(").addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION).addContent(".KEY, ").addContentLiteral("key").addContentLine(")) {");
                }
                if (keyHasValid) {
                    validatorField = ValidationHelper.addTypeValidator(fieldHandler, keyType);
                    ValidationHelper.addValidationOfValid(contentBuilder, (String)validatorField, "validation__key");
                }
                for (Annotation constraint : keyConstraints) {
                    ValidationHelper.addValidationOfConstraint(generatedType, fieldHandler, contentBuilder, constraint, "KEY", element, "validation__key");
                }
                if (keyHasValid || !keyConstraints.isEmpty()) {
                    contentBuilder.addContentLine("}");
                }
                if (valueHasValid || !valueConstraints.isEmpty()) {
                    contentBuilder.addContent("try (var scope__mapelement = validation__ctx.scope(").addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION).addContent(".ELEMENT, ").addContentLiteral("value").addContentLine(")) {");
                }
                if (valueHasValid) {
                    validatorField = ValidationHelper.addTypeValidator(fieldHandler, valueType);
                    ValidationHelper.addValidationOfValid(contentBuilder, (String)validatorField, "validation__value");
                }
                for (Annotation constraint : valueConstraints) {
                    ValidationHelper.addValidationOfConstraint(generatedType, fieldHandler, contentBuilder, constraint, "ELEMENT", element, "validation__value");
                }
                if (valueHasValid || !valueConstraints.isEmpty()) {
                    contentBuilder.addContentLine("}");
                }
                contentBuilder.addContentLine("}");
                contentBuilder.addContentLine("}");
            }
        }
    }

    private static void addValidationForSingleTypeArgument(TypeName generatedType, Collection<TypeName> constraintAnnotations, ContentBuilder<?> contentBuilder, FieldHandler fieldHandler, TypedElementInfo element, String localVariableName, TypeName typeName) {
        if (!typeName.typeArguments().isEmpty()) {
            boolean isOptional = typeName.equals((Object)TypeNames.OPTIONAL);
            TypeName maybeAnnotated = (TypeName)typeName.typeArguments().getFirst();
            boolean hasValid = maybeAnnotated.hasAnnotation(ValidationTypes.VALIDATION_VALID) || !ValidationHelper.findMetaAnnotations(maybeAnnotated.annotations(), ValidationTypes.VALIDATION_VALID).isEmpty();
            ArrayList<Annotation> constraints = new ArrayList<Annotation>();
            for (TypeName constraintAnnotation : constraintAnnotations) {
                maybeAnnotated.findAnnotation(constraintAnnotation).ifPresent(constraints::add);
                constraints.addAll(ValidationHelper.findMetaAnnotations(maybeAnnotated.annotations(), constraintAnnotation));
            }
            if (hasValid || !constraints.isEmpty()) {
                contentBuilder.addContent("if (").addContent(localVariableName).addContentLine(" != null) {");
                if (isOptional) {
                    contentBuilder.addContent("if (").addContent(localVariableName).addContentLine(".isPresent()) {").addContent("var validation__element = ").addContent(localVariableName).addContentLine(".get();");
                } else {
                    contentBuilder.addContent("for (var validation__element : ").addContent(localVariableName).addContentLine(") {");
                }
                contentBuilder.addContent("try (var scope__element = validation__ctx.scope(").addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION).addContent(".").addContent("ELEMENT").addContentLine(", \"element\")) {");
                if (hasValid) {
                    String validatorField = ValidationHelper.addTypeValidator(fieldHandler, maybeAnnotated);
                    ValidationHelper.addValidationOfValid(contentBuilder, validatorField, "validation__element");
                }
                for (Annotation constraint : constraints) {
                    ValidationHelper.addValidationOfConstraint(generatedType, fieldHandler, contentBuilder, constraint, "ELEMENT", element, "validation__element");
                }
                contentBuilder.addContentLine("}");
                contentBuilder.addContentLine("}");
                contentBuilder.addContentLine("}");
            }
        }
    }
}

