/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.validation;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.validation.ValidationHelper;
import io.helidon.declarative.codegen.validation.ValidationTypes;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class InterceptorGenerator {
    private static final TypeName GENERATOR = TypeName.create(InterceptorGenerator.class);
    private final RegistryRoundContext roundContext;
    private final Collection<TypeName> constraintAnnotations;

    InterceptorGenerator(RegistryRoundContext roundContext, Collection<TypeName> constraintAnnotations) {
        this.roundContext = roundContext;
        this.constraintAnnotations = constraintAnnotations;
    }

    void process(TypeInfo type) {
        if (type.kind() == ElementKind.ANNOTATION_TYPE) {
            return;
        }
        if (!this.isService(type)) {
            if (!type.hasAnnotation(ValidationTypes.VALIDATION_VALIDATED)) {
                throw new CodegenException(ValidationTypes.VALIDATION_VALIDATED.fqName() + " annotation is required on non-service type that has constraints or valid checks.", (Object)type);
            }
            return;
        }
        AtomicInteger interceptorCounter = new AtomicInteger();
        type.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates.hasAnnotation((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)).forEach(element -> this.generateInterceptor(type, interceptorCounter, (TypedElementInfo)element, "FIELD"));
        List constructors = type.elementInfo().stream().filter(ElementInfoPredicates::isConstructor).filter(Predicate.not(ElementInfoPredicates::isPrivate)).collect(Collectors.toUnmodifiableList());
        Object constructor = constructors.size() == 1 ? (TypedElementInfo)constructors.getFirst() : (constructors.isEmpty() ? null : (TypedElementInfo)constructors.stream().filter(ElementInfoPredicates.hasAnnotation((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)).findFirst().orElse(null));
        if (constructor != null) {
            this.generateInterceptor(type, interceptorCounter, (TypedElementInfo)constructor, "CONSTRUCTOR");
        }
        type.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).forEach(element -> this.generateInterceptor(type, interceptorCounter, (TypedElementInfo)element, "METHOD"));
    }

    private boolean isService(TypeInfo type) {
        if (type.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PROVIDER)) {
            return true;
        }
        if (type.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_SCOPE)) {
            return true;
        }
        for (Annotation annotation : type.annotations()) {
            if (annotation.hasMetaAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PROVIDER)) {
                return true;
            }
            if (!annotation.hasMetaAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_SCOPE)) continue;
            return true;
        }
        return false;
    }

    private void generateInterceptor(TypeInfo interceptedType, AtomicInteger interceptorCounter, TypedElementInfo element, String location) {
        if (!ValidationHelper.needsWork(this.constraintAnnotations, element)) {
            return;
        }
        TypeName typeName = interceptedType.typeName();
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(typeName.packageName())).className(typeName.classNameWithEnclosingNames().replace('.', '_') + "__ValidationInterceptor_" + interceptorCounter.getAndIncrement())).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)typeName, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)typeName, (TypeName)generatedType, (String)"0", (String)""))).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).accessModifier(AccessModifier.PACKAGE_PRIVATE).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED, (String)(typeName.fqName() + "." + element.signature().text())))).addInterface(ServiceCodegenTypes.INTERCEPTION_ELEMENT_INTERCEPTOR);
        Constructor.Builder constructor = (Constructor.Builder)Constructor.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE);
        FieldHandler fieldHandler = FieldHandler.create((ClassModel.Builder)classModel, (Constructor.Builder)constructor);
        TypeName genericVType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().className("V")).generic(true)).build();
        Method.Builder proceedMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addGenericArgument(TypeArgument.builder().token("V").build()).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(genericVType).name("proceed")).addParameter(ctx -> ((Parameter.Builder)ctx.name("interception__ctx")).type(ServiceCodegenTypes.INTERCEPTION_CONTEXT))).addParameter(chain -> ((Parameter.Builder)chain.name("interception__chain")).type(((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.INTERCEPTION_CHAIN).addTypeArgument(genericVType)).build()))).addParameter(args -> ((Parameter.Builder)args.name("interception__args")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OBJECT).vararg(true)).build()))).addThrows(thrown -> thrown.type(Exception.class))).addContent("var validation__ctx = ")).addContent(ValidationTypes.VALIDATION_CONTEXT)).addContent(".create(")).addContent(typeName)).addContentLine(".class, interception__ctx.serviceInstance().orElse(null));")).addContent("try (var scope__type = validation__ctx.scope(")).addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION)).addContent(".TYPE, ")).addContent(typeName)).addContentLine(".class.getName())) {");
        if (element.kind() == ElementKind.FIELD) {
            String name = element.elementName();
            ((Method.Builder)((Method.Builder)proceedMethod.addContent("var ")).addContent(name)).addContentLine(" = interception__args[0];");
            this.addValidators(generatedType, proceedMethod, fieldHandler, element, location, name);
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent("try (var scope__" + location.toLowerCase(Locale.ROOT) + " = validation__ctx.scope(")).addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION)).addContent(".")).addContent(location)).addContent(", ")).addContentLiteral(element.signature().text())).addContentLine(")) {");
            List params = element.parameterArguments();
            for (int i = 0; i < params.size(); ++i) {
                TypedElementInfo param = (TypedElementInfo)params.get(i);
                if (!ValidationHelper.needsWork(this.constraintAnnotations, param)) continue;
                String name = param.elementName();
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent("var ")).addContent(name)).addContent(" = (")).addContent(param.typeName())).addContent(") interception__args[")).addContent(String.valueOf(i))).addContentLine("];");
                this.addValidators(generatedType, proceedMethod, fieldHandler, param, "PARAMETER", name);
            }
            proceedMethod.addContentLine("}");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContentLine()).addContentLine("validation__ctx.throwOnFailure();")).addContentLine()).addContentLine("var interception__res = interception__chain.proceed(interception__args);")).addContentLine();
        if (element.kind() == ElementKind.METHOD) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent("try (var scope__" + location.toLowerCase(Locale.ROOT) + " = validation__ctx.scope(")).addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION)).addContent(".")).addContent(location)).addContent(", ")).addContentLiteral(element.signature().text())).addContentLine(")) {");
            this.addValidators(generatedType, proceedMethod, fieldHandler, element, "RETURN_VALUE", "interception__res");
            proceedMethod.addContentLine("}");
        }
        ((Method.Builder)((Method.Builder)proceedMethod.addContentLine("validation__ctx.throwOnFailure();")).addContentLine()).addContentLine("return interception__res;");
        proceedMethod.addContentLine("}");
        classModel.addConstructor(constructor);
        classModel.addMethod((Method.Builder)proceedMethod.addContentLine());
        this.roundContext.addGeneratedType(generatedType, classModel, GENERATOR, new Object[0]);
    }

    private void addValidators(TypeName generatedType, Method.Builder proceedMethod, FieldHandler fieldHandler, TypedElementInfo element, String location, String localVariableName) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent("try (var scope__" + location.toLowerCase(Locale.ROOT) + " = validation__ctx.scope(")).addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION)).addContent(".")).addContent(location)).addContent(", ")).addContentLiteral("RETURN_VALUE".equals(location) ? element.typeName().classNameWithEnclosingNames() : localVariableName)).addContentLine(")) {");
        if (element.hasAnnotation(ValidationTypes.VALIDATION_VALID) || ValidationHelper.metaAnnotated(element, ValidationTypes.VALIDATION_VALID)) {
            String fieldName = ValidationHelper.addTypeValidator(fieldHandler, element.typeName());
            ValidationHelper.addValidationOfValid(proceedMethod, fieldName, localVariableName);
        }
        for (TypeName constraintAnnotation : this.constraintAnnotations) {
            element.findAnnotation(constraintAnnotation).ifPresent(it -> ValidationHelper.addValidationOfConstraint(generatedType, fieldHandler, proceedMethod, it, location, element, localVariableName));
            for (Annotation annotation : ValidationHelper.findMetaAnnotations(element.annotations(), constraintAnnotation)) {
                ValidationHelper.addValidationOfConstraint(generatedType, fieldHandler, proceedMethod, annotation, location, element, localVariableName);
            }
        }
        ValidationHelper.addValidationOfTypeArguments(generatedType, this.constraintAnnotations, proceedMethod, fieldHandler, element, localVariableName);
        proceedMethod.addContentLine("}");
    }
}

