/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.metrics;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.metrics.CountedHandler;
import io.helidon.declarative.codegen.metrics.GaugeHandler;
import io.helidon.declarative.codegen.metrics.MetricsTypes;
import io.helidon.declarative.codegen.metrics.TimedHandler;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

class MetricsExtension
implements RegistryCodegenExtension {
    static final TypeName GENERATOR = TypeName.create(MetricsExtension.class);
    private final RegistryCodegenContext ctx;

    MetricsExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    static String scope(Annotation annotation) {
        return annotation.stringValue("scope").orElse("application");
    }

    static List<Tag> tags(RegistryRoundContext roundContext, TypeName enclosingType, TypedElementInfo element, Annotation annotation) {
        ArrayList<Tag> tags = new ArrayList<Tag>(MetricsExtension.typeTags(roundContext, enclosingType));
        tags.addAll(MetricsExtension.elementTags((Annotated)element));
        tags.addAll(MetricsExtension.toTags(annotation.annotationValues("tags").orElseGet(List::of)));
        return tags;
    }

    static String name(Annotation annotation, TypeName enclosingType, TypedElementInfo element) {
        String name = annotation.stringValue().filter(Predicate.not(String::isBlank)).orElse(element.elementName());
        boolean absolute = annotation.booleanValue("absoluteName").orElse(false);
        return absolute ? name : enclosingType.className() + "." + name;
    }

    static String description(Annotation annotation, TypeName annotationType, TypeName enclosingType, TypedElementInfo element) {
        return annotation.stringValue("description").filter(Predicate.not(String::isBlank)).orElseGet(() -> annotationType.classNameWithEnclosingNames() + " annotation on method " + enclosingType.className() + "." + element.signature().text());
    }

    static void addTagsToBuilder(ContentBuilder<?> contentBuilder, List<Tag> tags) {
        if (tags.isEmpty()) {
            return;
        }
        contentBuilder.addContent(".tags(").addContent(List.class).addContent(".of(");
        Iterator<Tag> it = tags.iterator();
        while (it.hasNext()) {
            Tag tag = it.next();
            contentBuilder.addContent(MetricsTypes.TAG).addContent(".create(").addContentLiteral(tag.key()).addContent(", ").addContentLiteral(tag.value()).addContent(")");
            if (!it.hasNext()) continue;
            contentBuilder.addContent(", ");
        }
        contentBuilder.addContentLine("))");
    }

    public void process(RegistryRoundContext roundContext) {
        HashMap<TypeName, TypeInfo> types = new HashMap<TypeName, TypeInfo>();
        for (TypeInfo info : roundContext.types()) {
            types.put(info.typeName(), info);
        }
        this.generateGaugeRegistrars(roundContext, types);
        this.generateCountedInterceptors(roundContext, types);
        this.generateTimedInterceptors(roundContext, types);
    }

    private static List<Tag> typeTags(RegistryRoundContext roundContext, TypeName enclosingType) {
        Optional maybeType = roundContext.typeInfo(enclosingType);
        if (maybeType.isEmpty()) {
            return List.of();
        }
        return MetricsExtension.elementTags((Annotated)maybeType.get());
    }

    private static List<Tag> elementTags(Annotated annotated) {
        if (annotated.hasAnnotation(MetricsTypes.ANNOTATION_TAG)) {
            return MetricsExtension.toTags(List.of(annotated.annotation(MetricsTypes.ANNOTATION_TAG)));
        }
        if (annotated.hasAnnotation(MetricsTypes.ANNOTATION_TAGS)) {
            return MetricsExtension.toTags(annotated.annotation(MetricsTypes.ANNOTATION_TAGS).annotationValues().orElseGet(List::of));
        }
        return List.of();
    }

    private static List<Tag> toTags(List<Annotation> tags) {
        return tags.stream().map(tag -> new Tag(tag.stringValue("key").orElse(""), tag.stringValue("value").orElse(""))).toList();
    }

    private void generateCountedInterceptors(RegistryRoundContext roundContext, Map<TypeName, TypeInfo> types) {
        Collection elements = roundContext.annotatedElements(MetricsTypes.ANNOTATION_COUNTED);
        HashMap<TypeName, AtomicInteger> counters = new HashMap<TypeName, AtomicInteger>();
        types.keySet().forEach(it -> counters.put((TypeName)it, new AtomicInteger()));
        CountedHandler countedHandler = new CountedHandler(roundContext);
        for (TypedElementInfo element : elements) {
            TypeName enclosingType = this.enclosingType(element);
            int counter = counters.computeIfAbsent(enclosingType, k -> new AtomicInteger()).getAndIncrement();
            TypeInfo typeInfo = types.get(enclosingType);
            if (typeInfo == null) {
                typeInfo = (TypeInfo)this.ctx.typeInfo(enclosingType).orElseThrow(() -> new CodegenException("No type info found for type " + enclosingType.fqName()));
            }
            this.checkTypeIsService(roundContext, typeInfo);
            countedHandler.handle(typeInfo, element, counter);
        }
    }

    private void generateTimedInterceptors(RegistryRoundContext roundContext, Map<TypeName, TypeInfo> types) {
        Collection elements = roundContext.annotatedElements(MetricsTypes.ANNOTATION_TIMED);
        HashMap<TypeName, AtomicInteger> counters = new HashMap<TypeName, AtomicInteger>();
        types.keySet().forEach(it -> counters.put((TypeName)it, new AtomicInteger()));
        TimedHandler handler = new TimedHandler(roundContext);
        for (TypedElementInfo element : elements) {
            TypeName enclosingType = this.enclosingType(element);
            int counter = counters.computeIfAbsent(enclosingType, k -> new AtomicInteger()).getAndIncrement();
            TypeInfo typeInfo = types.get(enclosingType);
            if (typeInfo == null) {
                typeInfo = (TypeInfo)this.ctx.typeInfo(enclosingType).orElseThrow(() -> new CodegenException("No type info found for type " + enclosingType.fqName()));
            }
            this.checkTypeIsService(roundContext, typeInfo);
            handler.handle(typeInfo, element, counter);
        }
    }

    private void generateGaugeRegistrars(RegistryRoundContext roundContext, Map<TypeName, TypeInfo> types) {
        HashMap<TypeName, List<Gauge>> gaugeByType = new HashMap<TypeName, List<Gauge>>();
        this.addGauges(roundContext, gaugeByType);
        GaugeHandler handler = new GaugeHandler(roundContext);
        gaugeByType.forEach((type, gauges) -> {
            TypeInfo typeInfo = (TypeInfo)types.get(type);
            if (typeInfo == null) {
                typeInfo = (TypeInfo)roundContext.typeInfo(type).orElseThrow(() -> new CodegenException("No type info found for type " + type.fqName()));
            }
            this.checkTypeIsService(roundContext, typeInfo);
            handler.handle(typeInfo, (List<Gauge>)gauges);
        });
    }

    private void checkTypeIsService(RegistryRoundContext roundContext, TypeInfo typeInfo) {
        Optional descriptor = roundContext.generatedType(this.ctx.descriptorType(typeInfo.typeName()));
        if (descriptor.isEmpty() && typeInfo.annotations().isEmpty()) {
            throw new CodegenException("Type annotated with one of the metrics annotations is not a service itself. It must be annotated with " + ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON.classNameWithEnclosingNames() + ", or it must be a CDI bean (in Helidon MP).", typeInfo.originatingElementValue());
        }
    }

    private TypeName enclosingType(TypedElementInfo element) {
        Optional enclosingType = element.enclosingType();
        if (enclosingType.isEmpty()) {
            throw new CodegenException("Element " + String.valueOf(element) + " does not have an enclosing type", element.originatingElementValue());
        }
        return (TypeName)enclosingType.get();
    }

    private void addGauges(RegistryRoundContext roundContext, Map<TypeName, List<Gauge>> gaugesByType) {
        Collection elements = roundContext.annotatedElements(MetricsTypes.ANNOTATION_GAUGE);
        for (TypedElementInfo element : elements) {
            TypeName enclosingType = this.enclosingType(element);
            List allGauges = gaugesByType.computeIfAbsent(enclosingType, k -> new ArrayList());
            this.processGauge(roundContext, allGauges, enclosingType, element);
        }
    }

    private void processGauge(RegistryRoundContext roundContext, List<Gauge> allGauges, TypeName enclosingType, TypedElementInfo element) {
        String methodName = element.elementName();
        Annotation annotation = element.annotation(MetricsTypes.ANNOTATION_GAUGE);
        String scope = MetricsExtension.scope(annotation);
        String description = MetricsExtension.description(annotation, MetricsTypes.ANNOTATION_GAUGE, enclosingType, element);
        String unit = annotation.stringValue("unit").orElse("none");
        String gaugeName = MetricsExtension.name(annotation, enclosingType, element);
        List<Tag> tags = MetricsExtension.tags(roundContext, enclosingType, element, annotation);
        TypeName typeName = element.typeName();
        allGauges.add(new Gauge(methodName, typeName, gaugeName, description, unit, scope, tags));
    }

    record Tag(String key, String value) {
    }

    record Gauge(String methodName, TypeName returnType, String name, String description, String unit, String scope, List<Tag> tags) {
    }
}

