/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.metrics;

import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.metrics.MetricsExtension;
import io.helidon.declarative.codegen.metrics.MetricsTypes;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.List;

class GaugeHandler {
    private final RegistryRoundContext ctx;

    GaugeHandler(RegistryRoundContext ctx) {
        this.ctx = ctx;
    }

    void handle(TypeInfo typeInfo, List<MetricsExtension.Gauge> gauges) {
        TypeName serviceType = typeInfo.typeName();
        String className = serviceType.className() + "__GaugeRegistrar";
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(serviceType.packageName())).className(className)).build();
        Annotation runLevel = ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_RUN_LEVEL)).putValue("value", (Object)120.0)).build();
        ClassModel.Builder classModel = ((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)MetricsExtension.GENERATOR, (TypeName)MetricsExtension.GENERATOR, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)MetricsExtension.GENERATOR, (TypeName)MetricsExtension.GENERATOR, (TypeName)generatedType, (String)"0", (String)""))).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addAnnotation(runLevel)).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        typeInfo.findAnnotation(DeclarativeTypes.WEIGHT).ifPresent(x$0 -> {
            ClassModel.Builder cfr_ignored_0 = (ClassModel.Builder)classModel.addAnnotation(x$0);
        });
        this.addConstructorAndFields(classModel, serviceType, gauges.size());
        this.addPostConstruct(classModel, gauges);
        this.addPreDestroy(classModel, gauges.size());
        this.addToString(classModel, serviceType);
        this.ctx.addGeneratedType(generatedType, classModel, MetricsExtension.GENERATOR, new Object[0]);
    }

    private void addToString(ClassModel.Builder classModel, TypeName serviceType) {
        classModel.addMethod(toString -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)toString.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("toString")).addAnnotation(Annotations.OVERRIDE)).addContent("return \"Gauge Registrar for ")).addContent(serviceType.fqName())).addContentLine("\";"));
    }

    private void addPreDestroy(ClassModel.Builder classModel, int gaugeCount) {
        Method.Builder preDestroy = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_PRE_DESTROY))).name("preDestroy")).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        preDestroy.addContentLine("var meters = meterRegistrySupplier.get();");
        for (int i = 0; i < gaugeCount; ++i) {
            ((Method.Builder)((Method.Builder)preDestroy.addContent("meters.remove(this.gauge_")).addContent(String.valueOf(i))).addContentLine(");");
        }
        classModel.addMethod(preDestroy);
    }

    private void addPostConstruct(ClassModel.Builder classModel, List<MetricsExtension.Gauge> gauges) {
        Method.Builder postConstruct = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_POST_CONSTRUCT))).name("postConstruct")).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        ((Method.Builder)postConstruct.addContentLine("var meters = meterRegistrySupplier.get();")).addContentLine();
        for (int i = 0; i < gauges.size(); ++i) {
            MetricsExtension.Gauge gauge = gauges.get(i);
            this.addRegisterGauge(postConstruct, gauge, i);
        }
        classModel.addMethod(postConstruct);
    }

    private void addRegisterGauge(Method.Builder postConstruct, MetricsExtension.Gauge gauge, int index) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)postConstruct.addContent("this.")).addContent("gauge_" + index)).addContent(" = meters.getOrCreate(")).addContent(MetricsTypes.GAUGE)).addContent(".builder(")).addContentLiteral(gauge.name())).addContent(", () -> serviceSupplier.get().")).addContent(gauge.methodName())).addContentLine("())")).increaseContentPadding()).increaseContentPadding()).addContent(".description(")).addContentLiteral(gauge.description())).addContentLine(")")).addContent(".scope(")).addContentLiteral(gauge.scope())).addContentLine(")")).addContent(".baseUnit(")).addContentLiteral(gauge.unit())).addContentLine(")");
        MetricsExtension.addTagsToBuilder(postConstruct, gauge.tags());
        ((Method.Builder)((Method.Builder)postConstruct.decreaseContentPadding()).decreaseContentPadding()).addContentLine(");");
    }

    private void addConstructorAndFields(ClassModel.Builder classModel, TypeName serviceType, int gaugesCount) {
        TypeName serviceSupplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(serviceType)).build();
        TypeName meterRegistrySupplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(MetricsTypes.METER_REGISTRY)).build();
        ((ClassModel.Builder)classModel.addField(service -> service.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(serviceSupplierType).name("serviceSupplier"))).addField(meterRegistry -> ((Field.Builder)meterRegistry.accessModifier(AccessModifier.PRIVATE).isFinal(true).name("meterRegistrySupplier")).type(meterRegistrySupplierType));
        int i = 0;
        while (i < gaugesCount) {
            int index = i++;
            classModel.addField(service -> service.accessModifier(AccessModifier.PRIVATE).isVolatile(true).type(MetricsTypes.GAUGE).name("gauge_" + index));
        }
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(meterRegistry -> ((Parameter.Builder)meterRegistry.name("meterRegistrySupplier")).type(meterRegistrySupplierType))).addParameter(service -> service.type(serviceSupplierType).name("serviceSupplier"))).addContentLine("this.meterRegistrySupplier = meterRegistrySupplier;")).addContentLine("this.serviceSupplier = serviceSupplier;"));
    }
}

