/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.CodegenValidator;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtHandler;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.time.Duration;
import java.util.function.Predicate;

final class TimeoutHandler
extends FtHandler {
    TimeoutHandler(RegistryCodegenContext ctx) {
        super(ctx, FtTypes.TIMEOUT_ANNOTATION);
    }

    @Override
    void process(RegistryRoundContext roundContext, TypeInfo enclosingType, TypedElementInfo element, Annotation annotation, TypeName generatedType, ClassModel.Builder classModel) {
        TypeName enclosingTypeName = enclosingType.typeName();
        ((ClassModel.Builder)classModel.superType(FtTypes.TIMEOUT_GENERATED_METHOD)).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(DeclarativeTypes.WEIGHT)).putValue("value", (Object)40.0)).build());
        this.timeoutBody(classModel, enclosingTypeName, element, generatedType, element.elementName(), annotation);
        this.addType(roundContext, generatedType, classModel, enclosingTypeName, element);
    }

    private void timeoutBody(ClassModel.Builder classModel, TypeName enclosingTypeName, TypedElementInfo element, TypeName generatedType, String methodName, Annotation annotation) {
        classModel.addField(timeout -> timeout.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(FtTypes.TIMEOUT).name("timeout"));
        String name = annotation.stringValue("name").filter(Predicate.not(String::isBlank)).orElse(null);
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        if (name == null) {
            ctr.addContentLine("this.timeout = produceTimeout();");
        } else {
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addParameter(namedTimeout -> ((Parameter.Builder)namedTimeout.name("namedTimeout")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(FtTypes.TIMEOUT)).build()).addAnnotation(this.namedAnnotation(name)))).addContent("this.timeout = namedTimeout.orElseGet(")).addContent(generatedType)).addContentLine("::produceTimeout);");
        }
        classModel.addConstructor(ctr);
        classModel.addMethod(timeout -> ((Method.Builder)((Method.Builder)((Method.Builder)timeout.name("timeout")).addAnnotation(Annotations.OVERRIDE)).returnType(FtTypes.TIMEOUT).accessModifier(AccessModifier.PROTECTED)).addContentLine("return timeout;"));
        String customName = name == null ? enclosingTypeName.fqName() + "." + element.signature().text() : name + "-" + enclosingTypeName.fqName() + "." + element.signature().text();
        classModel.addMethod(produceTimeout -> ((Method.Builder)((Method.Builder)produceTimeout.accessModifier(AccessModifier.PRIVATE)).isStatic(true).returnType(FtTypes.TIMEOUT).name("produceTimeout")).update(builder -> this.produceTimeoutMethodBody(enclosingTypeName, element, (Method.Builder)builder, annotation, customName)));
    }

    private void produceTimeoutMethodBody(TypeName typeName, TypedElementInfo element, Method.Builder builder, Annotation annotation, String customName) {
        String timeout = CodegenValidator.validateDuration((TypeName)typeName, (TypedElementInfo)element, (TypeName)FtTypes.TIMEOUT_ANNOTATION, (String)"time", (String)annotation.stringValue("time").orElse("PT10S"));
        boolean currentThread = annotation.booleanValue("currentThread").orElse(false);
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("return ")).addContent(FtTypes.TIMEOUT)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".name(\"")).addContent(customName)).addContentLine("\")")).addContent(".timeout(")).addContent(Duration.class)).addContent(".parse(\"")).addContent(timeout)).addContentLine("\"))")).addContent(".currentThread(")).addContent(String.valueOf(currentThread))).addContentLine(")")).addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
    }
}

