/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.CodegenValidator;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtHandler;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.time.Duration;
import java.util.function.Predicate;

final class RetryHandler
extends FtHandler {
    RetryHandler(RegistryCodegenContext ctx) {
        super(ctx, FtTypes.RETRY_ANNOTATION);
    }

    @Override
    void process(RegistryRoundContext roundContext, TypeInfo enclosingType, TypedElementInfo element, Annotation annotation, TypeName generatedType, ClassModel.Builder classModel) {
        TypeName enclosingTypeName = enclosingType.typeName();
        ((ClassModel.Builder)classModel.superType(FtTypes.RETRY_GENERATED_METHOD)).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(DeclarativeTypes.WEIGHT)).putValue("value", (Object)10.0)).build());
        this.retryBody(classModel, enclosingTypeName, element, generatedType, element.elementName(), annotation);
        this.addType(roundContext, generatedType, classModel, enclosingTypeName, element);
    }

    private void retryBody(ClassModel.Builder classModel, TypeName enclosingTypeName, TypedElementInfo element, TypeName generatedType, String methodName, Annotation annotation) {
        this.addErrorChecker(classModel, annotation, false);
        classModel.addField(retry -> retry.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(FtTypes.RETRY).name("retry"));
        String name = annotation.stringValue("name").filter(Predicate.not(String::isBlank)).orElse(null);
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        if (name == null) {
            ctr.addContentLine("this.retry = produceRetry();");
        } else {
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addParameter(namedRetry -> ((Parameter.Builder)namedRetry.name("namedRetry")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(FtTypes.RETRY)).build()).addAnnotation(this.namedAnnotation(name)))).addContent("this.retry = namedRetry.orElseGet(")).addContent(generatedType)).addContentLine("::produceRetry);");
        }
        classModel.addConstructor(ctr);
        classModel.addMethod(retry -> ((Method.Builder)((Method.Builder)((Method.Builder)retry.name("retry")).addAnnotation(Annotations.OVERRIDE)).returnType(FtTypes.RETRY).accessModifier(AccessModifier.PROTECTED)).addContentLine("return retry;"));
        String customName = name == null ? enclosingTypeName.fqName() + "." + element.signature().text() : name + "-" + enclosingTypeName.fqName() + "." + element.signature().text();
        classModel.addMethod(produceRetry -> ((Method.Builder)((Method.Builder)produceRetry.accessModifier(AccessModifier.PRIVATE)).isStatic(true).returnType(FtTypes.RETRY).name("produceRetry")).update(builder -> this.produceRetryMethodBody(enclosingTypeName, element, (Method.Builder)builder, annotation, customName)));
    }

    private void produceRetryMethodBody(TypeName typeName, TypedElementInfo element, Method.Builder builder, Annotation annotation, String customName) {
        int calls = annotation.intValue("calls").orElse(3);
        String delayDuration = CodegenValidator.validateDuration((TypeName)typeName, (TypedElementInfo)element, (TypeName)FtTypes.RETRY_ANNOTATION, (String)"delay", (String)annotation.stringValue("delay").orElse("PT0.2S"));
        double delayFactor = annotation.doubleValue("delayFactor").orElse(-1.0);
        String jitterDuration = CodegenValidator.validateDuration((TypeName)typeName, (TypedElementInfo)element, (TypeName)FtTypes.RETRY_ANNOTATION, (String)"jitter", (String)annotation.stringValue("jitter").orElse("PT-1S"));
        String overallTimeoutDuration = CodegenValidator.validateDuration((TypeName)typeName, (TypedElementInfo)element, (TypeName)FtTypes.RETRY_ANNOTATION, (String)"overallTimeout", (String)annotation.stringValue("overallTimeout").orElse("PT1S"));
        ((Method.Builder)((Method.Builder)builder.addContent("var policy = ")).addContent(FtTypes.RETRY)).addContent(".");
        if (jitterDuration.equals("PT-1S") || delayFactor > 0.0) {
            delayFactor = delayFactor > 0.0 ? delayFactor : 2.0;
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContentLine("DelayingRetryPolicy.builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".delayFactor(")).addContent(String.valueOf(delayFactor))).addContentLine(")");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContentLine("JitterRetryPolicy.builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".jitter(")).addContent(Duration.class)).addContent(".parse(\"")).addContent(jitterDuration)).addContentLine("\"))");
        }
        ((Method.Builder)((Method.Builder)builder.addContent(".calls(")).addContent(String.valueOf(calls))).addContentLine(")");
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(".delay(")).addContent(Duration.class)).addContent(".parse(\"")).addContent(delayDuration)).addContentLine("\"))");
        ((Method.Builder)((Method.Builder)builder.addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
        builder.addContentLine("");
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("return ")).addContent(FtTypes.RETRY_CONFIG)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContentLine(".applyOn(APPLY_ON)")).addContentLine(".skipOn(SKIP_ON)")).addContentLine(".retryPolicy(policy)")).addContent(".overallTimeout(")).addContent(Duration.class)).addContent(".parse(\"")).addContent(overallTimeoutDuration)).addContentLine("\"))")).addContent(".name(\"")).addContent(customName)).addContentLine("\")")).addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
    }
}

