/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtHandler;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.function.Predicate;

final class AsyncHandler
extends FtHandler {
    private static final TypeName OPTIONAL_EXECUTOR_SERVICE = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(DeclarativeTypes.EXECUTOR_SERVICE)).build();

    AsyncHandler(RegistryCodegenContext ctx) {
        super(ctx, FtTypes.ASYNC_ANNOTATION);
    }

    @Override
    void process(RegistryRoundContext roundContext, TypeInfo enclosingType, TypedElementInfo element, Annotation annotation, TypeName generatedType, ClassModel.Builder classModel) {
        TypeName enclosingTypeName = enclosingType.typeName();
        ((ClassModel.Builder)classModel.superType(FtTypes.ASYNC_GENERATED_METHOD)).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(DeclarativeTypes.WEIGHT)).putValue("value", (Object)50.0)).build());
        this.asyncBody(classModel, enclosingTypeName, element, generatedType, annotation);
        this.addType(roundContext, generatedType, classModel, enclosingTypeName, element);
    }

    private void asyncBody(ClassModel.Builder classModel, TypeName enclosingTypeName, TypedElementInfo element, TypeName generatedType, Annotation annotation) {
        boolean hasExecutorName;
        classModel.addField(async -> async.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(FtTypes.ASYNC).name("async"));
        String name = annotation.stringValue("name").filter(Predicate.not(String::isBlank)).orElse(null);
        String executorName = annotation.stringValue("executorName").filter(Predicate.not(String::isBlank)).orElse(null);
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        boolean hasName = name != null;
        boolean bl = hasExecutorName = executorName != null;
        if (hasName) {
            ctr.addParameter(namedAsync -> ((Parameter.Builder)namedAsync.name("namedAsync")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(FtTypes.ASYNC)).build()).addAnnotation(this.namedAnnotation(name)));
        }
        if (hasExecutorName) {
            ctr.addParameter(namedExecutor -> ((Parameter.Builder)namedExecutor.name("namedExecutor")).type(OPTIONAL_EXECUTOR_SERVICE).addAnnotation(this.namedAnnotation(executorName)));
        }
        if (hasName) {
            ctr.addContent("this.async = namedAsync.orElseGet(");
            if (hasExecutorName) {
                ctr.addContent("() -> produceAsync(namedExecutor));");
            } else {
                ((Constructor.Builder)ctr.addContent(generatedType)).addContentLine("::produceAsync);");
            }
        } else if (hasExecutorName) {
            ctr.addContent("this.async = produceAsync(namedExecutor);");
        } else {
            ctr.addContent("this.async = produceAsync();");
        }
        classModel.addConstructor(ctr);
        classModel.addMethod(retry -> ((Method.Builder)((Method.Builder)((Method.Builder)retry.name("async")).addAnnotation(Annotations.OVERRIDE)).returnType(FtTypes.ASYNC).accessModifier(AccessModifier.PROTECTED)).addContentLine("return async;"));
        String customName = name == null ? enclosingTypeName.fqName() + "." + element.signature().text() : name + "-" + enclosingTypeName.fqName() + "." + element.signature().text();
        classModel.addMethod(produceAsync -> ((Method.Builder)((Method.Builder)((Method.Builder)produceAsync.accessModifier(AccessModifier.PRIVATE)).isStatic(true).returnType(FtTypes.ASYNC).name("produceAsync")).update(builder -> {
            if (hasExecutorName) {
                builder.addParameter(namedExecutor -> namedExecutor.type(OPTIONAL_EXECUTOR_SERVICE).name("namedExecutor"));
            }
        })).update(builder -> this.produceAsyncMethodBody((Method.Builder)builder, customName, hasExecutorName)));
    }

    private void produceAsyncMethodBody(Method.Builder builder, String customName, boolean hasExecutorName) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("return ")).addContent(FtTypes.ASYNC)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".name(\"")).addContent(customName)).addContentLine("\")")).update(methodBuilder -> {
            if (hasExecutorName) {
                builder.addContentLine(".update(builder -> namedExecutor.ifPresent(builder::executor))");
            }
        })).addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
    }
}

