/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.model.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.declarative.codegen.model.http.RestEndpoint;
import io.helidon.declarative.codegen.model.http.ServerEndpointBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.declarative.codegen.model.http.ServerEndpointBlueprint")
public interface ServerEndpoint
extends ServerEndpointBlueprint,
Prototype.Api,
RestEndpoint {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServerEndpoint instance) {
        return (Builder)ServerEndpoint.builder().from(instance);
    }

    public static ServerEndpoint create() {
        return ServerEndpoint.builder().buildPrototype();
    }

    @Override
    public Optional<String> listener();

    @Override
    public boolean listenerRequired();

    public static class Builder
    extends BuilderBase<Builder, ServerEndpoint>
    implements io.helidon.common.Builder<Builder, ServerEndpoint> {
        private Builder() {
        }

        public ServerEndpoint buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ServerEndpointImpl(this);
        }

        public ServerEndpoint build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ServerEndpoint>
    extends RestEndpoint.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean listenerRequired = false;
        private String listener;

        protected BuilderBase() {
        }

        public BUILDER from(ServerEndpoint prototype) {
            super.from(prototype);
            this.listener(prototype.listener());
            this.listenerRequired(prototype.listenerRequired());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from((RestEndpoint.BuilderBase<?, ?>)builder);
            builder.listener().ifPresent(this::listener);
            this.listenerRequired(builder.listenerRequired());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearListener() {
            this.listener = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER listener(String listener) {
            Objects.requireNonNull(listener);
            this.listener = listener;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER listenerRequired(boolean listenerRequired) {
            this.listenerRequired = listenerRequired;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> listener() {
            return Optional.ofNullable(this.listener);
        }

        public boolean listenerRequired() {
            return this.listenerRequired;
        }

        @Override
        public String toString() {
            return "ServerEndpointBuilder{listener=" + this.listener + ",listenerRequired=" + this.listenerRequired + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER listener(Optional<String> listener) {
            Objects.requireNonNull(listener);
            this.listener = listener.orElse(this.listener);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ServerEndpointImpl
        extends RestEndpoint.BuilderBase.RestEndpointImpl
        implements ServerEndpoint {
            private final boolean listenerRequired;
            private final Optional<String> listener;

            protected ServerEndpointImpl(BuilderBase<?, ?> builder) {
                super((RestEndpoint.BuilderBase<?, ?>)builder);
                this.listener = builder.listener().map(Function.identity());
                this.listenerRequired = builder.listenerRequired();
            }

            @Override
            public Optional<String> listener() {
                return this.listener;
            }

            @Override
            public boolean listenerRequired() {
                return this.listenerRequired;
            }

            @Override
            public String toString() {
                return "ServerEndpoint{listener=" + String.valueOf(this.listener) + ",listenerRequired=" + this.listenerRequired + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServerEndpoint)) {
                    return false;
                }
                ServerEndpoint other = (ServerEndpoint)o;
                return super.equals(other) && Objects.equals(this.listener, other.listener()) && this.listenerRequired == other.listenerRequired();
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.listener, this.listenerRequired);
            }
        }
    }
}

