/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.model.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.declarative.codegen.model.http.HttpAnnotated;
import io.helidon.declarative.codegen.model.http.RestEndpointBlueprint;
import io.helidon.declarative.codegen.model.http.RestMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.declarative.codegen.model.http.RestEndpointBlueprint")
public interface RestEndpoint
extends RestEndpointBlueprint,
Prototype.Api,
HttpAnnotated {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RestEndpoint instance) {
        return (Builder)RestEndpoint.builder().from(instance);
    }

    @Override
    public List<RestMethod> methods();

    public static class Builder
    extends BuilderBase<Builder, RestEndpoint>
    implements io.helidon.common.Builder<Builder, RestEndpoint> {
        private Builder() {
        }

        public RestEndpoint buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.RestEndpointImpl(this);
        }

        public RestEndpoint build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends RestEndpoint>
    extends HttpAnnotated.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<RestMethod> methods = new ArrayList<RestMethod>();
        private boolean isMethodsMutated;

        protected BuilderBase() {
        }

        public BUILDER from(RestEndpoint prototype) {
            super.from(prototype);
            if (!this.isMethodsMutated) {
                this.methods.clear();
            }
            this.addMethods(prototype.methods());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from((HttpAnnotated.BuilderBase<?, ?>)builder);
            if (this.isMethodsMutated) {
                if (builder.isMethodsMutated) {
                    this.addMethods(builder.methods());
                }
            } else {
                this.methods(builder.methods());
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMethods() {
            this.isMethodsMutated = true;
            this.methods.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER methods(List<? extends RestMethod> methods) {
            Objects.requireNonNull(methods);
            this.isMethodsMutated = true;
            this.methods.clear();
            this.methods.addAll(methods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMethods(List<? extends RestMethod> methods) {
            Objects.requireNonNull(methods);
            this.isMethodsMutated = true;
            this.methods.addAll(methods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMethod(RestMethod method) {
            Objects.requireNonNull(method);
            this.methods.add(method);
            this.isMethodsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMethod(Consumer<RestMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RestMethod.Builder builder = RestMethod.builder();
            consumer.accept(builder);
            this.addMethod(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<RestMethod> methods() {
            return this.methods;
        }

        @Override
        public String toString() {
            return "RestEndpointBuilder{methods=" + String.valueOf(this.methods) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        protected static class RestEndpointImpl
        extends HttpAnnotated.BuilderBase.HttpAnnotatedImpl
        implements RestEndpoint {
            private final List<RestMethod> methods;

            protected RestEndpointImpl(BuilderBase<?, ?> builder) {
                super((HttpAnnotated.BuilderBase<?, ?>)builder);
                this.methods = List.copyOf(builder.methods());
            }

            @Override
            public List<RestMethod> methods() {
                return this.methods;
            }

            @Override
            public String toString() {
                return "RestEndpoint{methods=" + String.valueOf(this.methods) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RestEndpoint)) {
                    return false;
                }
                RestEndpoint other = (RestEndpoint)o;
                return super.equals(other) && Objects.equals(this.methods, other.methods());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.methods);
            }
        }
    }
}

