/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.model.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.declarative.codegen.model.http.ClientEndpointBlueprint;
import io.helidon.declarative.codegen.model.http.RestEndpoint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.declarative.codegen.model.http.ClientEndpointBlueprint")
public interface ClientEndpoint
extends ClientEndpointBlueprint,
Prototype.Api,
RestEndpoint {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientEndpoint instance) {
        return (Builder)ClientEndpoint.builder().from(instance);
    }

    @Override
    public String uri();

    @Override
    public String configKey();

    @Override
    public Optional<String> clientName();

    public static class Builder
    extends BuilderBase<Builder, ClientEndpoint>
    implements io.helidon.common.Builder<Builder, ClientEndpoint> {
        private Builder() {
        }

        public ClientEndpoint buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ClientEndpointImpl(this);
        }

        public ClientEndpoint build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ClientEndpoint>
    extends RestEndpoint.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private String clientName;
        private String configKey;
        private String uri;

        protected BuilderBase() {
        }

        public BUILDER from(ClientEndpoint prototype) {
            super.from(prototype);
            this.uri(prototype.uri());
            this.configKey(prototype.configKey());
            this.clientName(prototype.clientName());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from((RestEndpoint.BuilderBase<?, ?>)builder);
            builder.uri().ifPresent(this::uri);
            builder.configKey().ifPresent(this::configKey);
            builder.clientName().ifPresent(this::clientName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER uri(String uri) {
            Objects.requireNonNull(uri);
            this.uri = uri;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configKey(String configKey) {
            Objects.requireNonNull(configKey);
            this.configKey = configKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearClientName() {
            this.clientName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clientName(String clientName) {
            Objects.requireNonNull(clientName);
            this.clientName = clientName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> uri() {
            return Optional.ofNullable(this.uri);
        }

        public Optional<String> configKey() {
            return Optional.ofNullable(this.configKey);
        }

        public Optional<String> clientName() {
            return Optional.ofNullable(this.clientName);
        }

        @Override
        public String toString() {
            return "ClientEndpointBuilder{uri=" + this.uri + ",configKey=" + this.configKey + ",clientName=" + this.clientName + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.uri == null) {
                collector.fatal(this.getClass(), "Property \"uri\" must not be null, but not set");
            }
            if (this.configKey == null) {
                collector.fatal(this.getClass(), "Property \"configKey\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER clientName(Optional<String> clientName) {
            Objects.requireNonNull(clientName);
            this.clientName = clientName.orElse(this.clientName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ClientEndpointImpl
        extends RestEndpoint.BuilderBase.RestEndpointImpl
        implements ClientEndpoint {
            private final Optional<String> clientName;
            private final String configKey;
            private final String uri;

            protected ClientEndpointImpl(BuilderBase<?, ?> builder) {
                super((RestEndpoint.BuilderBase<?, ?>)builder);
                this.uri = builder.uri().get();
                this.configKey = builder.configKey().get();
                this.clientName = builder.clientName().map(Function.identity());
            }

            @Override
            public String uri() {
                return this.uri;
            }

            @Override
            public String configKey() {
                return this.configKey;
            }

            @Override
            public Optional<String> clientName() {
                return this.clientName;
            }

            @Override
            public String toString() {
                return "ClientEndpoint{uri=" + this.uri + ",configKey=" + this.configKey + ",clientName=" + String.valueOf(this.clientName) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClientEndpoint)) {
                    return false;
                }
                ClientEndpoint other = (ClientEndpoint)o;
                return super.equals(other) && Objects.equals(this.uri, other.uri()) && Objects.equals(this.configKey, other.configKey()) && Objects.equals(this.clientName, other.clientName());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.uri, this.configKey, this.clientName);
            }
        }
    }
}

