/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientProviderLoader;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.spi.DbClientBuilder;
import io.helidon.dbclient.spi.DbClientProvider;
import io.helidon.dbclient.spi.DbClientServiceProvider;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public interface DbClient
extends AutoCloseable {
    public static final String MAPPING_QUALIFIER = "dbclient";

    public String dbType();

    public DbExecute execute();

    public DbTransaction transaction();

    public <C> C unwrap(Class<C> var1);

    @Override
    public void close();

    public static DbClient create(Config config) {
        return DbClient.builder(config).build();
    }

    public static Builder builder() {
        DbClientProvider provider = DbClientProviderLoader.first();
        if (null == provider) {
            throw new DbClientException("No DbSource defined on classpath/module path. An implementation of io.helidon.dbclient.spi.DbClientProvider is required  to access a DB");
        }
        return DbClient.builder(provider);
    }

    public static Builder builder(DbClientProvider provider) {
        return new Builder(provider);
    }

    public static Builder builder(String providerName) {
        return DbClientProviderLoader.get(providerName).map(DbClient::builder).orElseThrow(() -> new DbClientException(String.format("No DbClientProvider with name \"%s\" was found on the classpath/module path. Available names: %s", providerName, Arrays.toString(DbClientProviderLoader.names()))));
    }

    public static Builder builder(Config dbConfig) {
        return dbConfig.get("source").asString().map(DbClient::builder).orElseGet(DbClient::builder).config(dbConfig);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, DbClient> {
        private final DbClientBuilder<?> clientBuilder;
        private Config config = Config.empty();
        private final HelidonServiceLoader.Builder<DbClientServiceProvider> clientServiceProviders = HelidonServiceLoader.builder(ServiceLoader.load(DbClientServiceProvider.class));

        private Builder(DbClientProvider dbClientProvider) {
            this.clientBuilder = dbClientProvider.builder();
        }

        public DbClient build() {
            Config servicesConfig = this.config.get("services");
            List providers = this.clientServiceProviders.build().asList();
            for (DbClientServiceProvider provider : providers) {
                Config providerConfig = servicesConfig.get(provider.configKey());
                if (!providerConfig.exists()) continue;
                provider.create(providerConfig).forEach(this::addService);
            }
            return (DbClient)this.clientBuilder.build();
        }

        public Builder config(Config config) {
            this.clientBuilder.config(config);
            this.config = config;
            return this;
        }

        public Builder statements(DbStatements statements) {
            this.clientBuilder.statements(statements);
            return this;
        }

        public Builder mapperProvider(DbMapperProvider provider) {
            this.clientBuilder.addMapperProvider(provider);
            return this;
        }

        public Builder mapperManager(MapperManager manager) {
            this.clientBuilder.mapperManager(manager);
            return this;
        }

        public Builder addService(DbClientService clientService) {
            this.clientBuilder.addService(clientService);
            return this;
        }

        public Builder addService(Supplier<? extends DbClientService> clientServiceSupplier) {
            this.clientBuilder.addService(clientServiceSupplier.get());
            return this;
        }
    }
}

