/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public abstract class DbExecuteBase
implements DbExecute {
    private final DbClientContext context;

    protected DbExecuteBase(DbClientContext context) {
        this.context = context;
    }

    protected String statementText(String name) {
        return this.context.statements().statement(name);
    }

    protected DbClientContext context() {
        return this.context;
    }

    protected <C extends DbClientContext> C context(Class<C> cls) {
        return (C)((DbClientContext)cls.cast(this.context));
    }

    @Override
    public DbStatementQuery createNamedQuery(String statementName) {
        return this.createNamedQuery(statementName, this.statementText(statementName));
    }

    @Override
    public DbStatementQuery createQuery(String statement) {
        return this.createNamedQuery(this.generateName(DbStatementType.QUERY, statement), statement);
    }

    @Override
    public DbStatementGet createNamedGet(String statementName) {
        return this.createNamedGet(statementName, this.statementText(statementName));
    }

    @Override
    public DbStatementGet createGet(String statement) {
        return this.createNamedGet(this.generateName(DbStatementType.GET, statement), statement);
    }

    @Override
    public DbStatementDml createNamedInsert(String statementName) {
        return this.createNamedInsert(statementName, this.statementText(statementName));
    }

    @Override
    public DbStatementDml createInsert(String statement) {
        return this.createNamedInsert(this.generateName(DbStatementType.INSERT, statement), statement);
    }

    @Override
    public DbStatementDml createNamedUpdate(String statementName) {
        return this.createNamedUpdate(statementName, this.statementText(statementName));
    }

    @Override
    public DbStatementDml createUpdate(String statement) {
        return this.createNamedUpdate(this.generateName(DbStatementType.UPDATE, statement), statement);
    }

    @Override
    public DbStatementDml createNamedDelete(String statementName) {
        return this.createNamedDelete(statementName, this.statementText(statementName));
    }

    @Override
    public DbStatementDml createDelete(String statement) {
        return this.createNamedDelete(this.generateName(DbStatementType.DELETE, statement), statement);
    }

    @Override
    public DbStatementDml createNamedDmlStatement(String statementName) {
        return this.createNamedDmlStatement(statementName, this.statementText(statementName));
    }

    @Override
    public DbStatementDml createDmlStatement(String statement) {
        return this.createNamedDmlStatement(this.generateName(DbStatementType.DML, statement), statement);
    }

    protected String generateName(DbStatementType type, String statement) {
        String sha256;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(statement.getBytes(StandardCharsets.UTF_8));
            sha256 = Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException ignored) {
            return "sha256failed";
        }
        return type.prefix() + "_" + sha256;
    }
}

