/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.AutoClosingHandler;
import io.helidon.dbclient.AutoClosingIntStream;
import io.helidon.dbclient.AutoClosingLongStream;
import io.helidon.dbclient.AutoClosingStream;
import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

class AutoClosingDoubleStream
implements DoubleStream {
    private final DoubleStream delegate;
    private final Runnable closeHandler;

    private AutoClosingDoubleStream(DoubleStream delegate, Runnable closeHandler) {
        this.delegate = delegate;
        this.closeHandler = closeHandler;
    }

    static DoubleStream decorate(DoubleStream stream, Runnable closeHandler) {
        if (stream instanceof AutoClosingDoubleStream) {
            return stream;
        }
        return new AutoClosingDoubleStream(stream, AutoClosingHandler.decorate(closeHandler));
    }

    @Override
    public void forEach(DoubleConsumer action) {
        try {
            this.delegate.forEach(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        try {
            this.delegate.forEachOrdered(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public double[] toArray() {
        try {
            double[] dArray = this.delegate.toArray();
            return dArray;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        try {
            double d = this.delegate.reduce(identity, op);
            return d;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        try {
            OptionalDouble optionalDouble = this.delegate.reduce(op);
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        try {
            R r = this.delegate.collect(supplier, accumulator, combiner);
            return r;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public double sum() {
        try {
            double d = this.delegate.sum();
            return d;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble min() {
        try {
            OptionalDouble optionalDouble = this.delegate.min();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble max() {
        try {
            OptionalDouble optionalDouble = this.delegate.max();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public long count() {
        try {
            long l = this.delegate.count();
            return l;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble average() {
        try {
            OptionalDouble optionalDouble = this.delegate.average();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        try {
            DoubleSummaryStatistics doubleSummaryStatistics = this.delegate.summaryStatistics();
            return doubleSummaryStatistics;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        try {
            boolean bl = this.delegate.anyMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        try {
            boolean bl = this.delegate.allMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        try {
            boolean bl = this.delegate.noneMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble findFirst() {
        try {
            OptionalDouble optionalDouble = this.delegate.findFirst();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble findAny() {
        try {
            OptionalDouble optionalDouble = this.delegate.findAny();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        return AutoClosingDoubleStream.decorate(this.delegate.filter(predicate), this.closeHandler);
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.map(mapper), this.closeHandler);
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return AutoClosingStream.decorate(this.delegate.mapToObj(mapper), this.closeHandler);
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        return AutoClosingIntStream.decorate(this.delegate.mapToInt(mapper), this.closeHandler);
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        return AutoClosingLongStream.decorate(this.delegate.mapToLong(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.flatMap(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream mapMulti(DoubleStream.DoubleMapMultiConsumer mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.mapMulti(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream distinct() {
        return AutoClosingDoubleStream.decorate(this.delegate.distinct(), this.closeHandler);
    }

    @Override
    public DoubleStream sorted() {
        return AutoClosingDoubleStream.decorate(this.delegate.sorted(), this.closeHandler);
    }

    @Override
    public DoubleStream peek(DoubleConsumer action) {
        return AutoClosingDoubleStream.decorate(this.delegate.peek(action), this.closeHandler);
    }

    @Override
    public DoubleStream limit(long maxSize) {
        return AutoClosingDoubleStream.decorate(this.delegate.limit(maxSize), this.closeHandler);
    }

    @Override
    public DoubleStream skip(long n) {
        return AutoClosingDoubleStream.decorate(this.delegate.skip(n), this.closeHandler);
    }

    @Override
    public DoubleStream takeWhile(DoublePredicate predicate) {
        return AutoClosingDoubleStream.decorate(this.delegate.takeWhile(predicate), this.closeHandler);
    }

    @Override
    public DoubleStream dropWhile(DoublePredicate predicate) {
        return AutoClosingDoubleStream.decorate(this.delegate.dropWhile(predicate), this.closeHandler);
    }

    @Override
    public Stream<Double> boxed() {
        return AutoClosingStream.decorate(this.delegate.boxed(), this.closeHandler);
    }

    @Override
    public DoubleStream sequential() {
        return AutoClosingDoubleStream.decorate(this.delegate.sequential(), this.closeHandler);
    }

    @Override
    public DoubleStream parallel() {
        return AutoClosingDoubleStream.decorate(this.delegate.parallel(), this.closeHandler);
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        final PrimitiveIterator.OfDouble iterator = this.delegate.iterator();
        return new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                if (iterator.hasNext()) {
                    return true;
                }
                AutoClosingDoubleStream.this.closeHandler.run();
                return false;
            }

            @Override
            public double nextDouble() {
                return iterator.nextDouble();
            }
        };
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        final Spliterator.OfDouble spliterator = this.delegate.spliterator();
        return new Spliterator.OfDouble(){

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (spliterator.tryAdvance(action)) {
                    return true;
                }
                AutoClosingDoubleStream.this.closeHandler.run();
                return false;
            }

            @Override
            public Spliterator.OfDouble trySplit() {
                return spliterator.trySplit();
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics();
            }
        };
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public DoubleStream unordered() {
        return AutoClosingDoubleStream.decorate((DoubleStream)this.delegate.unordered(), this.closeHandler);
    }

    @Override
    public DoubleStream onClose(Runnable closeHandler) {
        return AutoClosingDoubleStream.decorate((DoubleStream)this.delegate.onClose(closeHandler), this.closeHandler);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

