/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.AutoClosingDoubleStream;
import io.helidon.dbclient.AutoClosingHandler;
import io.helidon.dbclient.AutoClosingIntStream;
import io.helidon.dbclient.AutoClosingLongStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

class AutoClosingStream<T>
implements Stream<T> {
    private final Stream<T> delegate;
    private final Runnable closeHandler;

    private AutoClosingStream(Stream<T> delegate, Runnable closeHandler) {
        this.delegate = delegate;
        this.closeHandler = closeHandler;
    }

    static <T> Stream<T> decorate(Stream<T> stream) {
        return AutoClosingStream.decorate(stream, stream::close);
    }

    static <T> Stream<T> decorate(Stream<T> stream, Runnable closeHandler) {
        if (stream instanceof AutoClosingStream) {
            return stream;
        }
        return new AutoClosingStream<T>(stream, AutoClosingHandler.decorate(closeHandler));
    }

    @Override
    public Object[] toArray() {
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        try {
            A[] AArray = this.delegate.toArray(generator);
            return AArray;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        try {
            T t = this.delegate.reduce(identity, accumulator);
            return t;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        try {
            Optional<T> optional = this.delegate.reduce(accumulator);
            return optional;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        try {
            U u = this.delegate.reduce(identity, accumulator, combiner);
            return u;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        try {
            R r = this.delegate.collect(supplier, accumulator, combiner);
            return r;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        try {
            R r = this.delegate.collect(collector);
            return r;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public List<T> toList() {
        try {
            List<T> list = this.delegate.toList();
            return list;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public long count() {
        try {
            long l = this.delegate.count();
            return l;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        try {
            boolean bl = this.delegate.anyMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        try {
            boolean bl = this.delegate.allMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        try {
            boolean bl = this.delegate.noneMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public Optional<T> findFirst() {
        try {
            Optional<T> optional = this.delegate.findFirst();
            return optional;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public Optional<T> findAny() {
        try {
            Optional<T> optional = this.delegate.findAny();
            return optional;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        try {
            Optional<? super T> optional = this.delegate.min(comparator);
            return optional;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        try {
            Optional<? super T> optional = this.delegate.max(comparator);
            return optional;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        try {
            this.delegate.forEach(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        try {
            this.delegate.forEachOrdered(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return AutoClosingStream.decorate(this.delegate.filter(predicate), this.closeHandler);
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return AutoClosingStream.decorate(this.delegate.map(mapper), this.closeHandler);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return AutoClosingIntStream.decorate(this.delegate.mapToInt(mapper), this.closeHandler);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return AutoClosingLongStream.decorate(this.delegate.mapToLong(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.mapToDouble(mapper), this.closeHandler);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return AutoClosingStream.decorate(this.delegate.flatMap(mapper), this.closeHandler);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return AutoClosingIntStream.decorate(this.delegate.flatMapToInt(mapper), this.closeHandler);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return AutoClosingLongStream.decorate(this.delegate.flatMapToLong(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.flatMapToDouble(mapper), this.closeHandler);
    }

    @Override
    public <R> Stream<R> mapMulti(BiConsumer<? super T, ? super Consumer<R>> mapper) {
        return AutoClosingStream.decorate(this.delegate.mapMulti(mapper), this.closeHandler);
    }

    @Override
    public IntStream mapMultiToInt(BiConsumer<? super T, ? super IntConsumer> mapper) {
        return AutoClosingIntStream.decorate(this.delegate.mapMultiToInt(mapper), this.closeHandler);
    }

    @Override
    public LongStream mapMultiToLong(BiConsumer<? super T, ? super LongConsumer> mapper) {
        return AutoClosingLongStream.decorate(this.delegate.mapMultiToLong(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream mapMultiToDouble(BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.mapMultiToDouble(mapper), this.closeHandler);
    }

    @Override
    public Stream<T> distinct() {
        return AutoClosingStream.decorate(this.delegate.distinct(), this.closeHandler);
    }

    @Override
    public Stream<T> sorted() {
        return AutoClosingStream.decorate(this.delegate.sorted(), this.closeHandler);
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return AutoClosingStream.decorate(this.delegate.sorted(comparator), this.closeHandler);
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return AutoClosingStream.decorate(this.delegate.peek(action), this.closeHandler);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return AutoClosingStream.decorate(this.delegate.limit(maxSize), this.closeHandler);
    }

    @Override
    public Stream<T> skip(long n) {
        return AutoClosingStream.decorate(this.delegate.skip(n), this.closeHandler);
    }

    @Override
    public Stream<T> takeWhile(Predicate<? super T> predicate) {
        return AutoClosingStream.decorate(this.delegate.takeWhile(predicate), this.closeHandler);
    }

    @Override
    public Stream<T> dropWhile(Predicate<? super T> predicate) {
        return AutoClosingStream.decorate(this.delegate.dropWhile(predicate), this.closeHandler);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator iterator = this.delegate.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (iterator.hasNext()) {
                    return true;
                }
                AutoClosingStream.this.closeHandler.run();
                return false;
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        final Spliterator spliterator = this.delegate.spliterator();
        return new Spliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (spliterator.tryAdvance(action)) {
                    return true;
                }
                AutoClosingStream.this.closeHandler.run();
                return false;
            }

            @Override
            public Spliterator<T> trySplit() {
                return spliterator.trySplit();
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics();
            }
        };
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public Stream<T> sequential() {
        return AutoClosingStream.decorate((Stream)this.delegate.sequential(), this.closeHandler);
    }

    @Override
    public Stream<T> parallel() {
        return AutoClosingStream.decorate((Stream)this.delegate.parallel(), this.closeHandler);
    }

    @Override
    public Stream<T> unordered() {
        return AutoClosingStream.decorate((Stream)this.delegate.unordered(), this.closeHandler);
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return AutoClosingStream.decorate((Stream)this.delegate.onClose(closeHandler), this.closeHandler);
    }

    @Override
    public void close() {
        this.closeHandler.run();
    }
}

