/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.AutoClosingStream;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbClientServiceContextImpl;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbIndexedStatementParameters;
import io.helidon.dbclient.DbNamedStatementParameters;
import io.helidon.dbclient.DbStatement;
import io.helidon.dbclient.DbStatementParameters;
import io.helidon.dbclient.DbStatementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public abstract class DbStatementBase<S extends DbStatement<S>>
implements DbStatement<S> {
    private final DbExecuteContext context;
    private DbStatementParameters parameters;

    protected DbStatementBase(DbExecuteContext context) {
        this.context = context;
    }

    public DbExecuteContext context() {
        return this.context;
    }

    protected <C extends DbExecuteContext> C context(Class<C> cls) {
        return (C)((DbExecuteContext)cls.cast(this.context));
    }

    public DbStatementParameters parameters() {
        return this.parameters != null ? this.parameters : DbStatementParameters.UNDEFINED;
    }

    public abstract DbStatementType statementType();

    protected <T> T doExecute(BiFunction<CompletableFuture<Long>, DbClientServiceContext, T> function) {
        CompletableFuture<Void> stmtFuture = new CompletableFuture<Void>();
        CompletableFuture<Long> queryFuture = new CompletableFuture<Long>();
        queryFuture.whenComplete((r, ex) -> stmtFuture.complete(null));
        DbClientServiceContextImpl serviceContext = new DbClientServiceContextImpl(this.context, this.statementType(), stmtFuture, queryFuture, this.parameters);
        this.context().clientServices().forEach(service -> service.statement(serviceContext));
        return function.apply(queryFuture, serviceContext);
    }

    protected static <T> Stream<T> autoClose(Stream<T> stream) {
        return AutoClosingStream.decorate(stream);
    }

    @Override
    public S namedParam(Object parameters) {
        Class<?> theClass = parameters.getClass();
        this.params(this.context.dbMapperManager().toNamedParameters(parameters, theClass));
        return this.identity();
    }

    @Override
    public S indexedParam(Object parameters) {
        Class<?> theClass = parameters.getClass();
        this.params(this.context.dbMapperManager().toIndexedParameters(parameters, theClass));
        return this.identity();
    }

    @Override
    public S params(List<?> parameters) {
        parameters.forEach(this::addParam);
        return this.identity();
    }

    @Override
    public S params(Map<String, ?> parameters) {
        parameters.forEach(this::addParam);
        return this.identity();
    }

    @Override
    public S addParam(Object parameter) {
        if (this.parameters == null) {
            this.parameters = new DbIndexedStatementParameters();
        }
        this.parameters.addParam(parameter);
        return this.identity();
    }

    @Override
    public S addParam(String name, Object parameter) {
        if (this.parameters == null) {
            this.parameters = new DbNamedStatementParameters();
        }
        this.parameters.addParam(name, parameter);
        return this.identity();
    }

    @Override
    public S addParam(boolean parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(String parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(byte parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(short parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(int parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(long parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(float parameter) {
        return this.addParam(Float.valueOf(parameter));
    }

    @Override
    public S addParam(double parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(BigInteger parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(BigDecimal parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(byte[] parameter) {
        return this.addParam((Object)parameter);
    }

    @Override
    public S addParam(String name, boolean parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, String parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, byte parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, short parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, int parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, long parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, float parameter) {
        return this.addParam(name, Float.valueOf(parameter));
    }

    @Override
    public S addParam(String name, double parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, BigInteger parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, BigDecimal parameter) {
        return this.addParam(name, (Object)parameter);
    }

    @Override
    public S addParam(String name, byte[] parameter) {
        return this.addParam(name, (Object)parameter);
    }

    protected S identity() {
        return (S)this;
    }
}

