/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import java.util.concurrent.atomic.AtomicBoolean;

class AutoClosingHandler
implements Runnable {
    private final AtomicBoolean invoked = new AtomicBoolean();
    private final Runnable delegate;

    private AutoClosingHandler(Runnable delegate) {
        this.delegate = delegate;
    }

    static Runnable decorate(Runnable runnable) {
        if (runnable instanceof AutoClosingHandler) {
            return runnable;
        }
        return new AutoClosingHandler(runnable);
    }

    @Override
    public void run() {
        if (this.invoked.compareAndSet(false, true)) {
            this.delegate.run();
        }
    }
}

