/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.spi.MapperProvider;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class DbMapperProviderImpl
implements MapperProvider {
    private static final Map<Class<?>, Map<Class<?>, Mapper<?, ?>>> MAPPERS = DbMapperProviderImpl.initMappers();

    private static Map<Class<?>, Map<Class<?>, Mapper<?, ?>>> initMappers() {
        HashMap mappers = new HashMap(3);
        HashMap<Class<GregorianCalendar>, Mapper> sqlTimestampMap = new HashMap<Class<GregorianCalendar>, Mapper>(4);
        sqlTimestampMap.put(Date.class, source -> source);
        sqlTimestampMap.put(LocalDateTime.class, source -> source != null ? source.toLocalDateTime() : null);
        sqlTimestampMap.put(ZonedDateTime.class, source -> source != null ? ZonedDateTime.ofInstant(source.toInstant(), ZoneOffset.UTC) : null);
        sqlTimestampMap.put(Calendar.class, DbMapperProviderImpl::sqlTimestampToGregorianCalendar);
        sqlTimestampMap.put(GregorianCalendar.class, DbMapperProviderImpl::sqlTimestampToGregorianCalendar);
        mappers.put(Timestamp.class, Collections.unmodifiableMap(sqlTimestampMap));
        mappers.put(java.sql.Date.class, Map.of(Date.class, source -> source, LocalDate.class, source -> source != null ? source.toLocalDate() : null));
        HashMap<Class, Mapper> sqlTimeMap = new HashMap<Class, Mapper>(2);
        sqlTimeMap.put(Date.class, source -> source);
        sqlTimeMap.put(LocalTime.class, source -> source != null ? source.toLocalTime() : null);
        mappers.put(Time.class, Collections.unmodifiableMap(sqlTimeMap));
        return Collections.unmodifiableMap(mappers);
    }

    public MapperProvider.ProviderResponse mapper(Class<?> sourceClass, Class<?> targetClass, String qualifier) {
        Map<Class<?>, Mapper<?, ?>> targetMap = MAPPERS.get(sourceClass);
        if (targetMap == null) {
            return MapperProvider.ProviderResponse.unsupported();
        }
        Mapper<?, ?> mapper = targetMap.get(targetClass);
        return mapper == null ? MapperProvider.ProviderResponse.unsupported() : new MapperProvider.ProviderResponse(MapperProvider.Support.SUPPORTED, mapper);
    }

    private static GregorianCalendar sqlTimestampToGregorianCalendar(Timestamp source) {
        return source != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(source.toInstant(), ZoneOffset.UTC)) : null;
    }
}

