/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbIndexedStatementParameters;
import io.helidon.dbclient.DbNamedStatementParameters;
import io.helidon.dbclient.DbStatementParameters;
import io.helidon.dbclient.DbStatementType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class DbClientServiceContextImpl
implements DbClientServiceContext {
    private final DbExecuteContext execContext;
    private final DbStatementType stmtType;
    private final CompletionStage<Void> stmtFuture;
    private final CompletionStage<Long> queryFuture;
    private DbStatementParameters stmtParams;
    private Context context;
    private String stmt;
    private String stmtName;

    DbClientServiceContextImpl(DbExecuteContext execContext, DbStatementType stmtType, CompletionStage<Void> stmtFuture, CompletionStage<Long> queryFuture, DbStatementParameters stmtParams) {
        this.execContext = execContext;
        this.stmtType = stmtType;
        this.stmtFuture = stmtFuture;
        this.queryFuture = queryFuture;
        this.stmt = execContext.statement();
        this.stmtName = execContext.statementName();
        this.stmtParams = stmtParams;
    }

    @Override
    public Context context() {
        return this.context != null ? this.context : Contexts.context().orElseGet(Contexts::globalContext);
    }

    @Override
    public String statement() {
        return this.stmt;
    }

    @Override
    public String statementName() {
        return this.stmtName;
    }

    @Override
    public DbStatementType statementType() {
        return this.stmtType;
    }

    @Override
    public DbStatementParameters statementParameters() {
        return this.stmtParams;
    }

    @Override
    public String dbType() {
        return this.execContext.dbType();
    }

    @Override
    public CompletionStage<Void> statementFuture() {
        return this.stmtFuture;
    }

    @Override
    public CompletionStage<Long> resultFuture() {
        return this.queryFuture;
    }

    @Override
    public DbClientServiceContextImpl statement(String stmt, List<Object> parameters) {
        if (this.stmtParams == DbStatementParameters.UNDEFINED) {
            this.stmtParams = new DbIndexedStatementParameters();
        }
        parameters.forEach(this.stmtParams::addParam);
        this.stmt = stmt;
        return this;
    }

    @Override
    public DbClientServiceContextImpl statement(String stmt, Map<String, Object> parameters) {
        if (this.stmtParams == DbStatementParameters.UNDEFINED) {
            this.stmtParams = new DbNamedStatementParameters();
        }
        parameters.forEach(this.stmtParams::addParam);
        this.stmt = stmt;
        return this;
    }

    @Override
    public DbClientServiceContextImpl parameters(List<Object> parameters) {
        parameters.forEach(this.stmtParams::addParam);
        return this;
    }

    @Override
    public DbClientServiceContextImpl parameters(Map<String, Object> parameters) {
        parameters.forEach(this.stmtParams::addParam);
        return this;
    }

    @Override
    public DbClientServiceContextImpl context(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public DbClientServiceContextImpl statement(String name) {
        this.stmtName = name;
        return this;
    }

    @Override
    public DbClientServiceContextImpl statementName(String name) {
        this.stmtName = name;
        return this;
    }
}

